"use strict";
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
/* eslint-disable dot-notation */
const handler_1 = require("../handler");
describe('VersionProviderResource', () => {
    let versionProviderResource;
    beforeEach(() => {
        versionProviderResource = new handler_1.VersionProviderResource();
    });
    describe('implementsIVersionProviderResourceProperties', () => {
        test('correct input', async () => {
            expect(versionProviderResource['implementsIVersionProviderResourceProperties']({
                versionString: '10.1.9.2',
                forceRun: 'testValue',
            })).toBeTruthy();
        });
        test('correct input no forceRun', async () => {
            expect(versionProviderResource['implementsIVersionProviderResourceProperties']({
                versionString: '10.1.9.2',
            })).toBeTruthy();
        });
        test('correct input with no versionString', async () => {
            expect(versionProviderResource['implementsIVersionProviderResourceProperties']({})).toBeTruthy();
        });
        test('non-object input', async () => {
            expect(versionProviderResource['implementsIVersionProviderResourceProperties']('test')).toBeFalsy();
        });
        test('input with invalid versionString', async () => {
            expect(versionProviderResource['implementsIVersionProviderResourceProperties']({
                versionString: 'version',
            })).toBeFalsy();
        });
        test('input with invalid forceRun', async () => {
            expect(versionProviderResource['implementsIVersionProviderResourceProperties']({
                versionString: '10.1.9.2',
                forceRun: {},
            })).toBeFalsy();
        });
    });
    describe('parseS3BucketName', () => {
        test('correct input', () => {
            expect(versionProviderResource['parseS3BucketName']('s3://bucketName/objectKey')).toEqual('bucketName');
        });
        test.each([
            ':/bucketName/objectKey',
            's3:/bucketName/objectKey',
            's3://bucketName',
            'bucketName',
        ])('malformed input: %p', (s3Uri) => {
            expect(() => versionProviderResource['parseS3BucketName'](s3Uri)).toThrowError(/Could not parse S3 bucket name/);
        });
    });
    describe('parseS3ObjectKey', () => {
        test.each([
            ['s3://bucketName/objectKey', 'objectKey'],
            ['s3://bucketName/objectDirectory/objectName', 'objectDirectory/objectName'],
            ['s3://bucketName/objectDirectory/objectName.run', 'objectDirectory/objectName.run'],
            ['s3://bucketName/objectDirectory/10.1.9.2/objectName.run', 'objectDirectory/10.1.9.2/objectName.run'],
        ])('correct input: %p', (s3Uri, objectKey) => {
            expect(versionProviderResource['parseS3ObjectKey'](s3Uri)).toEqual(objectKey);
        });
        test.each([
            ':/bucketName/objectKey',
            's3:/bucketName/objectKey',
            's3://bucketName',
            'bucketName',
        ])('malformed input: %p', (s3Uri) => {
            expect(() => versionProviderResource['parseS3ObjectKey'](s3Uri)).toThrowError(/Could not parse S3 object key/);
        });
    });
});
//# sourceMappingURL=data:application/json;base64,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