"use strict";
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.writeBinaryFile = exports.writeAsciiFile = exports.readBinaryFile = exports.readAsciiFile = void 0;
const fs = require("fs");
exports.readAsciiFile = async (filename) => {
    const file = await fs.promises.open(filename, 'r');
    try {
        const contents = await file.readFile('utf-8');
        return contents;
    }
    finally {
        await file.close();
    }
};
exports.readBinaryFile = async (filename) => {
    const file = await fs.promises.open(filename, 'r');
    try {
        const contents = await file.readFile();
        return contents;
    }
    finally {
        await file.close();
    }
};
exports.writeAsciiFile = async (filename, contents) => {
    const file = await fs.promises.open(filename, 'w');
    try {
        await file.writeFile(contents, { encoding: 'utf-8' });
    }
    finally {
        await file.close();
    }
};
exports.writeBinaryFile = async (filename, contents) => {
    const file = await fs.promises.open(filename, 'w');
    try {
        await file.writeFile(contents);
    }
    finally {
        await file.close();
    }
};
//# sourceMappingURL=data:application/json;base64,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