"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceAccount = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s_1 = require("cdk8s");
const constructs_1 = require("constructs");
const base = require("./base");
const k8s = require("./imports/k8s");
const utils_1 = require("./utils");
class ImportedServiceAccount extends constructs_1.Construct {
    constructor(scope, id, name) {
        super(scope, id);
        this._name = name;
    }
    get name() {
        return this._name;
    }
    get apiVersion() {
        return k8s.KubeServiceAccount.GVK.apiVersion;
    }
    get apiGroup() {
        return '';
    }
    get kind() {
        return k8s.KubeServiceAccount.GVK.kind;
    }
}
/**
 * A service account provides an identity for processes that run in a Pod.
 *
 * When you (a human) access the cluster (for example, using kubectl), you are
 * authenticated by the apiserver as a particular User Account (currently this
 * is usually admin, unless your cluster administrator has customized your
 * cluster). Processes in containers inside pods can also contact the apiserver.
 * When they do, they are authenticated as a particular Service Account (for
 * example, default).
 *
 * @see https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account
 */
class ServiceAccount extends base.Resource {
    constructor(scope, id, props = {}) {
        super(scope, id);
        this.resourceType = 'serviceaccounts';
        this._secrets = props.secrets ?? [];
        this.automountToken = props.automountToken ?? true;
        this.apiObject = new k8s.KubeServiceAccount(this, 'Resource', {
            metadata: props.metadata,
            secrets: cdk8s_1.Lazy.any({ produce: () => utils_1.undefinedIfEmpty(this._secrets.map(s => ({ name: s.name }))) }),
            automountServiceAccountToken: this.automountToken,
        });
    }
    /**
     * Imports a service account from the cluster as a reference.
     * @param name The name of the service account resource.
     */
    static fromServiceAccountName(scope, id, name) {
        return new ImportedServiceAccount(scope, id, name);
    }
    /**
     * Allow a secret to be accessed by pods using this service account.
     * @param secr The secret
     */
    addSecret(secr) {
        this._secrets.push(secr);
    }
    /**
     * List of secrets allowed to be used by pods running using this service
     * account.
     *
     * Returns a copy. To add a secret, use `addSecret()`.
     */
    get secrets() {
        return [...this._secrets];
    }
    /**
     * @see ISubect.toSubjectConfiguration()
     */
    toSubjectConfiguration() {
        return {
            kind: this.kind,
            name: this.name,
            apiGroup: this.apiGroup,
            namespace: this.metadata.namespace,
        };
    }
}
exports.ServiceAccount = ServiceAccount;
_a = JSII_RTTI_SYMBOL_1;
ServiceAccount[_a] = { fqn: "cdk8s-plus-22.ServiceAccount", version: "2.0.0-rc.116" };
//# sourceMappingURL=data:application/json;base64,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