"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DaemonSet = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s_1 = require("cdk8s");
const k8s = require("./imports/k8s");
const workload = require("./workload");
/**
 * A DaemonSet ensures that all (or some) Nodes run a copy of a Pod.
 * As nodes are added to the cluster, Pods are added to them.
 * As nodes are removed from the cluster, those Pods are garbage collected.
 * Deleting a DaemonSet will clean up the Pods it created.
 *
 * Some typical uses of a DaemonSet are:
 *
 * - running a cluster storage daemon on every node
 * - running a logs collection daemon on every node
 * - running a node monitoring daemon on every node
 *
 * In a simple case, one DaemonSet, covering all nodes, would be used for each type of daemon.
 * A more complex setup might use multiple DaemonSets for a single type of daemon,
 * but with different flags and/or different memory and cpu requests for different hardware types.
 */
class DaemonSet extends workload.Workload {
    constructor(scope, id, props = {}) {
        super(scope, id, props);
        this.resourceType = 'daemonsets';
        this.apiObject = new k8s.KubeDaemonSet(this, 'Resource', {
            metadata: props.metadata,
            spec: cdk8s_1.Lazy.any({ produce: () => this._toKube() }),
        });
        this.minReadySeconds = props.minReadySeconds ?? 0;
    }
    /**
     * @internal
     */
    _toKube() {
        return {
            minReadySeconds: this.minReadySeconds,
            template: {
                metadata: this.podMetadata.toJson(),
                spec: this._toPodSpec(),
            },
            selector: this._toLabelSelector(),
        };
    }
}
exports.DaemonSet = DaemonSet;
_a = JSII_RTTI_SYMBOL_1;
DaemonSet[_a] = { fqn: "cdk8s-plus-22.DaemonSet", version: "2.0.0-rc.116" };
//# sourceMappingURL=data:application/json;base64,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