# Software Classification Documents
## Software Classification: Class-E

## Compliance Notation Legend
FC: Fully Compliant

T: Tailored (Specific tailoring described in mitigation)[SWE-121](https://swehb.nasa.gov/display/7150/SWE-121+-+Document+Alternate+Requirements)

PC: Partially Compliant

NC: Not Compliant

NA: Not Applicable

## Class-E Compliance Matrix
| NPR SWE #| Requirement Text |Comply | Evidence |
|:---|:--|:--|:--|
| [033](https://swehb.nasa.gov/display/SWEHBVC/SWE-033+-+Acquisition+vs.+Development+Assessment) | The project manager shall assess options for software acquisition versus development | FC | Assessed, there are some existing prognostics tools, but no general python package that can support model-based prognostics like we need.  |
| [013](https://swehb.nasa.gov/display/SWEHBVC/SWE-013+-+Software+Plans) | The project manager shall develop, maintain, and execute software plans that cover the entire software life cycle and, as a minimum, address the requirements of this directive with approved tailoring | FC | See docs/ folder |
| [042](https://swehb.nasa.gov/display/SWEHBVC/SWE-042+-+Source+Code+Electronic+Access) | The project manager shall require the software developer(s) to provide NASA with electronic access to the source code developed for the project in a modifiable format.| FC | See git repository|
| [139](https://swehb.nasa.gov/display/SWEHBVC/SWE-139+-+Shall+Statements) | The project manager shall comply with the requirements in this NPR that are marked with an ”X” in Appendix C consistent with their software classification. | FC | This document describes compliance with NPR requirements |
| [121](https://swehb.nasa.gov/display/SWEHBVC/SWE-121+-+Document+Tailored+Requirements) | Where approved, the project manager shall document and reflect the tailored requirement in the plans or procedures controlling the development, acquisition, and deployment of the affected software. | FC | This Document |
| [125](https://swehb.nasa.gov/display/SWEHBVC/SWE-125+-+Requirements+Compliance+Matrix) | Each project manager with software components shall maintain a requirements mapping matrix or multiple requirements mapping matrices against requirements in this NPR, including those delegated to other parties or accomplished by contract vehicles or Space Act Agreements. | FC | This document |
| [029](https://swehb.nasa.gov/display/SWEHBVC/SWE-020+-+Software+Classification) | The project manager shall classify each system and subsystem containing software in accordance with the highest applicable software classification definitions for Classes A, B, C, D, E, and F software in Appendix D. | FC | This document |
| [022](https://swehb.nasa.gov/display/SWEHBVC/SWE-022+-+Software+Assurance) | The project manager shall plan and implement software assurance per [NASA-STD-8739.8](https://standards.nasa.gov/file/2640/download?token=GE2uRzcJ) | FC | See softwareplan.md |
| [205](https://swehb.nasa.gov/display/SWEHBVC/SWE-205+-+Determination+of+Safety-Critical+Software) | The project manager, in conjunction with the SMA organization, shall determine if each software component is considered to be safety-critical per the criteria defined in [NASA-STD-8739.8](https://standards.nasa.gov/file/2640/download?token=GE2uRzcJ). | NA | Not safety Critical |
| [023](https://swehb.nasa.gov/display/SWEHBVC/SWE-023+-+Software+Safety-Critical+Requirements) | If a project has safety-critical software, the project manager shall implement the safety-critical software requirements contained in [NASA-STD-8739.8](https://standards.nasa.gov/file/2640/download?token=GE2uRzcJ). | NA | Not Safety Critical|
| [206](https://swehb.nasa.gov/display/SWEHBVC/SWE-206+-+Auto-Generation+Software+Inputs) | The project manager shall require the software developers and suppliers to provide NASA with electronic access to the models, simulations, and associated data used as inputs for auto-generation of software. | FC | No auto generation|
| [148](https://swehb.nasa.gov/display/SWEHBVC/SWE-148+-+Contribute+to+Agency+Software+Catalog) | The project manager shall evaluate software for potential reuse by other projects across NASA and contribute reuse candidates to the NASA Internal Sharing and Reuse Software systems. However, if the project manager is a contractor, then a civil servant must pre-approve all such software contributions; all software contributions should include, at a minimum, the following information:<br> 1.  Software Title. <br> 2.  Software Description. <br> 3.  The Civil Servant Software Technical Point of Contact for the software product.<br> 4.  The language or languages used to develop the software.<br> 5.  Any third party code contained therein and the record of the requisite license or permission received from the third party permitting the Government’s use, if applicable. | FC | Will contribute |
| [156](https://swehb.nasa.gov/display/SWEHBVC/SWE-156+-+Evaluate+Systems+for+Security+Risks) | The project manager shall perform a software cybersecurity assessment on the software components per the Agency security policies and the project requirements, including risks posed by the use of COTS, GOTS, MOTS, OSS, or reused software components. | FC | Was evaluated in bitbucket code review|
