import { SecretValue } from 'aws-cdk-lib';
import { CfnConnectorProfile } from 'aws-cdk-lib/aws-appflow';
import { Construct } from 'constructs';
import { ConnectorProfileBase, ConnectorProfileProps } from '../core/connectors/connector-profile';
export interface SlackConnectorProfileProps extends ConnectorProfileProps {
    readonly oAuth: SlackOAuthSettings;
    readonly instanceUrl: string;
}
export interface SlackOAuthSettings {
    readonly accessToken: SecretValue;
    readonly clientId?: SecretValue;
    readonly clientSecret?: SecretValue;
}
export declare class SlackConnectorProfile extends ConnectorProfileBase {
    static fromConnectionProfileArn(scope: Construct, id: string, arn: string): SlackConnectorProfile;
    static fromConnectionProfileName(scope: Construct, id: string, name: string): SlackConnectorProfile;
    constructor(scope: Construct, id: string, props: SlackConnectorProfileProps);
    protected buildConnectorProfileProperties(props: ConnectorProfileProps): CfnConnectorProfile.ConnectorProfilePropertiesProperty;
    protected buildConnectorProfileCredentials(props: ConnectorProfileProps): CfnConnectorProfile.ConnectorProfileCredentialsProperty;
}
