"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SAPOdataConnectorProfile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const connector_profile_1 = require("../core/connectors/connector-profile");
class SAPOdataConnectorProfile extends connector_profile_1.ConnectorProfileBase {
    static fromConnectionProfileArn(scope, id, arn) {
        return this._fromConnectorProfileAttributes(scope, id, { arn });
    }
    static fromConnectionProfileName(scope, id, name) {
        return this._fromConnectorProfileAttributes(scope, id, { name });
    }
    constructor(scope, id, props) {
        super(scope, id, props, type_1.SAPOdataConnectorType.instance);
    }
    buildConnectorProfileCredentials(props) {
        const properties = props;
        let sapOdata = {};
        if (properties.basicAuth) {
            sapOdata.basicAuthCredentials = {
                username: properties.basicAuth.username,
                password: properties.basicAuth.password.unsafeUnwrap(),
            };
        }
        else if (properties.oAuth) {
            sapOdata.oAuthCredentials = {
                accessToken: properties.oAuth.accessToken?.unsafeUnwrap(),
                refreshToken: properties.oAuth.flow?.refreshTokenGrant.refreshToken?.unsafeUnwrap(),
                clientId: properties.oAuth.flow?.refreshTokenGrant.clientId?.unsafeUnwrap(),
                clientSecret: properties.oAuth.flow?.refreshTokenGrant.clientSecret?.unsafeUnwrap(),
            };
        }
        return {
            sapoData: sapOdata,
        };
    }
    buildConnectorProfileProperties(props) {
        const properties = props;
        return {
            sapoData: {
                applicationHostUrl: properties.applicationHostUrl,
                applicationServicePath: properties.applicationServicePath,
                portNumber: properties.portNumber,
                clientNumber: properties.clientNumber,
                logonLanguage: properties.logonLanguage,
            },
        };
    }
}
exports.SAPOdataConnectorProfile = SAPOdataConnectorProfile;
_a = JSII_RTTI_SYMBOL_1;
SAPOdataConnectorProfile[_a] = { fqn: "@cdklabs/cdk-appflow.SAPOdataConnectorProfile", version: "0.0.32" };
//# sourceMappingURL=data:application/json;base64,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