"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SalesforceSource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
class SalesforceSource {
    constructor(props) {
        this.props = props;
        this.connectorType = type_1.SalesforceConnectorType.instance;
    }
    bind(flow) {
        this.tryAddNodeDependency(flow, this.props.profile);
        return {
            connectorType: this.connectorType.asProfileConnectorType,
            connectorProfileName: this.props.profile.name,
            apiVersion: this.props.apiVersion,
            sourceConnectorProperties: this.buildSourceConnectorProperties(),
        };
    }
    buildSourceConnectorProperties() {
        return {
            salesforce: {
                dataTransferApi: this.props.dataTransferApi,
                enableDynamicFieldUpdate: this.props.enableDynamicFieldUpdate,
                includeDeletedRecords: this.props.includeDeletedRecords,
                object: this.props.object,
            },
        };
    }
    tryAddNodeDependency(scope, resource) {
        if (resource && typeof resource !== 'string') {
            scope.node.addDependency(resource);
        }
    }
}
exports.SalesforceSource = SalesforceSource;
_a = JSII_RTTI_SYMBOL_1;
SalesforceSource[_a] = { fqn: "@cdklabs/cdk-appflow.SalesforceSource", version: "0.0.32" };
//# sourceMappingURL=data:application/json;base64,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