"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SalesforceConnectorProfile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const connector_profile_1 = require("../core/connectors/connector-profile");
class SalesforceConnectorProfile extends connector_profile_1.ConnectorProfileBase {
    static fromConnectionProfileArn(scope, id, arn) {
        return this._fromConnectorProfileAttributes(scope, id, { arn });
    }
    static fromConnectionProfileName(scope, id, name) {
        return this._fromConnectorProfileAttributes(scope, id, { name });
    }
    constructor(scope, id, props) {
        super(scope, id, props, type_1.SalesforceConnectorType.instance);
        this.tryAddNodeDependency(this, props.oAuth.flow?.refreshTokenGrant?.client);
    }
    buildConnectorProfileProperties(properties) {
        const props = properties;
        return {
            salesforce: {
                isSandboxEnvironment: props.isSandbox,
                instanceUrl: props.instanceUrl,
            },
        };
    }
    buildConnectorProfileCredentials(properties) {
        const props = properties;
        let salesforce = {};
        salesforce.accessToken = props.oAuth.accessToken?.unsafeUnwrap();
        const refreshTokenGrant = props.oAuth.flow?.refreshTokenGrant;
        salesforce.refreshToken = refreshTokenGrant?.refreshToken?.unsafeUnwrap() ?? 'dummyRefreshToken';
        if (refreshTokenGrant?.client) {
            salesforce.clientCredentialsArn = refreshTokenGrant.client.secretArn;
            // TODO: make sure why this doesn't work.
            //       this doc says it should: https://docs.aws.amazon.com/appflow/latest/userguide/salesforce.html
            //       in order to obtain the access token I needed to follow: https://medium.com/@bpmmendis94/obtain-access-refresh-tokens-from-salesforce-rest-api-a324fe4ccd9b
            salesforce.accessToken = salesforce.accessToken ?? 'dummyAccessToken';
        }
        return {
            salesforce: salesforce,
        };
    }
}
exports.SalesforceConnectorProfile = SalesforceConnectorProfile;
_a = JSII_RTTI_SYMBOL_1;
SalesforceConnectorProfile[_a] = { fqn: "@cdklabs/cdk-appflow.SalesforceConnectorProfile", version: "0.0.32" };
//# sourceMappingURL=data:application/json;base64,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