"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SalesforceDestination = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const appflow_permissions_manager_1 = require("../core/appflow-permissions-manager");
class SalesforceDestination {
    constructor(props) {
        this.props = props;
        this.connectorType = type_1.SalesforceConnectorType.instance;
    }
    bind(flow) {
        this.tryAddNodeDependency(flow, this.props.errorHandling?.errorLocation?.bucket);
        appflow_permissions_manager_1.AppFlowPermissionsManager.instance().grantBucketWrite(this.props.errorHandling?.errorLocation?.bucket);
        this.tryAddNodeDependency(flow, this.props.profile);
        return {
            connectorType: this.connectorType.asProfileConnectorType,
            connectorProfileName: this.props.profile.name,
            destinationConnectorProperties: this.buildDestinationConnectorProperties(),
        };
    }
    buildDestinationConnectorProperties() {
        return {
            salesforce: {
                dataTransferApi: this.props.dataTransferApi,
                errorHandlingConfig: this.props.errorHandling && {
                    bucketName: this.props.errorHandling?.errorLocation?.bucket.bucketName,
                    bucketPrefix: this.props.errorHandling?.errorLocation?.prefix,
                    failOnFirstError: this.props.errorHandling.failOnFirstError,
                },
                idFieldNames: this.props.operation.ids,
                object: this.props.object,
                writeOperationType: this.props.operation.type,
            },
        };
    }
    tryAddNodeDependency(scope, resource) {
        if (resource && typeof resource !== 'string') {
            scope.node.addDependency(resource);
        }
    }
}
exports.SalesforceDestination = SalesforceDestination;
_a = JSII_RTTI_SYMBOL_1;
SalesforceDestination[_a] = { fqn: "@cdklabs/cdk-appflow.SalesforceDestination", version: "0.0.32" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGVzdGluYXRpb24uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvc2FsZXNmb3JjZS9kZXN0aW5hdGlvbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQVFBLGlDQUFpRDtBQUNqRCxxRkFBZ0Y7QUE2QmhGLE1BQWEscUJBQXFCO0lBSWhDLFlBQTZCLEtBQWlDO1FBQWpDLFVBQUssR0FBTCxLQUFLLENBQTRCO1FBRjlDLGtCQUFhLEdBQWtCLDhCQUF1QixDQUFDLFFBQVEsQ0FBQztJQUVkLENBQUM7SUFFbkUsSUFBSSxDQUFDLElBQVc7UUFFZCxJQUFJLENBQUMsb0JBQW9CLENBQUMsSUFBSSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsYUFBYSxFQUFFLGFBQWEsRUFBRSxNQUFNLENBQUMsQ0FBQztRQUNqRix1REFBeUIsQ0FBQyxRQUFRLEVBQUUsQ0FBQyxnQkFBZ0IsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLGFBQWEsRUFBRSxhQUFhLEVBQUUsTUFBTSxDQUFDLENBQUM7UUFDdkcsSUFBSSxDQUFDLG9CQUFvQixDQUFDLElBQUksRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBRXBELE9BQU87WUFDTCxhQUFhLEVBQUUsSUFBSSxDQUFDLGFBQWEsQ0FBQyxzQkFBc0I7WUFDeEQsb0JBQW9CLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsSUFBSTtZQUM3Qyw4QkFBOEIsRUFBRSxJQUFJLENBQUMsbUNBQW1DLEVBQUU7U0FDM0UsQ0FBQztJQUNKLENBQUM7SUFFTyxtQ0FBbUM7UUFDekMsT0FBTztZQUNMLFVBQVUsRUFBRTtnQkFDVixlQUFlLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxlQUFlO2dCQUMzQyxtQkFBbUIsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLGFBQWEsSUFBSTtvQkFDL0MsVUFBVSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsYUFBYSxFQUFFLGFBQWEsRUFBRSxNQUFNLENBQUMsVUFBVTtvQkFDdEUsWUFBWSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsYUFBYSxFQUFFLGFBQWEsRUFBRSxNQUFNO29CQUM3RCxnQkFBZ0IsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLGFBQWEsQ0FBQyxnQkFBZ0I7aUJBQzVEO2dCQUNELFlBQVksRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFNBQVMsQ0FBQyxHQUFHO2dCQUN0QyxNQUFNLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxNQUFNO2dCQUN6QixrQkFBa0IsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFNBQVMsQ0FBQyxJQUFJO2FBQzlDO1NBQ0YsQ0FBQztJQUNKLENBQUM7SUFFTyxvQkFBb0IsQ0FBQyxLQUFpQixFQUFFLFFBQThCO1FBQzVFLElBQUksUUFBUSxJQUFJLE9BQU8sUUFBUSxLQUFLLFFBQVEsRUFBRTtZQUM1QyxLQUFLLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxRQUFRLENBQUMsQ0FBQztTQUNwQztJQUNILENBQUM7O0FBdkNILHNEQXlDQyIsInNvdXJjZXNDb250ZW50IjpbIi8qXG5Db3B5cmlnaHQgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cblNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4qL1xuaW1wb3J0IHsgQ2ZuRmxvdyB9IGZyb20gJ2F3cy1jZGstbGliL2F3cy1hcHBmbG93JztcbmltcG9ydCB7IElDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IFNhbGVzZm9yY2VDb25uZWN0b3JQcm9maWxlIH0gZnJvbSAnLi9wcm9maWxlJztcbmltcG9ydCB7IFNhbGVzZm9yY2VEYXRhVHJhbnNmZXJBcGkgfSBmcm9tICcuL3NhbGVzZm9yY2UtZGF0YS10cmFuc2Zlci1hcGknO1xuaW1wb3J0IHsgU2FsZXNmb3JjZUNvbm5lY3RvclR5cGUgfSBmcm9tICcuL3R5cGUnO1xuaW1wb3J0IHsgQXBwRmxvd1Blcm1pc3Npb25zTWFuYWdlciB9IGZyb20gJy4uL2NvcmUvYXBwZmxvdy1wZXJtaXNzaW9ucy1tYW5hZ2VyJztcbmltcG9ydCB7IENvbm5lY3RvclR5cGUgfSBmcm9tICcuLi9jb3JlL2Nvbm5lY3RvcnMvY29ubmVjdG9yLXR5cGUnO1xuaW1wb3J0IHsgRXJyb3JIYW5kbGluZ0NvbmZpZ3VyYXRpb24gfSBmcm9tICcuLi9jb3JlL2Vycm9yLWhhbmRsaW5nJztcbmltcG9ydCB7IElGbG93IH0gZnJvbSAnLi4vY29yZS9mbG93cyc7XG5pbXBvcnQgeyBJRGVzdGluYXRpb24gfSBmcm9tICcuLi9jb3JlL3ZlcnRpY2VzL2Rlc3RpbmF0aW9uJztcbmltcG9ydCB7IFdyaXRlT3BlcmF0aW9uIH0gZnJvbSAnLi4vY29yZS93cml0ZS1vcGVyYXRpb24nO1xuXG5leHBvcnQgaW50ZXJmYWNlIFNhbGVzZm9yY2VEZXN0aW5hdGlvblByb3BzIHtcblxuICByZWFkb25seSBwcm9maWxlOiBTYWxlc2ZvcmNlQ29ubmVjdG9yUHJvZmlsZTtcblxuICAvKipcbiAgICogU3BlY2lmaWVzIHdoaWNoIFNhbGVzZm9yY2UgQVBJIGlzIHVzZWQgYnkgQW1hem9uIEFwcEZsb3cgd2hlbiB5b3VyIGZsb3cgdHJhbnNmZXJzIGRhdGEgdG8gU2FsZXNmb3JjZS5cbiAgICovXG4gIHJlYWRvbmx5IGRhdGFUcmFuc2ZlckFwaT86IFNhbGVzZm9yY2VEYXRhVHJhbnNmZXJBcGk7XG5cbiAgLyoqXG4gICAqIFRoZSBzZXR0aW5ncyB0aGF0IGRldGVybWluZSBob3cgQW1hem9uIEFwcEZsb3cgaGFuZGxlcyBhbiBlcnJvciB3aGVuIHBsYWNpbmcgZGF0YSBpbiB0aGUgU2FsZXNmb3JjZSBkZXN0aW5hdGlvbi4gRm9yIGV4YW1wbGUsIHRoaXMgc2V0dGluZyB3b3VsZCBkZXRlcm1pbmUgaWYgdGhlIGZsb3cgc2hvdWxkIGZhaWwgYWZ0ZXIgb25lIGluc2VydGlvbiBlcnJvciwgb3IgY29udGludWUgYW5kIGF0dGVtcHQgdG8gaW5zZXJ0IGV2ZXJ5IHJlY29yZCByZWdhcmRsZXNzIG9mIHRoZSBpbml0aWFsIGZhaWx1cmUuXG4gICAqL1xuICByZWFkb25seSBlcnJvckhhbmRsaW5nPzogRXJyb3JIYW5kbGluZ0NvbmZpZ3VyYXRpb247XG5cbiAgLyoqXG4gICAqIFRoZSBTYWxlc2ZvcmNlIG9iamVjdCBmb3Igd2hpY2ggdGhlIG9wZXJhdGlvbiBpcyB0byBiZSBzZXQuXG4gICAqL1xuICByZWFkb25seSBvYmplY3Q6IHN0cmluZztcblxuICByZWFkb25seSBvcGVyYXRpb246IFdyaXRlT3BlcmF0aW9uO1xufVxuXG5leHBvcnQgY2xhc3MgU2FsZXNmb3JjZURlc3RpbmF0aW9uIGltcGxlbWVudHMgSURlc3RpbmF0aW9uIHtcblxuICBwdWJsaWMgcmVhZG9ubHkgY29ubmVjdG9yVHlwZTogQ29ubmVjdG9yVHlwZSA9IFNhbGVzZm9yY2VDb25uZWN0b3JUeXBlLmluc3RhbmNlO1xuXG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgcHJvcHM6IFNhbGVzZm9yY2VEZXN0aW5hdGlvblByb3BzKSB7IH1cblxuICBiaW5kKGZsb3c6IElGbG93KTogQ2ZuRmxvdy5EZXN0aW5hdGlvbkZsb3dDb25maWdQcm9wZXJ0eSB7XG5cbiAgICB0aGlzLnRyeUFkZE5vZGVEZXBlbmRlbmN5KGZsb3csIHRoaXMucHJvcHMuZXJyb3JIYW5kbGluZz8uZXJyb3JMb2NhdGlvbj8uYnVja2V0KTtcbiAgICBBcHBGbG93UGVybWlzc2lvbnNNYW5hZ2VyLmluc3RhbmNlKCkuZ3JhbnRCdWNrZXRXcml0ZSh0aGlzLnByb3BzLmVycm9ySGFuZGxpbmc/LmVycm9yTG9jYXRpb24/LmJ1Y2tldCk7XG4gICAgdGhpcy50cnlBZGROb2RlRGVwZW5kZW5jeShmbG93LCB0aGlzLnByb3BzLnByb2ZpbGUpO1xuXG4gICAgcmV0dXJuIHtcbiAgICAgIGNvbm5lY3RvclR5cGU6IHRoaXMuY29ubmVjdG9yVHlwZS5hc1Byb2ZpbGVDb25uZWN0b3JUeXBlLFxuICAgICAgY29ubmVjdG9yUHJvZmlsZU5hbWU6IHRoaXMucHJvcHMucHJvZmlsZS5uYW1lLFxuICAgICAgZGVzdGluYXRpb25Db25uZWN0b3JQcm9wZXJ0aWVzOiB0aGlzLmJ1aWxkRGVzdGluYXRpb25Db25uZWN0b3JQcm9wZXJ0aWVzKCksXG4gICAgfTtcbiAgfVxuXG4gIHByaXZhdGUgYnVpbGREZXN0aW5hdGlvbkNvbm5lY3RvclByb3BlcnRpZXMoKTogQ2ZuRmxvdy5EZXN0aW5hdGlvbkNvbm5lY3RvclByb3BlcnRpZXNQcm9wZXJ0eSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIHNhbGVzZm9yY2U6IHtcbiAgICAgICAgZGF0YVRyYW5zZmVyQXBpOiB0aGlzLnByb3BzLmRhdGFUcmFuc2ZlckFwaSxcbiAgICAgICAgZXJyb3JIYW5kbGluZ0NvbmZpZzogdGhpcy5wcm9wcy5lcnJvckhhbmRsaW5nICYmIHtcbiAgICAgICAgICBidWNrZXROYW1lOiB0aGlzLnByb3BzLmVycm9ySGFuZGxpbmc/LmVycm9yTG9jYXRpb24/LmJ1Y2tldC5idWNrZXROYW1lLFxuICAgICAgICAgIGJ1Y2tldFByZWZpeDogdGhpcy5wcm9wcy5lcnJvckhhbmRsaW5nPy5lcnJvckxvY2F0aW9uPy5wcmVmaXgsXG4gICAgICAgICAgZmFpbE9uRmlyc3RFcnJvcjogdGhpcy5wcm9wcy5lcnJvckhhbmRsaW5nLmZhaWxPbkZpcnN0RXJyb3IsXG4gICAgICAgIH0sXG4gICAgICAgIGlkRmllbGROYW1lczogdGhpcy5wcm9wcy5vcGVyYXRpb24uaWRzLFxuICAgICAgICBvYmplY3Q6IHRoaXMucHJvcHMub2JqZWN0LFxuICAgICAgICB3cml0ZU9wZXJhdGlvblR5cGU6IHRoaXMucHJvcHMub3BlcmF0aW9uLnR5cGUsXG4gICAgICB9LFxuICAgIH07XG4gIH1cblxuICBwcml2YXRlIHRyeUFkZE5vZGVEZXBlbmRlbmN5KHNjb3BlOiBJQ29uc3RydWN0LCByZXNvdXJjZT86IElDb25zdHJ1Y3QgfCBzdHJpbmcpIHtcbiAgICBpZiAocmVzb3VyY2UgJiYgdHlwZW9mIHJlc291cmNlICE9PSAnc3RyaW5nJykge1xuICAgICAgc2NvcGUubm9kZS5hZGREZXBlbmRlbmN5KHJlc291cmNlKTtcbiAgICB9XG4gIH1cblxufVxuIl19