import { CfnFlow } from 'aws-cdk-lib/aws-appflow';
import { SalesforceConnectorProfile } from './profile';
import { SalesforceDataTransferApi } from './salesforce-data-transfer-api';
import { ConnectorType } from '../core/connectors/connector-type';
import { ErrorHandlingConfiguration } from '../core/error-handling';
import { IFlow } from '../core/flows';
import { IDestination } from '../core/vertices/destination';
import { WriteOperation } from '../core/write-operation';
export interface SalesforceDestinationProps {
    readonly profile: SalesforceConnectorProfile;
    /**
     * Specifies which Salesforce API is used by Amazon AppFlow when your flow transfers data to Salesforce.
     */
    readonly dataTransferApi?: SalesforceDataTransferApi;
    /**
     * The settings that determine how Amazon AppFlow handles an error when placing data in the Salesforce destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure.
     */
    readonly errorHandling?: ErrorHandlingConfiguration;
    /**
     * The Salesforce object for which the operation is to be set.
     */
    readonly object: string;
    readonly operation: WriteOperation;
}
export declare class SalesforceDestination implements IDestination {
    private readonly props;
    readonly connectorType: ConnectorType;
    constructor(props: SalesforceDestinationProps);
    bind(flow: IFlow): CfnFlow.DestinationFlowConfigProperty;
    private buildDestinationConnectorProperties;
    private tryAddNodeDependency;
}
