"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SalesforceMarketingCloudConnectorProfile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const connector_authentication_type_1 = require("../core/connectors/connector-authentication-type");
const connector_profile_1 = require("../core/connectors/connector-profile");
const oauth2_granttype_1 = require("../core/connectors/oauth2-granttype");
class SalesforceMarketingCloudConnectorProfile extends connector_profile_1.ConnectorProfileBase {
    static fromConnectionProfileArn(scope, id, arn) {
        return this._fromConnectorProfileAttributes(scope, id, { arn });
    }
    static fromConnectionProfileName(scope, id, name) {
        return this._fromConnectorProfileAttributes(scope, id, { name });
    }
    constructor(scope, id, props) {
        super(scope, id, props, type_1.SalesforceMarketingCloudConnectorType.instance);
    }
    buildConnectorProfileProperties(props) {
        const properties = props;
        return {
            customConnector: {
                oAuth2Properties: {
                    oAuth2GrantType: oauth2_granttype_1.OAuth2GrantType.CLIENT_CREDENTIALS,
                    tokenUrl: properties.oAuth.endpoints.token,
                },
                profileProperties: {
                    instanceUrl: properties.instanceUrl,
                },
            },
        };
    }
    buildConnectorProfileCredentials(props) {
        const properties = props;
        return {
            customConnector: {
                oauth2: {
                    accessToken: properties.oAuth.accessToken?.unsafeUnwrap(),
                    clientId: properties.oAuth.flow?.clientCredentials.clientId?.unsafeUnwrap(),
                    clientSecret: properties.oAuth.flow?.clientCredentials.clientSecret?.unsafeUnwrap(),
                },
                authenticationType: connector_authentication_type_1.ConnectorAuthenticationType.OAUTH2,
            },
        };
    }
}
exports.SalesforceMarketingCloudConnectorProfile = SalesforceMarketingCloudConnectorProfile;
_a = JSII_RTTI_SYMBOL_1;
SalesforceMarketingCloudConnectorProfile[_a] = { fqn: "@cdklabs/cdk-appflow.SalesforceMarketingCloudConnectorProfile", version: "0.0.32" };
//# sourceMappingURL=data:application/json;base64,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