import { CfnFlow } from 'aws-cdk-lib/aws-appflow';
import { IBucket } from 'aws-cdk-lib/aws-s3';
import { ConnectorType } from '../core/connectors/connector-type';
import { IFlow } from '../core/flows';
import { ISource } from '../core/vertices/source';
/**
 * The file type that Amazon AppFlow gets from your Amazon S3 bucket.
 */
export declare enum S3InputFileType {
    CSV = "CSV",
    JSON = "JSON"
}
export interface S3InputFormat {
    readonly type: S3InputFileType;
}
export interface S3SourceProps {
    readonly bucket: IBucket;
    readonly prefix: string;
    readonly format?: S3InputFormat;
}
export declare class S3Source implements ISource {
    private readonly props;
    readonly connectorType: ConnectorType;
    constructor(props: S3SourceProps);
    bind(scope: IFlow): CfnFlow.SourceFlowConfigProperty;
    private buildSourceConnectorProperties;
    private tryAddNodeDependency;
}
