"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MicrosoftSharepointOnlineSource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const aws_cdk_lib_1 = require("aws-cdk-lib");
const type_1 = require("./type");
/**
 * A class that represents a Microsoft Sharepoint Online Source
 */
class MicrosoftSharepointOnlineSource {
    constructor(props) {
        this.props = props;
        /**
         * The AppFlow type of the connector that this source is implemented for
         */
        this.connectorType = type_1.MicrosoftSharepointOnlineConnectorType.instance;
    }
    bind(scope) {
        this.tryAddNodeDependency(scope, this.props.profile);
        return {
            connectorType: this.connectorType.asProfileConnectorType,
            connectorProfileName: this.props.profile.name,
            apiVersion: this.props.apiVersion,
            sourceConnectorProperties: this.buildSourceConnectorProperties(),
        };
    }
    buildSourceConnectorProperties() {
        if (this.props.object.entities && this.props.object.drives) {
            throw new Error('Only one of the properties entities or drives should be specified');
        }
        const entities = this.props.object.entities ?? this.props.object.drives ?? [];
        if (entities.length < 1) {
            throw new Error('At least one entity must be specified');
        }
        return {
            customConnector: {
                entityName: this.props.object.site,
                customProperties: {
                    subEntities: `["${aws_cdk_lib_1.Fn.join('","', entities)}"]`,
                },
            },
        };
    }
    tryAddNodeDependency(scope, resource) {
        if (resource && typeof resource !== 'string') {
            scope.node.addDependency(resource);
        }
    }
}
exports.MicrosoftSharepointOnlineSource = MicrosoftSharepointOnlineSource;
_a = JSII_RTTI_SYMBOL_1;
MicrosoftSharepointOnlineSource[_a] = { fqn: "@cdklabs/cdk-appflow.MicrosoftSharepointOnlineSource", version: "0.0.32" };
//# sourceMappingURL=data:application/json;base64,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