"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MicrosoftSharepointOnlineConnectorProfile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const util_1 = require("./util");
const connector_authentication_type_1 = require("../core/connectors/connector-authentication-type");
const connector_profile_1 = require("../core/connectors/connector-profile");
const oauth2_granttype_1 = require("../core/connectors/oauth2-granttype");
/**
 * A class that represents a Microsoft Sharepoint Online Connector Profile.
 *
 * This connector profile allows to transfer document libraries residing on a Microsoft Sharepoint Online's site to Amazon S3.
 */
class MicrosoftSharepointOnlineConnectorProfile extends connector_profile_1.ConnectorProfileBase {
    static fromConnectionProfileArn(scope, id, arn) {
        return this._fromConnectorProfileAttributes(scope, id, { arn });
    }
    static fromConnectionProfileName(scope, id, name) {
        return this._fromConnectorProfileAttributes(scope, id, { name });
    }
    constructor(scope, id, props) {
        super(scope, id, props, type_1.MicrosoftSharepointOnlineConnectorType.instance);
    }
    buildConnectorProfileProperties(props) {
        const properties = props;
        return {
            customConnector: {
                oAuth2Properties: {
                    // INFO: even if we're using a refresh token grant flow this property is required
                    oAuth2GrantType: oauth2_granttype_1.OAuth2GrantType.AUTHORIZATION_CODE,
                    // INFO: even if we provide only the access token this property is required
                    // TODO: think about if this is correct. token can be IResolvable
                    tokenUrl: properties.oAuth.endpoints?.token ?? MicrosoftSharepointOnlineConnectorProfile.defaultTokenEndpoint,
                },
            },
        };
    }
    buildConnectorProfileCredentials(props) {
        const properties = props;
        return {
            customConnector: {
                oauth2: {
                    // INFO: when using Refresh Token Grant Flow - access token property is required
                    accessToken: properties.oAuth.accessToken?.unsafeUnwrap() ?? 'dummyAccessToken',
                    // INFO: when passing only an access token - this value is still required
                    refreshToken: properties.oAuth.flow?.refreshTokenGrant.refreshToken?.unsafeUnwrap() ?? 'dummyRefreshToken',
                    clientId: properties.oAuth.flow?.refreshTokenGrant.clientId?.unsafeUnwrap(),
                    clientSecret: properties.oAuth.flow?.refreshTokenGrant.clientSecret?.unsafeUnwrap(),
                },
                authenticationType: connector_authentication_type_1.ConnectorAuthenticationType.OAUTH2,
            },
        };
    }
}
exports.MicrosoftSharepointOnlineConnectorProfile = MicrosoftSharepointOnlineConnectorProfile;
_a = JSII_RTTI_SYMBOL_1;
MicrosoftSharepointOnlineConnectorProfile[_a] = { fqn: "@cdklabs/cdk-appflow.MicrosoftSharepointOnlineConnectorProfile", version: "0.0.32" };
MicrosoftSharepointOnlineConnectorProfile.defaultTokenEndpoint = util_1.MicrosoftSharepointOnlineTokenUrlBuilder.buildTokenUrl();
//# sourceMappingURL=data:application/json;base64,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