"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MicrosoftDynamics365ConnectorProfile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const util_1 = require("./util");
const connector_authentication_type_1 = require("../core/connectors/connector-authentication-type");
const connector_profile_1 = require("../core/connectors/connector-profile");
const oauth2_granttype_1 = require("../core/connectors/oauth2-granttype");
/**
 * A class that represents a Microsoft Dynamics 365 Connector Profile.
 *
 * This connector profile allows to transfer document libraries residing on a Microsoft Dynamics 365's site to Amazon S3.
 */
class MicrosoftDynamics365ConnectorProfile extends connector_profile_1.ConnectorProfileBase {
    static fromConnectionProfileArn(scope, id, arn) {
        return this._fromConnectorProfileAttributes(scope, id, { arn });
    }
    static fromConnectionProfileName(scope, id, name) {
        return this._fromConnectorProfileAttributes(scope, id, { name });
    }
    constructor(scope, id, props) {
        super(scope, id, props, type_1.MicrosoftDynamics365ConnectorType.instance);
    }
    buildConnectorProfileProperties(props) {
        const properties = props;
        return {
            customConnector: {
                profileProperties: {
                    instanceUrl: properties.instanceUrl,
                },
                oAuth2Properties: {
                    // INFO: even if we're using a refresh token grant flow this property is required
                    oAuth2GrantType: oauth2_granttype_1.OAuth2GrantType.AUTHORIZATION_CODE,
                    // INFO: even if we provide only the access token this property is required
                    // TODO: think about if this is correct. token can be IResolvable
                    tokenUrl: properties.oAuth.endpoints?.token ?? MicrosoftDynamics365ConnectorProfile.defaultTokenEndpoint,
                },
            },
        };
    }
    buildConnectorProfileCredentials(props) {
        const properties = props;
        return {
            customConnector: {
                oauth2: {
                    // INFO: when using Refresh Token Grant Flow - access token property is required
                    accessToken: properties.oAuth.accessToken?.unsafeUnwrap() ?? 'dummyAccessToken',
                    // INFO: when passing only an access token - this value is still required
                    refreshToken: properties.oAuth.flow?.refreshTokenGrant.refreshToken?.unsafeUnwrap() ?? 'dummyRefreshToken',
                    clientId: properties.oAuth.flow?.refreshTokenGrant.clientId?.unsafeUnwrap(),
                    clientSecret: properties.oAuth.flow?.refreshTokenGrant.clientSecret?.unsafeUnwrap(),
                },
                authenticationType: connector_authentication_type_1.ConnectorAuthenticationType.OAUTH2,
            },
        };
    }
}
exports.MicrosoftDynamics365ConnectorProfile = MicrosoftDynamics365ConnectorProfile;
_a = JSII_RTTI_SYMBOL_1;
MicrosoftDynamics365ConnectorProfile[_a] = { fqn: "@cdklabs/cdk-appflow.MicrosoftDynamics365ConnectorProfile", version: "0.0.32" };
MicrosoftDynamics365ConnectorProfile.defaultTokenEndpoint = util_1.MicrosoftDynamics365TokenUrlBuilder.buildTokenUrl();
//# sourceMappingURL=data:application/json;base64,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