"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MarketoConnectorProfile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const connector_profile_1 = require("../core/connectors/connector-profile");
class MarketoConnectorProfile extends connector_profile_1.ConnectorProfileBase {
    static fromConnectionProfileArn(scope, id, arn) {
        return this._fromConnectorProfileAttributes(scope, id, { arn });
    }
    static fromConnectionProfileName(scope, id, name) {
        return this._fromConnectorProfileAttributes(scope, id, { name });
    }
    constructor(scope, id, props) {
        super(scope, id, props, type_1.MarketoConnectorType.instance);
    }
    buildConnectorProfileProperties(props) {
        const properties = props;
        return {
            marketo: {
                instanceUrl: properties.instanceUrl,
            },
        };
    }
    buildConnectorProfileCredentials(props) {
        const properties = props;
        return {
            marketo: {
                accessToken: properties.oAuth.accessToken?.unsafeUnwrap(),
                clientId: properties.oAuth.flow.clientCredentials.clientId.unsafeUnwrap(),
                clientSecret: properties.oAuth.flow.clientCredentials.clientSecret.unsafeUnwrap(),
            },
        };
    }
}
exports.MarketoConnectorProfile = MarketoConnectorProfile;
_a = JSII_RTTI_SYMBOL_1;
MarketoConnectorProfile[_a] = { fqn: "@cdklabs/cdk-appflow.MarketoConnectorProfile", version: "0.0.32" };
//# sourceMappingURL=data:application/json;base64,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