"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.JdbcSmallDataScaleDestination = void 0;
const type_1 = require("./type");
const appflow_permissions_manager_1 = require("../core/appflow-permissions-manager");
const write_operation_1 = require("../core/write-operation");
/**
 * Represents a destination for the JDBC connector
 */
class JdbcSmallDataScaleDestination {
    /**
     * Creates a new instance of the JdbcSmallDataScaleDestination
     * @param props - properties of the destination
     */
    constructor(props) {
        this.props = props;
        this.connectorType = type_1.JdbcSmallDataScaleConnectorType.instance;
    }
    bind(flow) {
        this.tryAddNodeDependency(flow, this.props.errorHandling?.errorLocation?.bucket);
        appflow_permissions_manager_1.AppFlowPermissionsManager.instance().grantBucketWrite(this.props.errorHandling?.errorLocation?.bucket);
        this.tryAddNodeDependency(flow, this.props.profile);
        return {
            connectorType: this.connectorType.asProfileConnectorType,
            apiVersion: this.props.apiVersion ?? JdbcSmallDataScaleDestination.defaultApiVersion,
            connectorProfileName: this.props.profile.name,
            destinationConnectorProperties: this.buildDestinationConnectorProperties(),
        };
    }
    buildDestinationConnectorProperties() {
        return {
            customConnector: {
                entityName: `${this.props.object.schema}.${this.props.object.table}`,
                errorHandlingConfig: this.props.errorHandling && {
                    bucketName: this.props.errorHandling?.errorLocation?.bucket.bucketName,
                    bucketPrefix: this.props.errorHandling?.errorLocation?.prefix,
                    failOnFirstError: this.props.errorHandling.failOnFirstError,
                },
                writeOperationType: write_operation_1.WriteOperationType.INSERT,
            },
        };
    }
    tryAddNodeDependency(scope, resource) {
        if (resource && typeof resource !== 'string') {
            scope.node.addDependency(resource);
        }
    }
}
exports.JdbcSmallDataScaleDestination = JdbcSmallDataScaleDestination;
JdbcSmallDataScaleDestination.defaultApiVersion = 'V1';
//# sourceMappingURL=data:application/json;base64,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