"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GoogleAnalytics4ConnectorProfile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const connector_authentication_type_1 = require("../core/connectors/connector-authentication-type");
const connector_profile_1 = require("../core/connectors/connector-profile");
const oauth2_granttype_1 = require("../core/connectors/oauth2-granttype");
class GoogleAnalytics4ConnectorProfile extends connector_profile_1.ConnectorProfileBase {
    static fromConnectionProfileArn(scope, id, arn) {
        return this._fromConnectorProfileAttributes(scope, id, { arn });
    }
    static fromConnectionProfileName(scope, id, name) {
        return this._fromConnectorProfileAttributes(scope, id, { name });
    }
    constructor(scope, id, props) {
        super(scope, id, props, type_1.GoogleAnalytics4ConnectorType.instance);
    }
    buildConnectorProfileProperties(props) {
        const properties = props;
        return {
            customConnector: {
                oAuth2Properties: {
                    // INFO: even if we're using a refresh token grant flow this property is required
                    oAuth2GrantType: oauth2_granttype_1.OAuth2GrantType.AUTHORIZATION_CODE,
                    // INFO: even if we provide only the access token this property is required
                    // TODO: think about if this is correct. token can be IResolvable
                    tokenUrl: properties.oAuth.endpoints?.token ?? GoogleAnalytics4ConnectorProfile.defaultTokenEndpoint,
                },
            },
        };
    }
    buildConnectorProfileCredentials(props) {
        const properties = props;
        return {
            customConnector: {
                oauth2: {
                    // INFO: when using Refresh Token Grant Flow - access token property is required
                    accessToken: properties.oAuth.accessToken?.unsafeUnwrap() ?? 'dummyAccessToken',
                    refreshToken: properties.oAuth.flow?.refreshTokenGrant.refreshToken?.unsafeUnwrap(),
                    clientId: properties.oAuth.flow?.refreshTokenGrant.clientId?.unsafeUnwrap(),
                    clientSecret: properties.oAuth.flow?.refreshTokenGrant.clientSecret?.unsafeUnwrap(),
                },
                authenticationType: connector_authentication_type_1.ConnectorAuthenticationType.OAUTH2,
            },
        };
    }
}
exports.GoogleAnalytics4ConnectorProfile = GoogleAnalytics4ConnectorProfile;
_a = JSII_RTTI_SYMBOL_1;
GoogleAnalytics4ConnectorProfile[_a] = { fqn: "@cdklabs/cdk-appflow.GoogleAnalytics4ConnectorProfile", version: "0.0.32" };
GoogleAnalytics4ConnectorProfile.defaultTokenEndpoint = 'https://oauth2.googleapis.com/token';
//# sourceMappingURL=data:application/json;base64,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