import { SecretValue } from 'aws-cdk-lib';
import { CfnConnectorProfile } from 'aws-cdk-lib/aws-appflow';
import { Construct } from 'constructs';
import { ConnectorProfileBase, ConnectorProfileProps } from '../core/connectors/connector-profile';
export interface GoogleAnalytics4ConnectorProfileProps extends ConnectorProfileProps {
    readonly oAuth: GoogleAnalytics4OAuthSettings;
}
/**
 * Google's OAuth token and authorization endpoints
 */
export interface GoogleAnalytics4OAuthEndpoints {
    /**
     * The OAuth token endpoint URI
     */
    readonly token?: string;
    /**
     * The OAuth authorization endpoint URI
     */
    readonly authorization?: string;
}
/**
 * The OAuth elements required for the execution of the refresh token grant flow.
 */
export interface GoogleAnalytics4RefreshTokenGrantFlow {
    /**
     * A non-expired refresh token.
     */
    readonly refreshToken?: SecretValue;
    /**
     * The secret of the client app.
     */
    readonly clientSecret?: SecretValue;
    /**
     * The id of the client app.
     */
    readonly clientId?: SecretValue;
}
/**
 * Represents the OAuth flow enabled for the GA4
 */
export interface GoogleAnalytics4OAuthFlow {
    /**
     * The details required for executing the refresh token grant flow
     */
    readonly refreshTokenGrant: GoogleAnalytics4RefreshTokenGrantFlow;
}
export interface GoogleAnalytics4OAuthSettings {
    /**
     * The access token to be used when interacting with Google Analytics 4
     *
     * Note that if only the access token is provided AppFlow is not able to retrieve a fresh access token when the current one is expired
     *
     * @default Retrieves a fresh accessToken with the information in the [flow property]{@link GoogleAnalytics4OAuthSettings#flow}
     */
    readonly accessToken?: SecretValue;
    /**
     * The OAuth flow used for obtaining a new accessToken when the old is not present or expired.
     *
     * @default undefined. AppFlow will not request any new accessToken after expiry.
     */
    readonly flow?: GoogleAnalytics4OAuthFlow;
    /**
     * The OAuth token and authorization endpoints.
     */
    readonly endpoints?: GoogleAnalytics4OAuthEndpoints;
}
export declare class GoogleAnalytics4ConnectorProfile extends ConnectorProfileBase {
    static fromConnectionProfileArn(scope: Construct, id: string, arn: string): GoogleAnalytics4ConnectorProfile;
    static fromConnectionProfileName(scope: Construct, id: string, name: string): GoogleAnalytics4ConnectorProfile;
    private static readonly defaultTokenEndpoint;
    constructor(scope: Construct, id: string, props: GoogleAnalytics4ConnectorProfileProps);
    protected buildConnectorProfileProperties(props: ConnectorProfileProps): CfnConnectorProfile.ConnectorProfilePropertiesProperty;
    protected buildConnectorProfileCredentials(props: ConnectorProfileProps): CfnConnectorProfile.ConnectorProfileCredentialsProperty;
}
