"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventBridgeConnectorType = void 0;
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const connector_type_1 = require("../core/connectors/connector-type");
/**
 * @internal
 */
class EventBridgeConnectorType extends connector_type_1.ConnectorType {
    static get instance() {
        if (!EventBridgeConnectorType.actualInstance) {
            EventBridgeConnectorType.actualInstance = new EventBridgeConnectorType();
        }
        return EventBridgeConnectorType.actualInstance;
    }
    constructor() {
        super('EventBridge', false);
    }
    get asProfileConnectorType() {
        return this.name;
    }
}
exports.EventBridgeConnectorType = EventBridgeConnectorType;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidHlwZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9ldmVudGJyaWRnZS90eXBlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBOzs7RUFHRTtBQUNGLHNFQUFrRTtBQUVsRTs7R0FFRztBQUNILE1BQWEsd0JBQXlCLFNBQVEsOEJBQWE7SUFFbEQsTUFBTSxLQUFLLFFBQVE7UUFDeEIsSUFBSSxDQUFDLHdCQUF3QixDQUFDLGNBQWMsRUFBRTtZQUM1Qyx3QkFBd0IsQ0FBQyxjQUFjLEdBQUcsSUFBSSx3QkFBd0IsRUFBRSxDQUFDO1NBQzFFO1FBQ0QsT0FBTyx3QkFBd0IsQ0FBQyxjQUFjLENBQUM7SUFDakQsQ0FBQztJQUlEO1FBQ0UsS0FBSyxDQUFDLGFBQWEsRUFBRSxLQUFLLENBQUMsQ0FBQztJQUM5QixDQUFDO0lBRUQsSUFBVyxzQkFBc0I7UUFDL0IsT0FBTyxJQUFJLENBQUMsSUFBSSxDQUFDO0lBQ25CLENBQUM7Q0FDRjtBQWxCRCw0REFrQkMiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG5TUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuKi9cbmltcG9ydCB7IENvbm5lY3RvclR5cGUgfSBmcm9tICcuLi9jb3JlL2Nvbm5lY3RvcnMvY29ubmVjdG9yLXR5cGUnO1xuXG4vKipcbiAqIEBpbnRlcm5hbFxuICovXG5leHBvcnQgY2xhc3MgRXZlbnRCcmlkZ2VDb25uZWN0b3JUeXBlIGV4dGVuZHMgQ29ubmVjdG9yVHlwZSB7XG5cbiAgcHVibGljIHN0YXRpYyBnZXQgaW5zdGFuY2UoKTogQ29ubmVjdG9yVHlwZSB7XG4gICAgaWYgKCFFdmVudEJyaWRnZUNvbm5lY3RvclR5cGUuYWN0dWFsSW5zdGFuY2UpIHtcbiAgICAgIEV2ZW50QnJpZGdlQ29ubmVjdG9yVHlwZS5hY3R1YWxJbnN0YW5jZSA9IG5ldyBFdmVudEJyaWRnZUNvbm5lY3RvclR5cGUoKTtcbiAgICB9XG4gICAgcmV0dXJuIEV2ZW50QnJpZGdlQ29ubmVjdG9yVHlwZS5hY3R1YWxJbnN0YW5jZTtcbiAgfVxuXG4gIHByaXZhdGUgc3RhdGljIGFjdHVhbEluc3RhbmNlOiBDb25uZWN0b3JUeXBlO1xuXG4gIGNvbnN0cnVjdG9yKCkge1xuICAgIHN1cGVyKCdFdmVudEJyaWRnZScsIGZhbHNlKTtcbiAgfVxuXG4gIHB1YmxpYyBnZXQgYXNQcm9maWxlQ29ubmVjdG9yVHlwZSgpOiBzdHJpbmcge1xuICAgIHJldHVybiB0aGlzLm5hbWU7XG4gIH1cbn0iXX0=