"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Filter = exports.FilterCondition = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const operation_1 = require("./operation");
const tasks_1 = require("./tasks");
/**
 * A representation of a filter operation condtiion on a source record field
 */
class FilterCondition {
    /**
     * A condition testing whether a string-type source field contains the given value(s).
     * NOTE: When multiple values are passed the evaluation is resolved as logical OR
     * @param field a source field of a string type
     * @param val a value (or values) to be contained by the field value
     * @returns an instance of a @see FilterCondition
     */
    static stringContains(field, val) {
        return FilterCondition.stringCondition(field, val, 'CONTAINS');
    }
    /**
     * A condition testing whether a string-type source field equals the given value(s).
     * NOTE: When multiple values are passed the evaluation is resolved as logical OR
     * @param field a source field of a string type
     * @param val a value (or values) to be contained by the field value
     * @returns an instance of a @see FilterCondition
     */
    static stringEquals(field, val) {
        return FilterCondition.stringCondition(field, val, 'EQUAL_TO');
    }
    /**
     * A condition testing whether a string-type source field does not equal the given value(s).
     * NOTE: When multiple values are passed the evaluation is resolved as logical OR
     * @param field a source field of a string type
     * @param val a value (or values) to be contained by the field value
     * @returns an instance of a @see FilterCondition
     */
    static stringNotEquals(field, val) {
        return FilterCondition.stringCondition(field, val, 'NOT_EQUAL_TO');
    }
    static booleanEquals(field, val) {
        return FilterCondition.booleanCondition(field, val, 'EQUAL_TO');
    }
    static booleanNotEquals(field, val) {
        return FilterCondition.booleanCondition(field, val, 'NOT_EQUAL_TO');
    }
    static numberEquals(field, val) {
        return FilterCondition.numberCondition(field, val, 'EQUAL_TO');
    }
    static numberNotEquals(field, val) {
        return FilterCondition.numberCondition(field, val, 'NOT_EQUAL_TO');
    }
    static numberLessThan(field, val) {
        return FilterCondition.numberCondition(field, val, 'LESS_THAN');
    }
    static numberLessThanEquals(field, val) {
        return FilterCondition.numberCondition(field, val, 'LESS_THAN_OR_EQUAL_TO');
    }
    static numberGreaterThan(field, val) {
        return FilterCondition.numberCondition(field, val, 'GREATER_THAN');
    }
    static numberGreaterThanEquals(field, val) {
        return FilterCondition.numberCondition(field, val, 'GREATER_THAN_OR_EQUAL_TO');
    }
    static timestampEquals(field, val) {
        return FilterCondition.timestampCondition(field, val, 'EQUAL_TO');
    }
    static timestampNotEquals(field, val) {
        return FilterCondition.timestampCondition(field, val, 'NOT_EQUAL_TO');
    }
    static timestampLessThan(field, val) {
        return FilterCondition.timestampCondition(field, val, 'LESS_THAN');
    }
    static timestampLessThanEquals(field, val) {
        return FilterCondition.timestampCondition(field, val, 'LESS_THAN_OR_EQUAL_TO');
    }
    static timestampGreaterThan(field, val) {
        return FilterCondition.timestampCondition(field, val, 'GREATER_THAN');
    }
    static timestampGreaterThanEquals(field, val) {
        return FilterCondition.timestampCondition(field, val, 'GREATER_THAN_OR_EQUAL_TO');
    }
    static timestampBetween(field, lower, upper) {
        return new FilterCondition(field, 'BETWEEN', [
            { key: 'DATA_TYPE', value: field.dataType },
            { key: 'LOWER_BOUND', value: this.valueToString(lower) },
            { key: 'UPPER_BOUND', value: this.valueToString(upper) },
        ]);
    }
    static stringCondition(field, val, filter) {
        if (Array.isArray(val)) {
            return new FilterCondition(field, filter, [
                { key: 'DATA_TYPE', value: field.dataType },
                { key: 'VALUES', value: val.map(m => this.valueToString(m)).join(',') },
            ]);
        }
        return new FilterCondition(field, filter, [
            { key: 'DATA_TYPE', value: field.dataType },
            { key: 'VALUE', value: this.valueToString(val) },
        ]);
    }
    static numberCondition(field, val, filter) {
        if (Array.isArray(val)) {
            return new FilterCondition(field, filter, [
                { key: 'DATA_TYPE', value: field.dataType },
                { key: 'VALUES', value: val.map(m => this.valueToString(m)).join(',') },
            ]);
        }
        return new FilterCondition(field, filter, [
            { key: 'DATA_TYPE', value: field.dataType },
            { key: 'VALUE', value: this.valueToString(val) },
        ]);
    }
    static booleanCondition(field, val, filter) {
        if (Array.isArray(val)) {
            return new FilterCondition(field, filter, [
                { key: 'DATA_TYPE', value: field.dataType },
                { key: 'VALUES', value: val.map(m => this.valueToString(m)).join(',') },
            ]);
        }
        return new FilterCondition(field, filter, [
            { key: 'DATA_TYPE', value: field.dataType },
            { key: 'VALUE', value: this.valueToString(val) },
        ]);
    }
    static timestampCondition(field, val, filter) {
        if (Array.isArray(val)) {
            return new FilterCondition(field, filter, [
                { key: 'DATA_TYPE', value: field.dataType },
                { key: 'VALUES', value: val.map(m => this.valueToString(m)).join(',') },
            ]);
        }
        return new FilterCondition(field, filter, [
            { key: 'DATA_TYPE', value: field.dataType },
            { key: 'VALUE', value: this.valueToString(val) },
        ]);
    }
    static valueToString(value) {
        const t = typeof value;
        switch (t) {
            case 'string':
                return value;
            case 'number':
            case 'boolean':
                return `${value}`;
            default: // meaning: Date
                return value.getTime().toString();
        }
    }
    constructor(field, filter, properties) {
        this.field = field;
        this.filter = filter;
        this.properties = properties;
        if (!field.dataType) {
            throw new Error('field dataType required');
        }
    }
}
exports.FilterCondition = FilterCondition;
_a = JSII_RTTI_SYMBOL_1;
FilterCondition[_a] = { fqn: "@cdklabs/cdk-appflow.FilterCondition", version: "0.0.32" };
/**
 * A representation of a mapping operation, that is an operation filtering records at the source
 */
class Filter extends operation_1.OperationBase {
    /**
     * Builds a filter operation on source
     * @param condition a @see FilterCondition instance
     * @returns
     */
    static when(condition) { return new Filter(condition); }
    constructor(condition) {
        super([new tasks_1.Task('Filter', [condition.field.name], 
            // TODO: think about source/destination here
            { operation: condition.filter }, condition.properties)]);
        this.condition = condition;
    }
}
exports.Filter = Filter;
_b = JSII_RTTI_SYMBOL_1;
Filter[_b] = { fqn: "@cdklabs/cdk-appflow.Filter", version: "0.0.32" };
//# sourceMappingURL=data:application/json;base64,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