"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TriggeredFlowBase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const flow_base_1 = require("./flow-base");
/**
 * A base class for triggered flows.
 */
class TriggeredFlowBase extends flow_base_1.FlowBase {
    /**
     *
     * @param autoActivate - a boolean value indicating whether to automatically activate the flow.
     * @param status - a {@link FlowStatus} value indicating the status to set on the flow.
     * @returns
     */
    static setStatus(autoActivate, status) {
        if (autoActivate !== undefined && status !== undefined) {
            throw new Error('Cannot specify both autoActivate and status');
        }
        return autoActivate !== undefined ?
            (autoActivate ? flow_base_1.FlowStatus.ACTIVE : flow_base_1.FlowStatus.SUSPENDED) :
            (status !== undefined ? status : undefined);
    }
    /**
     *
     * @param scope
     * @param id
     * @param props
     */
    constructor(scope, id, props) {
        super(scope, id, props);
    }
}
exports.TriggeredFlowBase = TriggeredFlowBase;
_a = JSII_RTTI_SYMBOL_1;
TriggeredFlowBase[_a] = { fqn: "@cdklabs/cdk-appflow.TriggeredFlowBase", version: "0.0.32" };
//# sourceMappingURL=data:application/json;base64,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