"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConnectorType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
class ConnectorType {
    constructor(name, isCustom) {
        this.name = name;
        this.isCustom = isCustom;
    }
    get asProfileConnectorType() {
        return this.isCustom
            ? 'CustomConnector'
            : `${this.name[0].toUpperCase()}${this.name.substring(1).toLowerCase()}`;
    }
    get asTaskConnectorOperatorOrigin() {
        return this.isCustom
            ? 'customConnector'
            : `${this.name[0].toLowerCase()}${this.name.substring(1)}`;
    }
    get asProfileConnectorLabel() {
        return this.isCustom
            ? this.name
            : undefined;
    }
}
exports.ConnectorType = ConnectorType;
_a = JSII_RTTI_SYMBOL_1;
ConnectorType[_a] = { fqn: "@cdklabs/cdk-appflow.ConnectorType", version: "0.0.32" };
//# sourceMappingURL=data:application/json;base64,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