"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AmazonRdsForPostgreSqlConnectorProfile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const core_1 = require("../core");
const connector_profile_1 = require("../core/connectors/connector-profile");
/**
 * The connector profile for the Amazon RDS for PostgreSQL connector
 */
class AmazonRdsForPostgreSqlConnectorProfile extends connector_profile_1.ConnectorProfileBase {
    /**
     * Imports an existing AmazonRdsForPostgreSqlConnectorProfile
     * @param scope the scope for the connector profile
     * @param id the connector profile's ID
     * @param arn the ARN for the existing connector profile
     * @returns An instance of the AmazonRdsForPostreSqlConnectorProfile
     */
    static fromConnectionProfileArn(scope, id, arn) {
        return this._fromConnectorProfileAttributes(scope, id, { arn });
    }
    /**
     * Imports an existing AmazonRdsForPostgreSqlConnectorProfile
     * @param scope the scope for the connector profile
     * @param id the connector profile's ID
     * @param name the name for the existing connector profile
     * @returns An instance of the AmazonRdsForPostreSqlConnectorProfile
     */
    static fromConnectionProfileName(scope, id, name) {
        return this._fromConnectorProfileAttributes(scope, id, { name });
    }
    /**
     * Creates a new instance of the AmazonRdsForPostgreSqlConnectorProfile
     * @param scope the Construct scope for this connector profile
     * @param id the id of this connector profile
     * @param props properties to use when instantiating this connector profile
     */
    constructor(scope, id, props) {
        super(scope, id, props, type_1.AmazonRdsForPostgreSqlConnectorType.instance);
    }
    buildConnectorProfileProperties(_props) {
        return {
            customConnector: {
                profileProperties: {},
            },
        };
    }
    buildConnectorProfileCredentials(props) {
        const properties = props;
        return {
            customConnector: {
                authenticationType: core_1.ConnectorAuthenticationType.CUSTOM,
                custom: {
                    credentialsMap: {
                        username: properties.basicAuth.username,
                        password: properties.basicAuth.password.unsafeUnwrap(),
                        driver: 'postgresql',
                        hostname: properties.hostname,
                        port: properties.port ? `${properties.port}` : AmazonRdsForPostgreSqlConnectorProfile.defaultPort.toString(),
                        database: properties.database,
                    },
                    customAuthenticationType: 'CUSTOM',
                },
            },
        };
    }
}
exports.AmazonRdsForPostgreSqlConnectorProfile = AmazonRdsForPostgreSqlConnectorProfile;
_a = JSII_RTTI_SYMBOL_1;
AmazonRdsForPostgreSqlConnectorProfile[_a] = { fqn: "@cdklabs/cdk-appflow.AmazonRdsForPostgreSqlConnectorProfile", version: "0.0.32" };
AmazonRdsForPostgreSqlConnectorProfile.defaultPort = 5432;
//# sourceMappingURL=data:application/json;base64,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