"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AmazonRdsForPostgreSqlDestination = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const appflow_permissions_manager_1 = require("../core/appflow-permissions-manager");
const write_operation_1 = require("../core/write-operation");
/**
 * Represents a destination for the Amazon RDS for PostgreSQL connector
 */
class AmazonRdsForPostgreSqlDestination {
    /**
     * Creates a new instance of the AmazonRdsForPostgreSqlDestination
     * @param props - properties of the destination
     */
    constructor(props) {
        this.props = props;
        this.connectorType = type_1.AmazonRdsForPostgreSqlConnectorType.instance;
    }
    bind(flow) {
        this.tryAddNodeDependency(flow, this.props.errorHandling?.errorLocation?.bucket);
        appflow_permissions_manager_1.AppFlowPermissionsManager.instance().grantBucketWrite(this.props.errorHandling?.errorLocation?.bucket);
        this.tryAddNodeDependency(flow, this.props.profile);
        return {
            connectorType: this.connectorType.asProfileConnectorType,
            apiVersion: this.props.apiVersion ?? AmazonRdsForPostgreSqlDestination.defaultApiVersion,
            connectorProfileName: this.props.profile.name,
            destinationConnectorProperties: this.buildDestinationConnectorProperties(),
        };
    }
    buildDestinationConnectorProperties() {
        return {
            customConnector: {
                entityName: `${this.props.object.schema}.${this.props.object.table}`,
                errorHandlingConfig: this.props.errorHandling && {
                    bucketName: this.props.errorHandling?.errorLocation?.bucket.bucketName,
                    bucketPrefix: this.props.errorHandling?.errorLocation?.prefix,
                    failOnFirstError: this.props.errorHandling.failOnFirstError,
                },
                writeOperationType: write_operation_1.WriteOperationType.INSERT,
            },
        };
    }
    tryAddNodeDependency(scope, resource) {
        if (resource && typeof resource !== 'string') {
            scope.node.addDependency(resource);
        }
    }
}
exports.AmazonRdsForPostgreSqlDestination = AmazonRdsForPostgreSqlDestination;
_a = JSII_RTTI_SYMBOL_1;
AmazonRdsForPostgreSqlDestination[_a] = { fqn: "@cdklabs/cdk-appflow.AmazonRdsForPostgreSqlDestination", version: "0.0.32" };
AmazonRdsForPostgreSqlDestination.defaultApiVersion = '1.0';
//# sourceMappingURL=data:application/json;base64,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