import { CfnFlow } from 'aws-cdk-lib/aws-appflow';
import { AmazonRdsForPostgreSqlConnectorProfile } from './profile';
import { ConnectorType } from '../core/connectors/connector-type';
import { ErrorHandlingConfiguration } from '../core/error-handling';
import { IFlow } from '../core/flows';
import { IDestination } from '../core/vertices/destination';
/**
 * The definition of the Amazon AppFlow object for Amazon RDS for PostgreSQL
 */
export interface AmazonRdsForPostgreSqlObject {
    /**
     * PostgreSQL schema name of the table
     */
    readonly schema: string;
    /**
     * PostgreSQL table name
     */
    readonly table: string;
}
/**
 * Properties of the AmazonRdsForPostgreSqlDestination
 */
export interface AmazonRdsForPostgreSqlDestinationProps {
    /**
     * The profile to use with the destination
     */
    readonly profile: AmazonRdsForPostgreSqlConnectorProfile;
    /**
     * The Amazon AppFlow Api Version
     */
    readonly apiVersion?: string;
    /**
     * The settings that determine how Amazon AppFlow handles an error when placing data in the destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure.
     */
    readonly errorHandling?: ErrorHandlingConfiguration;
    /**
     * The destination object table to write to
     */
    readonly object: AmazonRdsForPostgreSqlObject;
}
/**
 * Represents a destination for the Amazon RDS for PostgreSQL connector
 */
export declare class AmazonRdsForPostgreSqlDestination implements IDestination {
    private readonly props;
    private static readonly defaultApiVersion;
    readonly connectorType: ConnectorType;
    /**
     * Creates a new instance of the AmazonRdsForPostgreSqlDestination
     * @param props - properties of the destination
     */
    constructor(props: AmazonRdsForPostgreSqlDestinationProps);
    bind(flow: IFlow): CfnFlow.DestinationFlowConfigProperty;
    private buildDestinationConnectorProperties;
    private tryAddNodeDependency;
}
