# coding: utf-8

"""
    Empire - Platform API

    OpenAPI specification for the Platform REST API of Empire  **System Time:** Europe/Amsterdam  **General data formats:**   * _capacity values_ => kW (integers)   * _dates and local times_ => System Time   * _currencies_ => EUR   # noqa: E501

    The version of the OpenAPI document: 0.179.7
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, conlist
from empire_platform_api_public_client.models.auction_timescale import AuctionTimescale
from empire_platform_api_public_client.models.border_direction import BorderDirection
from empire_platform_api_public_client.models.date_period import DatePeriod
from empire_platform_api_public_client.models.mtu_size import MtuSize
from empire_platform_api_public_client.models.other_party import OtherParty
from empire_platform_api_public_client.models.secondary_market_day_ahead_or_intra_day_transfer_request_mtus_inner import SecondaryMarketDayAheadOrIntraDayTransferRequestMtusInner
from empire_platform_api_public_client.models.secondary_market_transfer_request_status import SecondaryMarketTransferRequestStatus

class SecondaryMarketDayAheadOrIntraDayTransferRequest(BaseModel):
    """
    SecondaryMarketDayAheadOrIntraDayTransferRequest
    """
    timescale: AuctionTimescale = Field(...)
    delivery_period: DatePeriod = Field(..., alias="deliveryPeriod")
    direction: BorderDirection = Field(...)
    requested_at: datetime = Field(..., alias="requestedAt", description="Date and time with zone information, marks an **absolute point** on the timeline  - theoretically can be sent and received with any zone offset (until it marks the desired **absolute point** on the timeline) - in practice it is advised to transfer it in UTC timezone (with Z offset, \"Zulu time\") - ISO 8601 compliant string in `yyyy-mm-ddThh:mm:ss.SSSZ` format ")
    completed_at: Optional[datetime] = Field(None, alias="completedAt", description="Date and time with zone information, marks an **absolute point** on the timeline  - theoretically can be sent and received with any zone offset (until it marks the desired **absolute point** on the timeline) - in practice it is advised to transfer it in UTC timezone (with Z offset, \"Zulu time\") - ISO 8601 compliant string in `yyyy-mm-ddThh:mm:ss.SSSZ` format ")
    expires_at: datetime = Field(..., alias="expiresAt", description="Date and time with zone information, marks an **absolute point** on the timeline  - theoretically can be sent and received with any zone offset (until it marks the desired **absolute point** on the timeline) - in practice it is advised to transfer it in UTC timezone (with Z offset, \"Zulu time\") - ISO 8601 compliant string in `yyyy-mm-ddThh:mm:ss.SSSZ` format ")
    sender: OtherParty = Field(...)
    receiver: OtherParty = Field(...)
    status: SecondaryMarketTransferRequestStatus = Field(...)
    resolution: MtuSize = Field(...)
    mtus: conlist(SecondaryMarketDayAheadOrIntraDayTransferRequestMtusInner) = Field(...)
    __properties = ["timescale", "deliveryPeriod", "direction", "requestedAt", "completedAt", "expiresAt", "sender", "receiver", "status", "resolution", "mtus"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SecondaryMarketDayAheadOrIntraDayTransferRequest:
        """Create an instance of SecondaryMarketDayAheadOrIntraDayTransferRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of delivery_period
        if self.delivery_period:
            _dict['deliveryPeriod'] = self.delivery_period.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sender
        if self.sender:
            _dict['sender'] = self.sender.to_dict()
        # override the default output from pydantic by calling `to_dict()` of receiver
        if self.receiver:
            _dict['receiver'] = self.receiver.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in mtus (list)
        _items = []
        if self.mtus:
            for _item in self.mtus:
                if _item:
                    _items.append(_item.to_dict())
            _dict['mtus'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SecondaryMarketDayAheadOrIntraDayTransferRequest:
        """Create an instance of SecondaryMarketDayAheadOrIntraDayTransferRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SecondaryMarketDayAheadOrIntraDayTransferRequest.parse_obj(obj)

        _obj = SecondaryMarketDayAheadOrIntraDayTransferRequest.parse_obj({
            "timescale": obj.get("timescale"),
            "delivery_period": DatePeriod.from_dict(obj.get("deliveryPeriod")) if obj.get("deliveryPeriod") is not None else None,
            "direction": obj.get("direction"),
            "requested_at": obj.get("requestedAt"),
            "completed_at": obj.get("completedAt"),
            "expires_at": obj.get("expiresAt"),
            "sender": OtherParty.from_dict(obj.get("sender")) if obj.get("sender") is not None else None,
            "receiver": OtherParty.from_dict(obj.get("receiver")) if obj.get("receiver") is not None else None,
            "status": obj.get("status"),
            "resolution": obj.get("resolution"),
            "mtus": [SecondaryMarketDayAheadOrIntraDayTransferRequestMtusInner.from_dict(_item) for _item in obj.get("mtus")] if obj.get("mtus") is not None else None
        })
        return _obj

