# coding: utf-8

"""
    Empire - Platform API

    OpenAPI specification for the Platform REST API of Empire  **System Time:** Europe/Amsterdam  **General data formats:**   * _capacity values_ => kW (integers)   * _dates and local times_ => System Time   * _currencies_ => EUR   # noqa: E501

    The version of the OpenAPI document: 0.179.7
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List
from pydantic import BaseModel, Field, conlist
from empire_platform_api_public_client.models.message import Message

class ParticipantDashboardMessages(BaseModel):
    """
    ParticipantDashboardMessages
    """
    general: conlist(Message, max_items=3) = Field(...)
    participant: conlist(Message, max_items=3) = Field(...)
    __properties = ["general", "participant"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ParticipantDashboardMessages:
        """Create an instance of ParticipantDashboardMessages from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in general (list)
        _items = []
        if self.general:
            for _item in self.general:
                if _item:
                    _items.append(_item.to_dict())
            _dict['general'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in participant (list)
        _items = []
        if self.participant:
            for _item in self.participant:
                if _item:
                    _items.append(_item.to_dict())
            _dict['participant'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ParticipantDashboardMessages:
        """Create an instance of ParticipantDashboardMessages from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ParticipantDashboardMessages.parse_obj(obj)

        _obj = ParticipantDashboardMessages.parse_obj({
            "general": [Message.from_dict(_item) for _item in obj.get("general")] if obj.get("general") is not None else None,
            "participant": [Message.from_dict(_item) for _item in obj.get("participant")] if obj.get("participant") is not None else None
        })
        return _obj

