# coding: utf-8

"""
    Empire - Platform API

    OpenAPI specification for the Platform REST API of Empire  **System Time:** Europe/Amsterdam  **General data formats:**   * _capacity values_ => kW (integers)   * _dates and local times_ => System Time   * _currencies_ => EUR   # noqa: E501

    The version of the OpenAPI document: 0.179.7
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictInt
from empire_platform_api_public_client.models.auction_result_participant import AuctionResultParticipant

class LongTermAuctionResultsAllocatedCapacityInner(BaseModel):
    """
    * `requestedCapacity` - Sum of ALL bids from the given Participant in kilowatts * `allocatedTrs` - Transmission rights allocated for the given Participant in the Auction 
    """
    participant: AuctionResultParticipant = Field(...)
    requested_capacity: Optional[StrictInt] = Field(None, alias="requestedCapacity", description="Capacity value in kilowatts (kW) - the required system precision allows for handling capacity values as integers")
    allocated_trs: StrictInt = Field(..., alias="allocatedTrs", description="Capacity value in kilowatts (kW) - the required system precision allows for handling capacity values as integers")
    __properties = ["participant", "requestedCapacity", "allocatedTrs"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> LongTermAuctionResultsAllocatedCapacityInner:
        """Create an instance of LongTermAuctionResultsAllocatedCapacityInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of participant
        if self.participant:
            _dict['participant'] = self.participant.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> LongTermAuctionResultsAllocatedCapacityInner:
        """Create an instance of LongTermAuctionResultsAllocatedCapacityInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return LongTermAuctionResultsAllocatedCapacityInner.parse_obj(obj)

        _obj = LongTermAuctionResultsAllocatedCapacityInner.parse_obj({
            "participant": AuctionResultParticipant.from_dict(obj.get("participant")) if obj.get("participant") is not None else None,
            "requested_capacity": obj.get("requestedCapacity"),
            "allocated_trs": obj.get("allocatedTrs")
        })
        return _obj

