# coding: utf-8

"""
    Empire - Platform API

    OpenAPI specification for the Platform REST API of Empire  **System Time:** Europe/Amsterdam  **General data formats:**   * _capacity values_ => kW (integers)   * _dates and local times_ => System Time   * _currencies_ => EUR   # noqa: E501

    The version of the OpenAPI document: 0.179.7
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from datetime import date

from pydantic import Field, StrictStr, conint, conlist

from typing import List, Optional

from empire_platform_api_public_client.models.auction_product_type import AuctionProductType
from empire_platform_api_public_client.models.auction_timescale import AuctionTimescale
from empire_platform_api_public_client.models.border_direction import BorderDirection
from empire_platform_api_public_client.models.invoice_batch import InvoiceBatch
from empire_platform_api_public_client.models.invoice_details import InvoiceDetails
from empire_platform_api_public_client.models.invoice_status import InvoiceStatus
from empire_platform_api_public_client.models.settlement import Settlement
from empire_platform_api_public_client.models.settlement_per_source import SettlementPerSource
from empire_platform_api_public_client.models.settlement_source_type import SettlementSourceType
from empire_platform_api_public_client.models.uiosi_overview import UiosiOverview

from empire_platform_api_public_client.api_client import ApiClient
from empire_platform_api_public_client.api_response import ApiResponse
from empire_platform_api_public_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class FinanceApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def get_finance_invoice(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], **kwargs) -> InvoiceDetails:  # noqa: E501
        """get_finance_invoice  # noqa: E501

        Fetch an Invoice by its identifier  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_INVOICES`   * `VIEW_ANY_INVOICES`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_finance_invoice(id, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: InvoiceDetails
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_finance_invoice_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_finance_invoice_with_http_info(id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_finance_invoice_with_http_info(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], **kwargs) -> ApiResponse:  # noqa: E501
        """get_finance_invoice  # noqa: E501

        Fetch an Invoice by its identifier  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_INVOICES`   * `VIEW_ANY_INVOICES`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_finance_invoice_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(InvoiceDetails, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_finance_invoice" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "InvoiceDetails",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/finance/invoices/{id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_finance_invoices(self, limit : Annotated[conint(strict=True, le=100, ge=1), Field(..., description="Number of records to return on a page")], offset : Annotated[conint(strict=True, ge=0), Field(..., description="Offset in the list of records to return")], period_from : date, period_to : date, statuses : conlist(InvoiceStatus), x_participant_id : Annotated[Optional[StrictStr], Field(description="Internal ID of a Participant-type Organisation (optional)")] = None, **kwargs) -> InvoiceBatch:  # noqa: E501
        """get_finance_invoices  # noqa: E501

        Fetch a paginated, filterable list of Invoices  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_INVOICES`   * `VIEW_ANY_INVOICES`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_finance_invoices(limit, offset, period_from, period_to, statuses, x_participant_id, async_req=True)
        >>> result = thread.get()

        :param limit: Number of records to return on a page (required)
        :type limit: int
        :param offset: Offset in the list of records to return (required)
        :type offset: int
        :param period_from: (required)
        :type period_from: date
        :param period_to: (required)
        :type period_to: date
        :param statuses: (required)
        :type statuses: List[InvoiceStatus]
        :param x_participant_id: Internal ID of a Participant-type Organisation (optional)
        :type x_participant_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: InvoiceBatch
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_finance_invoices_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_finance_invoices_with_http_info(limit, offset, period_from, period_to, statuses, x_participant_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_finance_invoices_with_http_info(self, limit : Annotated[conint(strict=True, le=100, ge=1), Field(..., description="Number of records to return on a page")], offset : Annotated[conint(strict=True, ge=0), Field(..., description="Offset in the list of records to return")], period_from : date, period_to : date, statuses : conlist(InvoiceStatus), x_participant_id : Annotated[Optional[StrictStr], Field(description="Internal ID of a Participant-type Organisation (optional)")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """get_finance_invoices  # noqa: E501

        Fetch a paginated, filterable list of Invoices  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_INVOICES`   * `VIEW_ANY_INVOICES`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_finance_invoices_with_http_info(limit, offset, period_from, period_to, statuses, x_participant_id, async_req=True)
        >>> result = thread.get()

        :param limit: Number of records to return on a page (required)
        :type limit: int
        :param offset: Offset in the list of records to return (required)
        :type offset: int
        :param period_from: (required)
        :type period_from: date
        :param period_to: (required)
        :type period_to: date
        :param statuses: (required)
        :type statuses: List[InvoiceStatus]
        :param x_participant_id: Internal ID of a Participant-type Organisation (optional)
        :type x_participant_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(InvoiceBatch, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'limit',
            'offset',
            'period_from',
            'period_to',
            'statuses',
            'x_participant_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_finance_invoices" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('offset') is not None:  # noqa: E501
            _query_params.append(('offset', _params['offset']))

        if _params.get('period_from') is not None:  # noqa: E501
            if isinstance(_params['period_from'], datetime):
                _query_params.append(('periodFrom', _params['period_from'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('periodFrom', _params['period_from']))

        if _params.get('period_to') is not None:  # noqa: E501
            if isinstance(_params['period_to'], datetime):
                _query_params.append(('periodTo', _params['period_to'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('periodTo', _params['period_to']))

        if _params.get('statuses') is not None:  # noqa: E501
            _query_params.append(('statuses', _params['statuses']))
            _collection_formats['statuses'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_participant_id']:
            _header_params['X-Participant-Id'] = _params['x_participant_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "InvoiceBatch",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/finance/invoices', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_finance_settlement_per_day(self, period_from : date, period_to : date, product_types : Annotated[conlist(AuctionProductType), Field(..., description="List of Auction Product Types")], sources : conlist(SettlementSourceType), x_participant_id : Annotated[Optional[StrictStr], Field(description="Internal ID of a Participant-type Organisation (optional)")] = None, border_direction : Annotated[Optional[BorderDirection], Field(description="Border Direction (optional)")] = None, timescale : Annotated[Optional[AuctionTimescale], Field(description="Auction Timescale (optional)")] = None, **kwargs) -> List[Settlement]:  # noqa: E501
        """get_finance_settlement_per_day  # noqa: E501

        Fetch a filterable list of Settlements per days  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_SETTLEMENT`   * `VIEW_ANY_SETTLEMENT`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_finance_settlement_per_day(period_from, period_to, product_types, sources, x_participant_id, border_direction, timescale, async_req=True)
        >>> result = thread.get()

        :param period_from: (required)
        :type period_from: date
        :param period_to: (required)
        :type period_to: date
        :param product_types: List of Auction Product Types (required)
        :type product_types: List[AuctionProductType]
        :param sources: (required)
        :type sources: List[SettlementSourceType]
        :param x_participant_id: Internal ID of a Participant-type Organisation (optional)
        :type x_participant_id: str
        :param border_direction: Border Direction (optional)
        :type border_direction: BorderDirection
        :param timescale: Auction Timescale (optional)
        :type timescale: AuctionTimescale
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[Settlement]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_finance_settlement_per_day_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_finance_settlement_per_day_with_http_info(period_from, period_to, product_types, sources, x_participant_id, border_direction, timescale, **kwargs)  # noqa: E501

    @validate_arguments
    def get_finance_settlement_per_day_with_http_info(self, period_from : date, period_to : date, product_types : Annotated[conlist(AuctionProductType), Field(..., description="List of Auction Product Types")], sources : conlist(SettlementSourceType), x_participant_id : Annotated[Optional[StrictStr], Field(description="Internal ID of a Participant-type Organisation (optional)")] = None, border_direction : Annotated[Optional[BorderDirection], Field(description="Border Direction (optional)")] = None, timescale : Annotated[Optional[AuctionTimescale], Field(description="Auction Timescale (optional)")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """get_finance_settlement_per_day  # noqa: E501

        Fetch a filterable list of Settlements per days  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_SETTLEMENT`   * `VIEW_ANY_SETTLEMENT`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_finance_settlement_per_day_with_http_info(period_from, period_to, product_types, sources, x_participant_id, border_direction, timescale, async_req=True)
        >>> result = thread.get()

        :param period_from: (required)
        :type period_from: date
        :param period_to: (required)
        :type period_to: date
        :param product_types: List of Auction Product Types (required)
        :type product_types: List[AuctionProductType]
        :param sources: (required)
        :type sources: List[SettlementSourceType]
        :param x_participant_id: Internal ID of a Participant-type Organisation (optional)
        :type x_participant_id: str
        :param border_direction: Border Direction (optional)
        :type border_direction: BorderDirection
        :param timescale: Auction Timescale (optional)
        :type timescale: AuctionTimescale
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[Settlement], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'period_from',
            'period_to',
            'product_types',
            'sources',
            'x_participant_id',
            'border_direction',
            'timescale'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_finance_settlement_per_day" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('period_from') is not None:  # noqa: E501
            if isinstance(_params['period_from'], datetime):
                _query_params.append(('periodFrom', _params['period_from'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('periodFrom', _params['period_from']))

        if _params.get('period_to') is not None:  # noqa: E501
            if isinstance(_params['period_to'], datetime):
                _query_params.append(('periodTo', _params['period_to'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('periodTo', _params['period_to']))

        if _params.get('product_types') is not None:  # noqa: E501
            _query_params.append(('productTypes', _params['product_types']))
            _collection_formats['productTypes'] = 'multi'

        if _params.get('sources') is not None:  # noqa: E501
            _query_params.append(('sources', _params['sources']))
            _collection_formats['sources'] = 'multi'

        if _params.get('border_direction') is not None:  # noqa: E501
            _query_params.append(('borderDirection', _params['border_direction'].value))

        if _params.get('timescale') is not None:  # noqa: E501
            _query_params.append(('timescale', _params['timescale'].value))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_participant_id']:
            _header_params['X-Participant-Id'] = _params['x_participant_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "List[Settlement]",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/finance/settlement/day', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_finance_settlement_per_source(self, period_from : date, period_to : date, product_types : Annotated[conlist(AuctionProductType), Field(..., description="List of Auction Product Types")], sources : conlist(SettlementSourceType), x_participant_id : Annotated[Optional[StrictStr], Field(description="Internal ID of a Participant-type Organisation (optional)")] = None, border_direction : Annotated[Optional[BorderDirection], Field(description="Border Direction (optional)")] = None, timescale : Annotated[Optional[AuctionTimescale], Field(description="Auction Timescale (optional)")] = None, **kwargs) -> List[SettlementPerSource]:  # noqa: E501
        """get_finance_settlement_per_source  # noqa: E501

        Fetch a filterable list of Settlements per Source  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_SETTLEMENT`   * `VIEW_ANY_SETTLEMENT`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_finance_settlement_per_source(period_from, period_to, product_types, sources, x_participant_id, border_direction, timescale, async_req=True)
        >>> result = thread.get()

        :param period_from: (required)
        :type period_from: date
        :param period_to: (required)
        :type period_to: date
        :param product_types: List of Auction Product Types (required)
        :type product_types: List[AuctionProductType]
        :param sources: (required)
        :type sources: List[SettlementSourceType]
        :param x_participant_id: Internal ID of a Participant-type Organisation (optional)
        :type x_participant_id: str
        :param border_direction: Border Direction (optional)
        :type border_direction: BorderDirection
        :param timescale: Auction Timescale (optional)
        :type timescale: AuctionTimescale
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[SettlementPerSource]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_finance_settlement_per_source_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_finance_settlement_per_source_with_http_info(period_from, period_to, product_types, sources, x_participant_id, border_direction, timescale, **kwargs)  # noqa: E501

    @validate_arguments
    def get_finance_settlement_per_source_with_http_info(self, period_from : date, period_to : date, product_types : Annotated[conlist(AuctionProductType), Field(..., description="List of Auction Product Types")], sources : conlist(SettlementSourceType), x_participant_id : Annotated[Optional[StrictStr], Field(description="Internal ID of a Participant-type Organisation (optional)")] = None, border_direction : Annotated[Optional[BorderDirection], Field(description="Border Direction (optional)")] = None, timescale : Annotated[Optional[AuctionTimescale], Field(description="Auction Timescale (optional)")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """get_finance_settlement_per_source  # noqa: E501

        Fetch a filterable list of Settlements per Source  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_SETTLEMENT`   * `VIEW_ANY_SETTLEMENT`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_finance_settlement_per_source_with_http_info(period_from, period_to, product_types, sources, x_participant_id, border_direction, timescale, async_req=True)
        >>> result = thread.get()

        :param period_from: (required)
        :type period_from: date
        :param period_to: (required)
        :type period_to: date
        :param product_types: List of Auction Product Types (required)
        :type product_types: List[AuctionProductType]
        :param sources: (required)
        :type sources: List[SettlementSourceType]
        :param x_participant_id: Internal ID of a Participant-type Organisation (optional)
        :type x_participant_id: str
        :param border_direction: Border Direction (optional)
        :type border_direction: BorderDirection
        :param timescale: Auction Timescale (optional)
        :type timescale: AuctionTimescale
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[SettlementPerSource], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'period_from',
            'period_to',
            'product_types',
            'sources',
            'x_participant_id',
            'border_direction',
            'timescale'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_finance_settlement_per_source" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('period_from') is not None:  # noqa: E501
            if isinstance(_params['period_from'], datetime):
                _query_params.append(('periodFrom', _params['period_from'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('periodFrom', _params['period_from']))

        if _params.get('period_to') is not None:  # noqa: E501
            if isinstance(_params['period_to'], datetime):
                _query_params.append(('periodTo', _params['period_to'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('periodTo', _params['period_to']))

        if _params.get('product_types') is not None:  # noqa: E501
            _query_params.append(('productTypes', _params['product_types']))
            _collection_formats['productTypes'] = 'multi'

        if _params.get('sources') is not None:  # noqa: E501
            _query_params.append(('sources', _params['sources']))
            _collection_formats['sources'] = 'multi'

        if _params.get('border_direction') is not None:  # noqa: E501
            _query_params.append(('borderDirection', _params['border_direction'].value))

        if _params.get('timescale') is not None:  # noqa: E501
            _query_params.append(('timescale', _params['timescale'].value))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_participant_id']:
            _header_params['X-Participant-Id'] = _params['x_participant_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "List[SettlementPerSource]",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/finance/settlement/source', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_finance_uiosi_overview(self, delivery_day : date, border_direction : Annotated[BorderDirection, Field(..., description="Border Direction")], timescale : Annotated[AuctionTimescale, Field(..., description="Auction Timescale")], x_participant_id : Annotated[Optional[StrictStr], Field(description="Internal ID of a Participant-type Organisation (optional)")] = None, **kwargs) -> UiosiOverview:  # noqa: E501
        """get_finance_uiosi_overview  # noqa: E501

        Fetch \"Use it or Sell it\" data by given filters  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_UIOSI`   * `VIEW_ANY_UIOSI`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_finance_uiosi_overview(delivery_day, border_direction, timescale, x_participant_id, async_req=True)
        >>> result = thread.get()

        :param delivery_day: (required)
        :type delivery_day: date
        :param border_direction: Border Direction (required)
        :type border_direction: BorderDirection
        :param timescale: Auction Timescale (required)
        :type timescale: AuctionTimescale
        :param x_participant_id: Internal ID of a Participant-type Organisation (optional)
        :type x_participant_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UiosiOverview
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_finance_uiosi_overview_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_finance_uiosi_overview_with_http_info(delivery_day, border_direction, timescale, x_participant_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_finance_uiosi_overview_with_http_info(self, delivery_day : date, border_direction : Annotated[BorderDirection, Field(..., description="Border Direction")], timescale : Annotated[AuctionTimescale, Field(..., description="Auction Timescale")], x_participant_id : Annotated[Optional[StrictStr], Field(description="Internal ID of a Participant-type Organisation (optional)")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """get_finance_uiosi_overview  # noqa: E501

        Fetch \"Use it or Sell it\" data by given filters  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_UIOSI`   * `VIEW_ANY_UIOSI`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_finance_uiosi_overview_with_http_info(delivery_day, border_direction, timescale, x_participant_id, async_req=True)
        >>> result = thread.get()

        :param delivery_day: (required)
        :type delivery_day: date
        :param border_direction: Border Direction (required)
        :type border_direction: BorderDirection
        :param timescale: Auction Timescale (required)
        :type timescale: AuctionTimescale
        :param x_participant_id: Internal ID of a Participant-type Organisation (optional)
        :type x_participant_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(UiosiOverview, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'delivery_day',
            'border_direction',
            'timescale',
            'x_participant_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_finance_uiosi_overview" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('delivery_day') is not None:  # noqa: E501
            if isinstance(_params['delivery_day'], datetime):
                _query_params.append(('deliveryDay', _params['delivery_day'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('deliveryDay', _params['delivery_day']))

        if _params.get('border_direction') is not None:  # noqa: E501
            _query_params.append(('borderDirection', _params['border_direction'].value))

        if _params.get('timescale') is not None:  # noqa: E501
            _query_params.append(('timescale', _params['timescale'].value))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_participant_id']:
            _header_params['X-Participant-Id'] = _params['x_participant_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "UiosiOverview",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/finance/uiosi-overview', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
