# coding: utf-8

"""
    Empire - Platform API

    OpenAPI specification for the Platform REST API of Empire  **System Time:** Europe/Amsterdam  **General data formats:**   * _capacity values_ => kW (integers)   * _dates and local times_ => System Time   * _currencies_ => EUR   # noqa: E501

    The version of the OpenAPI document: 0.179.7
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from datetime import datetime

from pydantic import Field, StrictStr, conint, conlist

from typing import Optional

from empire_platform_api_public_client.models.audit_log_batch import AuditLogBatch
from empire_platform_api_public_client.models.audit_log_domain import AuditLogDomain
from empire_platform_api_public_client.models.audit_log_payload import AuditLogPayload
from empire_platform_api_public_client.models.audit_log_sort_by import AuditLogSortBy

from empire_platform_api_public_client.api_client import ApiClient
from empire_platform_api_public_client.api_response import ApiResponse
from empire_platform_api_public_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class AuditLogApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def get_audit_log_payload(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], **kwargs) -> AuditLogPayload:  # noqa: E501
        """get_audit_log_payload  # noqa: E501

        Fetch payload for an existing Audit Log entry by its identifier  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_AUDIT_LOGS`   * `VIEW_ANY_AUDIT_LOGS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_audit_log_payload(id, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AuditLogPayload
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_audit_log_payload_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_audit_log_payload_with_http_info(id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_audit_log_payload_with_http_info(self, id : Annotated[StrictStr, Field(..., description="Internal unique ID of an entity")], **kwargs) -> ApiResponse:  # noqa: E501
        """get_audit_log_payload  # noqa: E501

        Fetch payload for an existing Audit Log entry by its identifier  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_AUDIT_LOGS`   * `VIEW_ANY_AUDIT_LOGS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_audit_log_payload_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: Internal unique ID of an entity (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AuditLogPayload, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_audit_log_payload" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "AuditLogPayload",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/audit-logs/{id}/payload', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_audit_logs(self, limit : Annotated[conint(strict=True, le=100, ge=1), Field(..., description="Number of records to return on a page")], offset : Annotated[conint(strict=True, ge=0), Field(..., description="Offset in the list of records to return")], sort_by : AuditLogSortBy, domains : Optional[conlist(AuditLogDomain)] = None, x_organisation_id : Annotated[Optional[StrictStr], Field(description="Internal ID of an Organisation (optional)")] = None, created_at_from : Optional[datetime] = None, created_at_to : Optional[datetime] = None, query : Optional[StrictStr] = None, **kwargs) -> AuditLogBatch:  # noqa: E501
        """get_audit_logs  # noqa: E501

        Fetch a list of Audit Logs optionally filtered for an Organisation  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_AUDIT_LOGS`   * `VIEW_ANY_AUDIT_LOGS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_audit_logs(limit, offset, sort_by, domains, x_organisation_id, created_at_from, created_at_to, query, async_req=True)
        >>> result = thread.get()

        :param limit: Number of records to return on a page (required)
        :type limit: int
        :param offset: Offset in the list of records to return (required)
        :type offset: int
        :param sort_by: (required)
        :type sort_by: AuditLogSortBy
        :param domains:
        :type domains: List[AuditLogDomain]
        :param x_organisation_id: Internal ID of an Organisation (optional)
        :type x_organisation_id: str
        :param created_at_from:
        :type created_at_from: datetime
        :param created_at_to:
        :type created_at_to: datetime
        :param query:
        :type query: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AuditLogBatch
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_audit_logs_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_audit_logs_with_http_info(limit, offset, sort_by, domains, x_organisation_id, created_at_from, created_at_to, query, **kwargs)  # noqa: E501

    @validate_arguments
    def get_audit_logs_with_http_info(self, limit : Annotated[conint(strict=True, le=100, ge=1), Field(..., description="Number of records to return on a page")], offset : Annotated[conint(strict=True, ge=0), Field(..., description="Offset in the list of records to return")], sort_by : AuditLogSortBy, domains : Optional[conlist(AuditLogDomain)] = None, x_organisation_id : Annotated[Optional[StrictStr], Field(description="Internal ID of an Organisation (optional)")] = None, created_at_from : Optional[datetime] = None, created_at_to : Optional[datetime] = None, query : Optional[StrictStr] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """get_audit_logs  # noqa: E501

        Fetch a list of Audit Logs optionally filtered for an Organisation  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_AUDIT_LOGS`   * `VIEW_ANY_AUDIT_LOGS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_audit_logs_with_http_info(limit, offset, sort_by, domains, x_organisation_id, created_at_from, created_at_to, query, async_req=True)
        >>> result = thread.get()

        :param limit: Number of records to return on a page (required)
        :type limit: int
        :param offset: Offset in the list of records to return (required)
        :type offset: int
        :param sort_by: (required)
        :type sort_by: AuditLogSortBy
        :param domains:
        :type domains: List[AuditLogDomain]
        :param x_organisation_id: Internal ID of an Organisation (optional)
        :type x_organisation_id: str
        :param created_at_from:
        :type created_at_from: datetime
        :param created_at_to:
        :type created_at_to: datetime
        :param query:
        :type query: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AuditLogBatch, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'limit',
            'offset',
            'sort_by',
            'domains',
            'x_organisation_id',
            'created_at_from',
            'created_at_to',
            'query'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_audit_logs" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('offset') is not None:  # noqa: E501
            _query_params.append(('offset', _params['offset']))

        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sortBy', _params['sort_by'].value))

        if _params.get('domains') is not None:  # noqa: E501
            _query_params.append(('domains', _params['domains']))
            _collection_formats['domains'] = 'multi'

        if _params.get('created_at_from') is not None:  # noqa: E501
            if isinstance(_params['created_at_from'], datetime):
                _query_params.append(('createdAtFrom', _params['created_at_from'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('createdAtFrom', _params['created_at_from']))

        if _params.get('created_at_to') is not None:  # noqa: E501
            if isinstance(_params['created_at_to'], datetime):
                _query_params.append(('createdAtTo', _params['created_at_to'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('createdAtTo', _params['created_at_to']))

        if _params.get('query') is not None:  # noqa: E501
            _query_params.append(('query', _params['query']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_organisation_id']:
            _header_params['X-Organisation-Id'] = _params['x_organisation_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "AuditLogBatch",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/audit-logs', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
