import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::ImageBuilder::Component`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-component.html
 */
export interface CfnComponentProps {
    /**
     * `AWS::ImageBuilder::Component.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-component.html#cfn-imagebuilder-component-name
     */
    readonly name: string;
    /**
     * `AWS::ImageBuilder::Component.Platform`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-component.html#cfn-imagebuilder-component-platform
     */
    readonly platform: string;
    /**
     * `AWS::ImageBuilder::Component.Version`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-component.html#cfn-imagebuilder-component-version
     */
    readonly version: string;
    /**
     * `AWS::ImageBuilder::Component.ChangeDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-component.html#cfn-imagebuilder-component-changedescription
     */
    readonly changeDescription?: string;
    /**
     * `AWS::ImageBuilder::Component.Data`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-component.html#cfn-imagebuilder-component-data
     */
    readonly data?: string;
    /**
     * `AWS::ImageBuilder::Component.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-component.html#cfn-imagebuilder-component-description
     */
    readonly description?: string;
    /**
     * `AWS::ImageBuilder::Component.KmsKeyId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-component.html#cfn-imagebuilder-component-kmskeyid
     */
    readonly kmsKeyId?: string;
    /**
     * `AWS::ImageBuilder::Component.SupportedOsVersions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-component.html#cfn-imagebuilder-component-supportedosversions
     */
    readonly supportedOsVersions?: string[];
    /**
     * `AWS::ImageBuilder::Component.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-component.html#cfn-imagebuilder-component-tags
     */
    readonly tags?: {
        [key: string]: (string);
    };
    /**
     * `AWS::ImageBuilder::Component.Uri`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-component.html#cfn-imagebuilder-component-uri
     */
    readonly uri?: string;
}
/**
 * A CloudFormation `AWS::ImageBuilder::Component`.
 *
 * @external
 * @cloudformationResource AWS::ImageBuilder::Component
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-component.html
 */
export declare class CfnComponent extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ImageBuilder::Component";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnComponent;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Encrypted
     */
    readonly attrEncrypted: cdk.IResolvable;
    /**
     * @external
     * @cloudformationAttribute Name
     */
    readonly attrName: string;
    /**
     * @external
     * @cloudformationAttribute Type
     */
    readonly attrType: string;
    /**
     * `AWS::ImageBuilder::Component.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-component.html#cfn-imagebuilder-component-name
     */
    name: string;
    /**
     * `AWS::ImageBuilder::Component.Platform`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-component.html#cfn-imagebuilder-component-platform
     */
    platform: string;
    /**
     * `AWS::ImageBuilder::Component.Version`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-component.html#cfn-imagebuilder-component-version
     */
    version: string;
    /**
     * `AWS::ImageBuilder::Component.ChangeDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-component.html#cfn-imagebuilder-component-changedescription
     */
    changeDescription: string | undefined;
    /**
     * `AWS::ImageBuilder::Component.Data`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-component.html#cfn-imagebuilder-component-data
     */
    data: string | undefined;
    /**
     * `AWS::ImageBuilder::Component.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-component.html#cfn-imagebuilder-component-description
     */
    description: string | undefined;
    /**
     * `AWS::ImageBuilder::Component.KmsKeyId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-component.html#cfn-imagebuilder-component-kmskeyid
     */
    kmsKeyId: string | undefined;
    /**
     * `AWS::ImageBuilder::Component.SupportedOsVersions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-component.html#cfn-imagebuilder-component-supportedosversions
     */
    supportedOsVersions: string[] | undefined;
    /**
     * `AWS::ImageBuilder::Component.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-component.html#cfn-imagebuilder-component-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::ImageBuilder::Component.Uri`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-component.html#cfn-imagebuilder-component-uri
     */
    uri: string | undefined;
    /**
     * Create a new `AWS::ImageBuilder::Component`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnComponentProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::ImageBuilder::ContainerRecipe`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html
 */
export interface CfnContainerRecipeProps {
    /**
     * `AWS::ImageBuilder::ContainerRecipe.Components`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-components
     */
    readonly components: Array<CfnContainerRecipe.ComponentConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ImageBuilder::ContainerRecipe.ContainerType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-containertype
     */
    readonly containerType: string;
    /**
     * `AWS::ImageBuilder::ContainerRecipe.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-name
     */
    readonly name: string;
    /**
     * `AWS::ImageBuilder::ContainerRecipe.ParentImage`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-parentimage
     */
    readonly parentImage: string;
    /**
     * `AWS::ImageBuilder::ContainerRecipe.TargetRepository`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-targetrepository
     */
    readonly targetRepository: CfnContainerRecipe.TargetContainerRepositoryProperty | cdk.IResolvable;
    /**
     * `AWS::ImageBuilder::ContainerRecipe.Version`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-version
     */
    readonly version: string;
    /**
     * `AWS::ImageBuilder::ContainerRecipe.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-description
     */
    readonly description?: string;
    /**
     * `AWS::ImageBuilder::ContainerRecipe.DockerfileTemplateData`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-dockerfiletemplatedata
     */
    readonly dockerfileTemplateData?: string;
    /**
     * `AWS::ImageBuilder::ContainerRecipe.DockerfileTemplateUri`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-dockerfiletemplateuri
     */
    readonly dockerfileTemplateUri?: string;
    /**
     * `AWS::ImageBuilder::ContainerRecipe.ImageOsVersionOverride`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-imageosversionoverride
     */
    readonly imageOsVersionOverride?: string;
    /**
     * `AWS::ImageBuilder::ContainerRecipe.InstanceConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-instanceconfiguration
     */
    readonly instanceConfiguration?: CfnContainerRecipe.InstanceConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::ImageBuilder::ContainerRecipe.KmsKeyId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-kmskeyid
     */
    readonly kmsKeyId?: string;
    /**
     * `AWS::ImageBuilder::ContainerRecipe.PlatformOverride`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-platformoverride
     */
    readonly platformOverride?: string;
    /**
     * `AWS::ImageBuilder::ContainerRecipe.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-tags
     */
    readonly tags?: {
        [key: string]: (string);
    };
    /**
     * `AWS::ImageBuilder::ContainerRecipe.WorkingDirectory`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-workingdirectory
     */
    readonly workingDirectory?: string;
}
/**
 * A CloudFormation `AWS::ImageBuilder::ContainerRecipe`.
 *
 * @external
 * @cloudformationResource AWS::ImageBuilder::ContainerRecipe
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html
 */
export declare class CfnContainerRecipe extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ImageBuilder::ContainerRecipe";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnContainerRecipe;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Name
     */
    readonly attrName: string;
    /**
     * `AWS::ImageBuilder::ContainerRecipe.Components`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-components
     */
    components: Array<CfnContainerRecipe.ComponentConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ImageBuilder::ContainerRecipe.ContainerType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-containertype
     */
    containerType: string;
    /**
     * `AWS::ImageBuilder::ContainerRecipe.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-name
     */
    name: string;
    /**
     * `AWS::ImageBuilder::ContainerRecipe.ParentImage`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-parentimage
     */
    parentImage: string;
    /**
     * `AWS::ImageBuilder::ContainerRecipe.TargetRepository`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-targetrepository
     */
    targetRepository: CfnContainerRecipe.TargetContainerRepositoryProperty | cdk.IResolvable;
    /**
     * `AWS::ImageBuilder::ContainerRecipe.Version`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-version
     */
    version: string;
    /**
     * `AWS::ImageBuilder::ContainerRecipe.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-description
     */
    description: string | undefined;
    /**
     * `AWS::ImageBuilder::ContainerRecipe.DockerfileTemplateData`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-dockerfiletemplatedata
     */
    dockerfileTemplateData: string | undefined;
    /**
     * `AWS::ImageBuilder::ContainerRecipe.DockerfileTemplateUri`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-dockerfiletemplateuri
     */
    dockerfileTemplateUri: string | undefined;
    /**
     * `AWS::ImageBuilder::ContainerRecipe.ImageOsVersionOverride`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-imageosversionoverride
     */
    imageOsVersionOverride: string | undefined;
    /**
     * `AWS::ImageBuilder::ContainerRecipe.InstanceConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-instanceconfiguration
     */
    instanceConfiguration: CfnContainerRecipe.InstanceConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ImageBuilder::ContainerRecipe.KmsKeyId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-kmskeyid
     */
    kmsKeyId: string | undefined;
    /**
     * `AWS::ImageBuilder::ContainerRecipe.PlatformOverride`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-platformoverride
     */
    platformOverride: string | undefined;
    /**
     * `AWS::ImageBuilder::ContainerRecipe.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::ImageBuilder::ContainerRecipe.WorkingDirectory`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-workingdirectory
     */
    workingDirectory: string | undefined;
    /**
     * Create a new `AWS::ImageBuilder::ContainerRecipe`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnContainerRecipeProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ImageBuilder::ContainerRecipe`.
 *
 * @external
 * @cloudformationResource AWS::ImageBuilder::ContainerRecipe
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html
 */
export declare namespace CfnContainerRecipe {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-containerrecipe-componentconfiguration.html
     */
    interface ComponentConfigurationProperty {
        /**
         * `CfnContainerRecipe.ComponentConfigurationProperty.ComponentArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-containerrecipe-componentconfiguration.html#cfn-imagebuilder-containerrecipe-componentconfiguration-componentarn
         */
        readonly componentArn?: string;
    }
}
/**
 * A CloudFormation `AWS::ImageBuilder::ContainerRecipe`.
 *
 * @external
 * @cloudformationResource AWS::ImageBuilder::ContainerRecipe
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html
 */
export declare namespace CfnContainerRecipe {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-containerrecipe-ebsinstanceblockdevicespecification.html
     */
    interface EbsInstanceBlockDeviceSpecificationProperty {
        /**
         * `CfnContainerRecipe.EbsInstanceBlockDeviceSpecificationProperty.DeleteOnTermination`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-containerrecipe-ebsinstanceblockdevicespecification.html#cfn-imagebuilder-containerrecipe-ebsinstanceblockdevicespecification-deleteontermination
         */
        readonly deleteOnTermination?: boolean | cdk.IResolvable;
        /**
         * `CfnContainerRecipe.EbsInstanceBlockDeviceSpecificationProperty.Encrypted`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-containerrecipe-ebsinstanceblockdevicespecification.html#cfn-imagebuilder-containerrecipe-ebsinstanceblockdevicespecification-encrypted
         */
        readonly encrypted?: boolean | cdk.IResolvable;
        /**
         * `CfnContainerRecipe.EbsInstanceBlockDeviceSpecificationProperty.Iops`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-containerrecipe-ebsinstanceblockdevicespecification.html#cfn-imagebuilder-containerrecipe-ebsinstanceblockdevicespecification-iops
         */
        readonly iops?: number;
        /**
         * `CfnContainerRecipe.EbsInstanceBlockDeviceSpecificationProperty.KmsKeyId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-containerrecipe-ebsinstanceblockdevicespecification.html#cfn-imagebuilder-containerrecipe-ebsinstanceblockdevicespecification-kmskeyid
         */
        readonly kmsKeyId?: string;
        /**
         * `CfnContainerRecipe.EbsInstanceBlockDeviceSpecificationProperty.SnapshotId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-containerrecipe-ebsinstanceblockdevicespecification.html#cfn-imagebuilder-containerrecipe-ebsinstanceblockdevicespecification-snapshotid
         */
        readonly snapshotId?: string;
        /**
         * `CfnContainerRecipe.EbsInstanceBlockDeviceSpecificationProperty.VolumeSize`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-containerrecipe-ebsinstanceblockdevicespecification.html#cfn-imagebuilder-containerrecipe-ebsinstanceblockdevicespecification-volumesize
         */
        readonly volumeSize?: number;
        /**
         * `CfnContainerRecipe.EbsInstanceBlockDeviceSpecificationProperty.VolumeType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-containerrecipe-ebsinstanceblockdevicespecification.html#cfn-imagebuilder-containerrecipe-ebsinstanceblockdevicespecification-volumetype
         */
        readonly volumeType?: string;
    }
}
/**
 * A CloudFormation `AWS::ImageBuilder::ContainerRecipe`.
 *
 * @external
 * @cloudformationResource AWS::ImageBuilder::ContainerRecipe
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html
 */
export declare namespace CfnContainerRecipe {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-containerrecipe-instanceblockdevicemapping.html
     */
    interface InstanceBlockDeviceMappingProperty {
        /**
         * `CfnContainerRecipe.InstanceBlockDeviceMappingProperty.DeviceName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-containerrecipe-instanceblockdevicemapping.html#cfn-imagebuilder-containerrecipe-instanceblockdevicemapping-devicename
         */
        readonly deviceName?: string;
        /**
         * `CfnContainerRecipe.InstanceBlockDeviceMappingProperty.Ebs`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-containerrecipe-instanceblockdevicemapping.html#cfn-imagebuilder-containerrecipe-instanceblockdevicemapping-ebs
         */
        readonly ebs?: CfnContainerRecipe.EbsInstanceBlockDeviceSpecificationProperty | cdk.IResolvable;
        /**
         * `CfnContainerRecipe.InstanceBlockDeviceMappingProperty.NoDevice`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-containerrecipe-instanceblockdevicemapping.html#cfn-imagebuilder-containerrecipe-instanceblockdevicemapping-nodevice
         */
        readonly noDevice?: string;
        /**
         * `CfnContainerRecipe.InstanceBlockDeviceMappingProperty.VirtualName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-containerrecipe-instanceblockdevicemapping.html#cfn-imagebuilder-containerrecipe-instanceblockdevicemapping-virtualname
         */
        readonly virtualName?: string;
    }
}
/**
 * A CloudFormation `AWS::ImageBuilder::ContainerRecipe`.
 *
 * @external
 * @cloudformationResource AWS::ImageBuilder::ContainerRecipe
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html
 */
export declare namespace CfnContainerRecipe {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-containerrecipe-instanceconfiguration.html
     */
    interface InstanceConfigurationProperty {
        /**
         * `CfnContainerRecipe.InstanceConfigurationProperty.BlockDeviceMappings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-containerrecipe-instanceconfiguration.html#cfn-imagebuilder-containerrecipe-instanceconfiguration-blockdevicemappings
         */
        readonly blockDeviceMappings?: Array<CfnContainerRecipe.InstanceBlockDeviceMappingProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnContainerRecipe.InstanceConfigurationProperty.Image`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-containerrecipe-instanceconfiguration.html#cfn-imagebuilder-containerrecipe-instanceconfiguration-image
         */
        readonly image?: string;
    }
}
/**
 * A CloudFormation `AWS::ImageBuilder::ContainerRecipe`.
 *
 * @external
 * @cloudformationResource AWS::ImageBuilder::ContainerRecipe
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html
 */
export declare namespace CfnContainerRecipe {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-containerrecipe-targetcontainerrepository.html
     */
    interface TargetContainerRepositoryProperty {
        /**
         * `CfnContainerRecipe.TargetContainerRepositoryProperty.RepositoryName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-containerrecipe-targetcontainerrepository.html#cfn-imagebuilder-containerrecipe-targetcontainerrepository-repositoryname
         */
        readonly repositoryName?: string;
        /**
         * `CfnContainerRecipe.TargetContainerRepositoryProperty.Service`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-containerrecipe-targetcontainerrepository.html#cfn-imagebuilder-containerrecipe-targetcontainerrepository-service
         */
        readonly service?: string;
    }
}
/**
 * Properties for defining a `AWS::ImageBuilder::DistributionConfiguration`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-distributionconfiguration.html
 */
export interface CfnDistributionConfigurationProps {
    /**
     * `AWS::ImageBuilder::DistributionConfiguration.Distributions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-distributionconfiguration.html#cfn-imagebuilder-distributionconfiguration-distributions
     */
    readonly distributions: Array<CfnDistributionConfiguration.DistributionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ImageBuilder::DistributionConfiguration.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-distributionconfiguration.html#cfn-imagebuilder-distributionconfiguration-name
     */
    readonly name: string;
    /**
     * `AWS::ImageBuilder::DistributionConfiguration.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-distributionconfiguration.html#cfn-imagebuilder-distributionconfiguration-description
     */
    readonly description?: string;
    /**
     * `AWS::ImageBuilder::DistributionConfiguration.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-distributionconfiguration.html#cfn-imagebuilder-distributionconfiguration-tags
     */
    readonly tags?: {
        [key: string]: (string);
    };
}
/**
 * A CloudFormation `AWS::ImageBuilder::DistributionConfiguration`.
 *
 * @external
 * @cloudformationResource AWS::ImageBuilder::DistributionConfiguration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-distributionconfiguration.html
 */
export declare class CfnDistributionConfiguration extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ImageBuilder::DistributionConfiguration";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDistributionConfiguration;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Name
     */
    readonly attrName: string;
    /**
     * `AWS::ImageBuilder::DistributionConfiguration.Distributions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-distributionconfiguration.html#cfn-imagebuilder-distributionconfiguration-distributions
     */
    distributions: Array<CfnDistributionConfiguration.DistributionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ImageBuilder::DistributionConfiguration.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-distributionconfiguration.html#cfn-imagebuilder-distributionconfiguration-name
     */
    name: string;
    /**
     * `AWS::ImageBuilder::DistributionConfiguration.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-distributionconfiguration.html#cfn-imagebuilder-distributionconfiguration-description
     */
    description: string | undefined;
    /**
     * `AWS::ImageBuilder::DistributionConfiguration.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-distributionconfiguration.html#cfn-imagebuilder-distributionconfiguration-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::ImageBuilder::DistributionConfiguration`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDistributionConfigurationProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ImageBuilder::DistributionConfiguration`.
 *
 * @external
 * @cloudformationResource AWS::ImageBuilder::DistributionConfiguration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-distributionconfiguration.html
 */
export declare namespace CfnDistributionConfiguration {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-distributionconfiguration-distribution.html
     */
    interface DistributionProperty {
        /**
         * `CfnDistributionConfiguration.DistributionProperty.AmiDistributionConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-distributionconfiguration-distribution.html#cfn-imagebuilder-distributionconfiguration-distribution-amidistributionconfiguration
         */
        readonly amiDistributionConfiguration?: any | cdk.IResolvable;
        /**
         * `CfnDistributionConfiguration.DistributionProperty.ContainerDistributionConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-distributionconfiguration-distribution.html#cfn-imagebuilder-distributionconfiguration-distribution-containerdistributionconfiguration
         */
        readonly containerDistributionConfiguration?: any | cdk.IResolvable;
        /**
         * `CfnDistributionConfiguration.DistributionProperty.LaunchTemplateConfigurations`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-distributionconfiguration-distribution.html#cfn-imagebuilder-distributionconfiguration-distribution-launchtemplateconfigurations
         */
        readonly launchTemplateConfigurations?: Array<CfnDistributionConfiguration.LaunchTemplateConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDistributionConfiguration.DistributionProperty.LicenseConfigurationArns`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-distributionconfiguration-distribution.html#cfn-imagebuilder-distributionconfiguration-distribution-licenseconfigurationarns
         */
        readonly licenseConfigurationArns?: string[];
        /**
         * `CfnDistributionConfiguration.DistributionProperty.Region`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-distributionconfiguration-distribution.html#cfn-imagebuilder-distributionconfiguration-distribution-region
         */
        readonly region: string;
    }
}
/**
 * A CloudFormation `AWS::ImageBuilder::DistributionConfiguration`.
 *
 * @external
 * @cloudformationResource AWS::ImageBuilder::DistributionConfiguration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-distributionconfiguration.html
 */
export declare namespace CfnDistributionConfiguration {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-distributionconfiguration-launchtemplateconfiguration.html
     */
    interface LaunchTemplateConfigurationProperty {
        /**
         * `CfnDistributionConfiguration.LaunchTemplateConfigurationProperty.AccountId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-distributionconfiguration-launchtemplateconfiguration.html#cfn-imagebuilder-distributionconfiguration-launchtemplateconfiguration-accountid
         */
        readonly accountId?: string;
        /**
         * `CfnDistributionConfiguration.LaunchTemplateConfigurationProperty.LaunchTemplateId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-distributionconfiguration-launchtemplateconfiguration.html#cfn-imagebuilder-distributionconfiguration-launchtemplateconfiguration-launchtemplateid
         */
        readonly launchTemplateId?: string;
        /**
         * `CfnDistributionConfiguration.LaunchTemplateConfigurationProperty.SetDefaultVersion`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-distributionconfiguration-launchtemplateconfiguration.html#cfn-imagebuilder-distributionconfiguration-launchtemplateconfiguration-setdefaultversion
         */
        readonly setDefaultVersion?: boolean | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::ImageBuilder::Image`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html
 */
export interface CfnImageProps {
    /**
     * `AWS::ImageBuilder::Image.InfrastructureConfigurationArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html#cfn-imagebuilder-image-infrastructureconfigurationarn
     */
    readonly infrastructureConfigurationArn: string;
    /**
     * `AWS::ImageBuilder::Image.ContainerRecipeArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html#cfn-imagebuilder-image-containerrecipearn
     */
    readonly containerRecipeArn?: string;
    /**
     * `AWS::ImageBuilder::Image.DistributionConfigurationArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html#cfn-imagebuilder-image-distributionconfigurationarn
     */
    readonly distributionConfigurationArn?: string;
    /**
     * `AWS::ImageBuilder::Image.EnhancedImageMetadataEnabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html#cfn-imagebuilder-image-enhancedimagemetadataenabled
     */
    readonly enhancedImageMetadataEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::ImageBuilder::Image.ImageRecipeArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html#cfn-imagebuilder-image-imagerecipearn
     */
    readonly imageRecipeArn?: string;
    /**
     * `AWS::ImageBuilder::Image.ImageTestsConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html#cfn-imagebuilder-image-imagetestsconfiguration
     */
    readonly imageTestsConfiguration?: CfnImage.ImageTestsConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::ImageBuilder::Image.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html#cfn-imagebuilder-image-tags
     */
    readonly tags?: {
        [key: string]: (string);
    };
}
/**
 * A CloudFormation `AWS::ImageBuilder::Image`.
 *
 * @external
 * @cloudformationResource AWS::ImageBuilder::Image
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html
 */
export declare class CfnImage extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ImageBuilder::Image";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnImage;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute ImageId
     */
    readonly attrImageId: string;
    /**
     * @external
     * @cloudformationAttribute Name
     */
    readonly attrName: string;
    /**
     * `AWS::ImageBuilder::Image.InfrastructureConfigurationArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html#cfn-imagebuilder-image-infrastructureconfigurationarn
     */
    infrastructureConfigurationArn: string;
    /**
     * `AWS::ImageBuilder::Image.ContainerRecipeArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html#cfn-imagebuilder-image-containerrecipearn
     */
    containerRecipeArn: string | undefined;
    /**
     * `AWS::ImageBuilder::Image.DistributionConfigurationArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html#cfn-imagebuilder-image-distributionconfigurationarn
     */
    distributionConfigurationArn: string | undefined;
    /**
     * `AWS::ImageBuilder::Image.EnhancedImageMetadataEnabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html#cfn-imagebuilder-image-enhancedimagemetadataenabled
     */
    enhancedImageMetadataEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::ImageBuilder::Image.ImageRecipeArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html#cfn-imagebuilder-image-imagerecipearn
     */
    imageRecipeArn: string | undefined;
    /**
     * `AWS::ImageBuilder::Image.ImageTestsConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html#cfn-imagebuilder-image-imagetestsconfiguration
     */
    imageTestsConfiguration: CfnImage.ImageTestsConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ImageBuilder::Image.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html#cfn-imagebuilder-image-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::ImageBuilder::Image`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnImageProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ImageBuilder::Image`.
 *
 * @external
 * @cloudformationResource AWS::ImageBuilder::Image
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html
 */
export declare namespace CfnImage {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-image-imagetestsconfiguration.html
     */
    interface ImageTestsConfigurationProperty {
        /**
         * `CfnImage.ImageTestsConfigurationProperty.ImageTestsEnabled`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-image-imagetestsconfiguration.html#cfn-imagebuilder-image-imagetestsconfiguration-imagetestsenabled
         */
        readonly imageTestsEnabled?: boolean | cdk.IResolvable;
        /**
         * `CfnImage.ImageTestsConfigurationProperty.TimeoutMinutes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-image-imagetestsconfiguration.html#cfn-imagebuilder-image-imagetestsconfiguration-timeoutminutes
         */
        readonly timeoutMinutes?: number;
    }
}
/**
 * Properties for defining a `AWS::ImageBuilder::ImagePipeline`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html
 */
export interface CfnImagePipelineProps {
    /**
     * `AWS::ImageBuilder::ImagePipeline.InfrastructureConfigurationArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-infrastructureconfigurationarn
     */
    readonly infrastructureConfigurationArn: string;
    /**
     * `AWS::ImageBuilder::ImagePipeline.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-name
     */
    readonly name: string;
    /**
     * `AWS::ImageBuilder::ImagePipeline.ContainerRecipeArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-containerrecipearn
     */
    readonly containerRecipeArn?: string;
    /**
     * `AWS::ImageBuilder::ImagePipeline.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-description
     */
    readonly description?: string;
    /**
     * `AWS::ImageBuilder::ImagePipeline.DistributionConfigurationArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-distributionconfigurationarn
     */
    readonly distributionConfigurationArn?: string;
    /**
     * `AWS::ImageBuilder::ImagePipeline.EnhancedImageMetadataEnabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-enhancedimagemetadataenabled
     */
    readonly enhancedImageMetadataEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::ImageBuilder::ImagePipeline.ImageRecipeArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-imagerecipearn
     */
    readonly imageRecipeArn?: string;
    /**
     * `AWS::ImageBuilder::ImagePipeline.ImageTestsConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-imagetestsconfiguration
     */
    readonly imageTestsConfiguration?: CfnImagePipeline.ImageTestsConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::ImageBuilder::ImagePipeline.Schedule`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-schedule
     */
    readonly schedule?: CfnImagePipeline.ScheduleProperty | cdk.IResolvable;
    /**
     * `AWS::ImageBuilder::ImagePipeline.Status`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-status
     */
    readonly status?: string;
    /**
     * `AWS::ImageBuilder::ImagePipeline.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-tags
     */
    readonly tags?: {
        [key: string]: (string);
    };
}
/**
 * A CloudFormation `AWS::ImageBuilder::ImagePipeline`.
 *
 * @external
 * @cloudformationResource AWS::ImageBuilder::ImagePipeline
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html
 */
export declare class CfnImagePipeline extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ImageBuilder::ImagePipeline";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnImagePipeline;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Name
     */
    readonly attrName: string;
    /**
     * `AWS::ImageBuilder::ImagePipeline.InfrastructureConfigurationArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-infrastructureconfigurationarn
     */
    infrastructureConfigurationArn: string;
    /**
     * `AWS::ImageBuilder::ImagePipeline.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-name
     */
    name: string;
    /**
     * `AWS::ImageBuilder::ImagePipeline.ContainerRecipeArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-containerrecipearn
     */
    containerRecipeArn: string | undefined;
    /**
     * `AWS::ImageBuilder::ImagePipeline.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-description
     */
    description: string | undefined;
    /**
     * `AWS::ImageBuilder::ImagePipeline.DistributionConfigurationArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-distributionconfigurationarn
     */
    distributionConfigurationArn: string | undefined;
    /**
     * `AWS::ImageBuilder::ImagePipeline.EnhancedImageMetadataEnabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-enhancedimagemetadataenabled
     */
    enhancedImageMetadataEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::ImageBuilder::ImagePipeline.ImageRecipeArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-imagerecipearn
     */
    imageRecipeArn: string | undefined;
    /**
     * `AWS::ImageBuilder::ImagePipeline.ImageTestsConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-imagetestsconfiguration
     */
    imageTestsConfiguration: CfnImagePipeline.ImageTestsConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ImageBuilder::ImagePipeline.Schedule`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-schedule
     */
    schedule: CfnImagePipeline.ScheduleProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ImageBuilder::ImagePipeline.Status`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-status
     */
    status: string | undefined;
    /**
     * `AWS::ImageBuilder::ImagePipeline.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::ImageBuilder::ImagePipeline`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnImagePipelineProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ImageBuilder::ImagePipeline`.
 *
 * @external
 * @cloudformationResource AWS::ImageBuilder::ImagePipeline
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html
 */
export declare namespace CfnImagePipeline {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagepipeline-imagetestsconfiguration.html
     */
    interface ImageTestsConfigurationProperty {
        /**
         * `CfnImagePipeline.ImageTestsConfigurationProperty.ImageTestsEnabled`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagepipeline-imagetestsconfiguration.html#cfn-imagebuilder-imagepipeline-imagetestsconfiguration-imagetestsenabled
         */
        readonly imageTestsEnabled?: boolean | cdk.IResolvable;
        /**
         * `CfnImagePipeline.ImageTestsConfigurationProperty.TimeoutMinutes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagepipeline-imagetestsconfiguration.html#cfn-imagebuilder-imagepipeline-imagetestsconfiguration-timeoutminutes
         */
        readonly timeoutMinutes?: number;
    }
}
/**
 * A CloudFormation `AWS::ImageBuilder::ImagePipeline`.
 *
 * @external
 * @cloudformationResource AWS::ImageBuilder::ImagePipeline
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html
 */
export declare namespace CfnImagePipeline {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagepipeline-schedule.html
     */
    interface ScheduleProperty {
        /**
         * `CfnImagePipeline.ScheduleProperty.PipelineExecutionStartCondition`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagepipeline-schedule.html#cfn-imagebuilder-imagepipeline-schedule-pipelineexecutionstartcondition
         */
        readonly pipelineExecutionStartCondition?: string;
        /**
         * `CfnImagePipeline.ScheduleProperty.ScheduleExpression`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagepipeline-schedule.html#cfn-imagebuilder-imagepipeline-schedule-scheduleexpression
         */
        readonly scheduleExpression?: string;
    }
}
/**
 * Properties for defining a `AWS::ImageBuilder::ImageRecipe`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html
 */
export interface CfnImageRecipeProps {
    /**
     * `AWS::ImageBuilder::ImageRecipe.Components`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-components
     */
    readonly components: Array<CfnImageRecipe.ComponentConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ImageBuilder::ImageRecipe.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-name
     */
    readonly name: string;
    /**
     * `AWS::ImageBuilder::ImageRecipe.ParentImage`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-parentimage
     */
    readonly parentImage: string;
    /**
     * `AWS::ImageBuilder::ImageRecipe.Version`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-version
     */
    readonly version: string;
    /**
     * `AWS::ImageBuilder::ImageRecipe.AdditionalInstanceConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-additionalinstanceconfiguration
     */
    readonly additionalInstanceConfiguration?: CfnImageRecipe.AdditionalInstanceConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::ImageBuilder::ImageRecipe.BlockDeviceMappings`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-blockdevicemappings
     */
    readonly blockDeviceMappings?: Array<CfnImageRecipe.InstanceBlockDeviceMappingProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ImageBuilder::ImageRecipe.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-description
     */
    readonly description?: string;
    /**
     * `AWS::ImageBuilder::ImageRecipe.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-tags
     */
    readonly tags?: {
        [key: string]: (string);
    };
    /**
     * `AWS::ImageBuilder::ImageRecipe.WorkingDirectory`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-workingdirectory
     */
    readonly workingDirectory?: string;
}
/**
 * A CloudFormation `AWS::ImageBuilder::ImageRecipe`.
 *
 * @external
 * @cloudformationResource AWS::ImageBuilder::ImageRecipe
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html
 */
export declare class CfnImageRecipe extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ImageBuilder::ImageRecipe";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnImageRecipe;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Name
     */
    readonly attrName: string;
    /**
     * `AWS::ImageBuilder::ImageRecipe.Components`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-components
     */
    components: Array<CfnImageRecipe.ComponentConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ImageBuilder::ImageRecipe.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-name
     */
    name: string;
    /**
     * `AWS::ImageBuilder::ImageRecipe.ParentImage`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-parentimage
     */
    parentImage: string;
    /**
     * `AWS::ImageBuilder::ImageRecipe.Version`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-version
     */
    version: string;
    /**
     * `AWS::ImageBuilder::ImageRecipe.AdditionalInstanceConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-additionalinstanceconfiguration
     */
    additionalInstanceConfiguration: CfnImageRecipe.AdditionalInstanceConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ImageBuilder::ImageRecipe.BlockDeviceMappings`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-blockdevicemappings
     */
    blockDeviceMappings: Array<CfnImageRecipe.InstanceBlockDeviceMappingProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ImageBuilder::ImageRecipe.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-description
     */
    description: string | undefined;
    /**
     * `AWS::ImageBuilder::ImageRecipe.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::ImageBuilder::ImageRecipe.WorkingDirectory`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-workingdirectory
     */
    workingDirectory: string | undefined;
    /**
     * Create a new `AWS::ImageBuilder::ImageRecipe`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnImageRecipeProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ImageBuilder::ImageRecipe`.
 *
 * @external
 * @cloudformationResource AWS::ImageBuilder::ImageRecipe
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html
 */
export declare namespace CfnImageRecipe {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagerecipe-additionalinstanceconfiguration.html
     */
    interface AdditionalInstanceConfigurationProperty {
        /**
         * `CfnImageRecipe.AdditionalInstanceConfigurationProperty.SystemsManagerAgent`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagerecipe-additionalinstanceconfiguration.html#cfn-imagebuilder-imagerecipe-additionalinstanceconfiguration-systemsmanageragent
         */
        readonly systemsManagerAgent?: CfnImageRecipe.SystemsManagerAgentProperty | cdk.IResolvable;
        /**
         * `CfnImageRecipe.AdditionalInstanceConfigurationProperty.UserDataOverride`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagerecipe-additionalinstanceconfiguration.html#cfn-imagebuilder-imagerecipe-additionalinstanceconfiguration-userdataoverride
         */
        readonly userDataOverride: string;
    }
}
/**
 * A CloudFormation `AWS::ImageBuilder::ImageRecipe`.
 *
 * @external
 * @cloudformationResource AWS::ImageBuilder::ImageRecipe
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html
 */
export declare namespace CfnImageRecipe {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagerecipe-componentconfiguration.html
     */
    interface ComponentConfigurationProperty {
        /**
         * `CfnImageRecipe.ComponentConfigurationProperty.ComponentArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagerecipe-componentconfiguration.html#cfn-imagebuilder-imagerecipe-componentconfiguration-componentarn
         */
        readonly componentArn?: string;
        /**
         * `CfnImageRecipe.ComponentConfigurationProperty.Parameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagerecipe-componentconfiguration.html#cfn-imagebuilder-imagerecipe-componentconfiguration-parameters
         */
        readonly parameters?: Array<CfnImageRecipe.ComponentParameterProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ImageBuilder::ImageRecipe`.
 *
 * @external
 * @cloudformationResource AWS::ImageBuilder::ImageRecipe
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html
 */
export declare namespace CfnImageRecipe {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagerecipe-componentparameter.html
     */
    interface ComponentParameterProperty {
        /**
         * `CfnImageRecipe.ComponentParameterProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagerecipe-componentparameter.html#cfn-imagebuilder-imagerecipe-componentparameter-name
         */
        readonly name: string;
        /**
         * `CfnImageRecipe.ComponentParameterProperty.Value`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagerecipe-componentparameter.html#cfn-imagebuilder-imagerecipe-componentparameter-value
         */
        readonly value: string[];
    }
}
/**
 * A CloudFormation `AWS::ImageBuilder::ImageRecipe`.
 *
 * @external
 * @cloudformationResource AWS::ImageBuilder::ImageRecipe
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html
 */
export declare namespace CfnImageRecipe {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagerecipe-ebsinstanceblockdevicespecification.html
     */
    interface EbsInstanceBlockDeviceSpecificationProperty {
        /**
         * `CfnImageRecipe.EbsInstanceBlockDeviceSpecificationProperty.DeleteOnTermination`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagerecipe-ebsinstanceblockdevicespecification.html#cfn-imagebuilder-imagerecipe-ebsinstanceblockdevicespecification-deleteontermination
         */
        readonly deleteOnTermination?: boolean | cdk.IResolvable;
        /**
         * `CfnImageRecipe.EbsInstanceBlockDeviceSpecificationProperty.Encrypted`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagerecipe-ebsinstanceblockdevicespecification.html#cfn-imagebuilder-imagerecipe-ebsinstanceblockdevicespecification-encrypted
         */
        readonly encrypted?: boolean | cdk.IResolvable;
        /**
         * `CfnImageRecipe.EbsInstanceBlockDeviceSpecificationProperty.Iops`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagerecipe-ebsinstanceblockdevicespecification.html#cfn-imagebuilder-imagerecipe-ebsinstanceblockdevicespecification-iops
         */
        readonly iops?: number;
        /**
         * `CfnImageRecipe.EbsInstanceBlockDeviceSpecificationProperty.KmsKeyId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagerecipe-ebsinstanceblockdevicespecification.html#cfn-imagebuilder-imagerecipe-ebsinstanceblockdevicespecification-kmskeyid
         */
        readonly kmsKeyId?: string;
        /**
         * `CfnImageRecipe.EbsInstanceBlockDeviceSpecificationProperty.SnapshotId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagerecipe-ebsinstanceblockdevicespecification.html#cfn-imagebuilder-imagerecipe-ebsinstanceblockdevicespecification-snapshotid
         */
        readonly snapshotId?: string;
        /**
         * `CfnImageRecipe.EbsInstanceBlockDeviceSpecificationProperty.VolumeSize`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagerecipe-ebsinstanceblockdevicespecification.html#cfn-imagebuilder-imagerecipe-ebsinstanceblockdevicespecification-volumesize
         */
        readonly volumeSize?: number;
        /**
         * `CfnImageRecipe.EbsInstanceBlockDeviceSpecificationProperty.VolumeType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagerecipe-ebsinstanceblockdevicespecification.html#cfn-imagebuilder-imagerecipe-ebsinstanceblockdevicespecification-volumetype
         */
        readonly volumeType?: string;
    }
}
/**
 * A CloudFormation `AWS::ImageBuilder::ImageRecipe`.
 *
 * @external
 * @cloudformationResource AWS::ImageBuilder::ImageRecipe
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html
 */
export declare namespace CfnImageRecipe {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagerecipe-instanceblockdevicemapping.html
     */
    interface InstanceBlockDeviceMappingProperty {
        /**
         * `CfnImageRecipe.InstanceBlockDeviceMappingProperty.DeviceName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagerecipe-instanceblockdevicemapping.html#cfn-imagebuilder-imagerecipe-instanceblockdevicemapping-devicename
         */
        readonly deviceName?: string;
        /**
         * `CfnImageRecipe.InstanceBlockDeviceMappingProperty.Ebs`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagerecipe-instanceblockdevicemapping.html#cfn-imagebuilder-imagerecipe-instanceblockdevicemapping-ebs
         */
        readonly ebs?: CfnImageRecipe.EbsInstanceBlockDeviceSpecificationProperty | cdk.IResolvable;
        /**
         * `CfnImageRecipe.InstanceBlockDeviceMappingProperty.NoDevice`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagerecipe-instanceblockdevicemapping.html#cfn-imagebuilder-imagerecipe-instanceblockdevicemapping-nodevice
         */
        readonly noDevice?: string;
        /**
         * `CfnImageRecipe.InstanceBlockDeviceMappingProperty.VirtualName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagerecipe-instanceblockdevicemapping.html#cfn-imagebuilder-imagerecipe-instanceblockdevicemapping-virtualname
         */
        readonly virtualName?: string;
    }
}
/**
 * A CloudFormation `AWS::ImageBuilder::ImageRecipe`.
 *
 * @external
 * @cloudformationResource AWS::ImageBuilder::ImageRecipe
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html
 */
export declare namespace CfnImageRecipe {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagerecipe-systemsmanageragent.html
     */
    interface SystemsManagerAgentProperty {
        /**
         * `CfnImageRecipe.SystemsManagerAgentProperty.UninstallAfterBuild`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagerecipe-systemsmanageragent.html#cfn-imagebuilder-imagerecipe-systemsmanageragent-uninstallafterbuild
         */
        readonly uninstallAfterBuild: boolean | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::ImageBuilder::InfrastructureConfiguration`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html
 */
export interface CfnInfrastructureConfigurationProps {
    /**
     * `AWS::ImageBuilder::InfrastructureConfiguration.InstanceProfileName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-instanceprofilename
     */
    readonly instanceProfileName: string;
    /**
     * `AWS::ImageBuilder::InfrastructureConfiguration.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-name
     */
    readonly name: string;
    /**
     * `AWS::ImageBuilder::InfrastructureConfiguration.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-description
     */
    readonly description?: string;
    /**
     * `AWS::ImageBuilder::InfrastructureConfiguration.InstanceTypes`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-instancetypes
     */
    readonly instanceTypes?: string[];
    /**
     * `AWS::ImageBuilder::InfrastructureConfiguration.KeyPair`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-keypair
     */
    readonly keyPair?: string;
    /**
     * `AWS::ImageBuilder::InfrastructureConfiguration.Logging`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-logging
     */
    readonly logging?: CfnInfrastructureConfiguration.LoggingProperty | cdk.IResolvable;
    /**
     * `AWS::ImageBuilder::InfrastructureConfiguration.ResourceTags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-resourcetags
     */
    readonly resourceTags?: {
        [key: string]: (string);
    } | cdk.IResolvable;
    /**
     * `AWS::ImageBuilder::InfrastructureConfiguration.SecurityGroupIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-securitygroupids
     */
    readonly securityGroupIds?: string[];
    /**
     * `AWS::ImageBuilder::InfrastructureConfiguration.SnsTopicArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-snstopicarn
     */
    readonly snsTopicArn?: string;
    /**
     * `AWS::ImageBuilder::InfrastructureConfiguration.SubnetId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-subnetid
     */
    readonly subnetId?: string;
    /**
     * `AWS::ImageBuilder::InfrastructureConfiguration.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-tags
     */
    readonly tags?: {
        [key: string]: (string);
    };
    /**
     * `AWS::ImageBuilder::InfrastructureConfiguration.TerminateInstanceOnFailure`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-terminateinstanceonfailure
     */
    readonly terminateInstanceOnFailure?: boolean | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::ImageBuilder::InfrastructureConfiguration`.
 *
 * @external
 * @cloudformationResource AWS::ImageBuilder::InfrastructureConfiguration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html
 */
export declare class CfnInfrastructureConfiguration extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ImageBuilder::InfrastructureConfiguration";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnInfrastructureConfiguration;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Name
     */
    readonly attrName: string;
    /**
     * `AWS::ImageBuilder::InfrastructureConfiguration.InstanceProfileName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-instanceprofilename
     */
    instanceProfileName: string;
    /**
     * `AWS::ImageBuilder::InfrastructureConfiguration.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-name
     */
    name: string;
    /**
     * `AWS::ImageBuilder::InfrastructureConfiguration.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-description
     */
    description: string | undefined;
    /**
     * `AWS::ImageBuilder::InfrastructureConfiguration.InstanceTypes`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-instancetypes
     */
    instanceTypes: string[] | undefined;
    /**
     * `AWS::ImageBuilder::InfrastructureConfiguration.KeyPair`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-keypair
     */
    keyPair: string | undefined;
    /**
     * `AWS::ImageBuilder::InfrastructureConfiguration.Logging`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-logging
     */
    logging: CfnInfrastructureConfiguration.LoggingProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ImageBuilder::InfrastructureConfiguration.ResourceTags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-resourcetags
     */
    resourceTags: {
        [key: string]: (string);
    } | cdk.IResolvable | undefined;
    /**
     * `AWS::ImageBuilder::InfrastructureConfiguration.SecurityGroupIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-securitygroupids
     */
    securityGroupIds: string[] | undefined;
    /**
     * `AWS::ImageBuilder::InfrastructureConfiguration.SnsTopicArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-snstopicarn
     */
    snsTopicArn: string | undefined;
    /**
     * `AWS::ImageBuilder::InfrastructureConfiguration.SubnetId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-subnetid
     */
    subnetId: string | undefined;
    /**
     * `AWS::ImageBuilder::InfrastructureConfiguration.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::ImageBuilder::InfrastructureConfiguration.TerminateInstanceOnFailure`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-terminateinstanceonfailure
     */
    terminateInstanceOnFailure: boolean | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::ImageBuilder::InfrastructureConfiguration`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnInfrastructureConfigurationProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ImageBuilder::InfrastructureConfiguration`.
 *
 * @external
 * @cloudformationResource AWS::ImageBuilder::InfrastructureConfiguration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html
 */
export declare namespace CfnInfrastructureConfiguration {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-infrastructureconfiguration-logging.html
     */
    interface LoggingProperty {
        /**
         * `CfnInfrastructureConfiguration.LoggingProperty.S3Logs`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-infrastructureconfiguration-logging.html#cfn-imagebuilder-infrastructureconfiguration-logging-s3logs
         */
        readonly s3Logs?: CfnInfrastructureConfiguration.S3LogsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ImageBuilder::InfrastructureConfiguration`.
 *
 * @external
 * @cloudformationResource AWS::ImageBuilder::InfrastructureConfiguration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html
 */
export declare namespace CfnInfrastructureConfiguration {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-infrastructureconfiguration-s3logs.html
     */
    interface S3LogsProperty {
        /**
         * `CfnInfrastructureConfiguration.S3LogsProperty.S3BucketName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-infrastructureconfiguration-s3logs.html#cfn-imagebuilder-infrastructureconfiguration-s3logs-s3bucketname
         */
        readonly s3BucketName?: string;
        /**
         * `CfnInfrastructureConfiguration.S3LogsProperty.S3KeyPrefix`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-infrastructureconfiguration-s3logs.html#cfn-imagebuilder-infrastructureconfiguration-s3logs-s3keyprefix
         */
        readonly s3KeyPrefix?: string;
    }
}
