from plone.formwidget.recurrence import pfr_message, pl_message
from zope.i18n import translate


PARAMETERS = u"""{{
displayUnactivate: '{display_unactivate}',
displayActivate: '{display_activate}',
add_rules: '{add_rules}',
edit_rules: '{edit_rules}',
delete_rules: '{delete_rules}',
add: '{add}',
refresh: '{refresh}',
title: '{title}',
preview: '{preview}',
addDate: '{add_date}',
recurrenceType: '{recurrence_type}',
dailyInterval1: '{daily_interval_1}',
dailyInterval2: '{daily_interval_2}',
weeklyInterval1: '{weekly_interval_1}',
weeklyInterval2: '{weekly_interval_2}',
weeklyWeekdays: '{weekly_weekdays}',
weeklyWeekdaysHuman: '{weekly_weekdays_human}',
monthlyInterval1: '{monthly_interval_1}',
monthlyInterval2: '{monthly_interval_2}',
monthlyDayOfMonth1: '{monthly_day_of_month_1}',
monthlyDayOfMonth1Human: '{monthly_day_of_month_1_human}',
monthlyDayOfMonth2: '{monthly_day_of_month_2}',
monthlyDayOfMonth3: '{monthly_day_of_month_3}',
monthlyDayOfMonth4: '{monthly_day_of_month_4}',
monthlyWeekdayOfMonth1: '{monthly_weekday_of_month_1}',
monthlyWeekdayOfMonth1Human: '{monthly_weekday_of_month_1_human}',
monthlyWeekdayOfMonth2: '{monthly_weekday_of_month_2}',
monthlyWeekdayOfMonth3: '{monthly_weekday_of_month_3}',
monthlyRepeatOn: '{monthly_repeat_on}',
yearlyInterval1: '{yearly_interval_1}',
yearlyInterval2: '{yearly_interval_2}',
yearlyDayOfMonth1: '{yearly_day_of_month_1}',
yearlyDayOfMonth1Human: '{yearly_day_of_month_1_human}',
yearlyDayOfMonth2: '{yearly_day_of_month_2}',
yearlyDayOfMonth3: '{yearly_day_of_month_3}',
yearlyWeekdayOfMonth1: '{yearly_weekday_of_month_1}',
yearlyWeekdayOfMonth1Human: '{yearly_weekday_of_month_1_human}',
yearlyWeekdayOfMonth2: '{yearly_weekday_of_month_2}',
yearlyWeekdayOfMonth3: '{yearly_weekday_of_month_3}',
yearlyWeekdayOfMonth4: '{yearly_weekday_of_month_4}',
yearlyRepeatOn: '{yearly_repeat_on}',
range: '{range}',
rangeNoEnd: '{range_no_end}',
rangeByOccurrences1: '{range_by_occurrences_1}',
rangeByOccurrences1Human: '{range_by_occurrences_1_human}',
rangeByOccurrences2: '{range_by_occurrences_2}',
rangeByEndDate: '{range_by_end_date}',
rangeByEndDateHuman: '{range_by_end_date_human}',
including: '{including}',
except: '{except}',
cancel: '{cancel}',
save: '{save}',
recurrenceStart: '{recurrence_start}',
additionalDate: '{additional_date}',
include: '{include}',
exclude: '{exclude}',
remove: '{remove}',
orderIndexes: [
    '{order_indexes_first}', '{order_indexes_second}', '{order_indexes_third}',
    '{order_indexes_fourth}', '{order_indexes_last}'],
months: [
    '{month_january}', '{month_february}', '{month_march}', '{month_april}',
    '{month_may}', '{month_june}', '{month_july}', '{month_august}',
    '{month_september}', '{month_october}', '{month_november}', '{month_december}'],
shortMonths: [
    '{month_january_short}', '{month_february_short}', '{month_march_short}',
    '{month_april_short}', '{month_may_short}', '{month_june_short}',
    '{month_july_short}', '{month_august_short}', '{month_september_short}',
    '{month_october_short}', '{month_november_short}', '{month_december_short}'],
weekdays: [
    '{day_sunday}', '{day_monday}', '{day_tuesday}', '{day_wednesday}',
    '{day_thirsday}', '{day_friday}', '{day_saturday}'],
shortWeekdays: [
    '{day_sunday_short}', '{day_monday_short}', '{day_tuesday_short}',
    '{day_wednesday_short}', '{day_thirsday_short}', '{day_friday_short}',
    '{day_saturday_short}'],
longDateFormat: '{long_date_format}',
shortDateFormat: '{short_date_format}',
unsupportedFeatures: '{unsupported_features}',
noTemplateMatch: '{no_template_match}',
multipleDayOfMonth: '{multiple_day_of_month}',
bysetpos: '{bysetpos}',
noRule: '{no_rule}',
noRepeatEvery: '{no_repeat_every}',
noEndDate: '{no_end_date}',
noRepeatOn: '{no_repeat_on}',
pastEndDate: '{past_end_date}',
noEndAfterNOccurrences: '{no_end_after_n_occurrences}',
alreadyAdded: '{already_added}',
rtemplate: {{
    daily: '{template_daily}',
    mondayfriday: '{template_mondayfriday}',
    weekdays: '{template_weekdays}',
    weekly: '{template_weekly}',
    monthly: '{template_monthly}',
    yearly: '{template_yearly}',
    }}
}}"""

# We can create the messages on startup, although translations
# need to be done per request:
messages = {
    'display_unactivate': pfr_message(u'display_unactivate'),
    'display_activate': pfr_message(u'display_activate'),
    'add_rules': pfr_message(u'add_rules'),
    'edit_rules': pfr_message(u'edit_rules'),
    'delete_rules': pfr_message(u'delete_rules'),
    'add': pfr_message(u'add'),
    'refresh': pfr_message(u'refresh'),
    'title': pfr_message(u'title'),
    'preview': pfr_message(u'preview'),
    'add_date': pfr_message(u'add_date'),
    'recurrence_type': pfr_message(u'recurrence_type'),
    'daily_interval_1': pfr_message(u'daily_interval_1'),
    'daily_interval_2': pfr_message(u'daily_interval_2'),
    'weekly_interval_1': pfr_message(u'weekly_interval_1'),
    'weekly_interval_2': pfr_message(u'weekly_interval_2'),
    'weekly_weekdays': pfr_message(u'weekly_weekdays'),
    'weekly_weekdays_human': pfr_message(u'weekly_weekdays_human'),
    'monthly_interval_1': pfr_message(u'monthly_interval_1'),
    'monthly_interval_2': pfr_message(u'monthly_interval_2'),
    'monthly_day_of_month_1': pfr_message(u'monthly_day_of_month_1'),
    'monthly_day_of_month_1_human': pfr_message(u'monthly_day_of_month_1_human'),
    'monthly_day_of_month_2': pfr_message(u'monthly_day_of_month_2'),
    'monthly_day_of_month_3': pfr_message(u'monthly_day_of_month_3'),
    'monthly_day_of_month_4': pfr_message(u'monthly_day_of_month_4'),
    'monthly_weekday_of_month_1': pfr_message(u'monthly_weekday_of_month_1'),
    'monthly_weekday_of_month_1_human': pfr_message(u'monthly_weekday_of_month_1_human'),
    'monthly_weekday_of_month_2': pfr_message(u'monthly_weekday_of_month_2'),
    'monthly_weekday_of_month_3': pfr_message(u'monthly_weekday_of_month_3'),
    'monthly_repeat_on': pfr_message(u'monthly_repeat_on'),
    'yearly_interval_1': pfr_message(u'yearly_interval_1'),
    'yearly_interval_2': pfr_message(u'yearly_interval_2'),
    'yearly_day_of_month_1': pfr_message(u'yearly_day_of_month_1'),
    'yearly_day_of_month_1_human': pfr_message(u'yearly_day_of_month_1_human'),
    'yearly_day_of_month_2': pfr_message(u'yearly_day_of_month_2'),
    'yearly_day_of_month_3': pfr_message(u'yearly_day_of_month_3'),
    'yearly_weekday_of_month_1': pfr_message(u'yearly_weekday_of_month_1'),
    'yearly_weekday_of_month_1_human': pfr_message(u'yearly_weekday_of_month_1_human'),
    'yearly_weekday_of_month_2': pfr_message(u'yearly_weekday_of_month_2'),
    'yearly_weekday_of_month_3': pfr_message(u'yearly_weekday_of_month_3'),
    'yearly_weekday_of_month_4': pfr_message(u'yearly_weekday_of_month_4'),
    'yearly_repeat_on': pfr_message(u'yearly_repeat_on'),
    'range': pfr_message(u'range'),
    'range_no_end': pfr_message(u'range_no_end'),
    'range_by_occurrences_1': pfr_message(u'range_by_occurrences_1'),
    'range_by_occurrences_1_human': pfr_message(u'range_by_occurrences_1_human'),
    'range_by_occurrences_2': pfr_message(u'range_by_occurrences_2'),
    'range_by_end_date': pfr_message(u'range_by_end_date'),
    'range_by_end_date_human': pfr_message(u'range_by_end_date_human'),
    'including': pfr_message(u'including'),
    'except': pfr_message(u'except'),
    'cancel': pfr_message(u'cancel'),
    'save': pfr_message(u'save'),
    'recurrence_start': pfr_message(u'recurrence_start'),
    'additional_date': pfr_message(u'additional_date'),
    'include': pfr_message(u'include'),
    'exclude': pfr_message(u'exclude'),
    'remove': pfr_message(u'remove'),
    'order_indexes_first': pfr_message(u'order_indexes_first'),
    'order_indexes_second': pfr_message(u'order_indexes_second'),
    'order_indexes_third': pfr_message(u'order_indexes_third'),
    'order_indexes_fourth': pfr_message(u'order_indexes_fourth'),
    'order_indexes_last': pfr_message(u'order_indexes_last'),
    'month_january': pl_message(u'month_jan'),
    'month_february': pl_message(u'month_feb'),
    'month_march': pl_message(u'month_mar'),
    'month_april': pl_message(u'month_apr'),
    'month_may': pl_message(u'month_may'),
    'month_june': pl_message(u'month_jun'),
    'month_july': pl_message(u'month_jul'),
    'month_august': pl_message(u'month_aug'),
    'month_september': pl_message(u'month_sep'),
    'month_october': pl_message(u'month_oct'),
    'month_november': pl_message(u'month_nov'),
    'month_december': pl_message(u'month_dec'),
    'month_january_short': pl_message(u'month_jan_abbr'),
    'month_february_short': pl_message(u'month_feb_abbr'),
    'month_march_short': pl_message(u'month_mar_abbr'),
    'month_april_short': pl_message(u'month_apr_abbr'),
    'month_may_short': pl_message(u'month_may_abbr'),
    'month_june_short': pl_message(u'month_jun_abbr'),
    'month_july_short': pl_message(u'month_jul_abbr'),
    'month_august_short': pl_message(u'month_aug_abbr'),
    'month_september_short': pl_message(u'month_sep_abbr'),
    'month_october_short': pl_message(u'month_oct_abbr'),
    'month_november_short': pl_message(u'month_nov_abbr'),
    'month_december_short': pl_message(u'month_dec_abbr'),
    'day_monday': pl_message(u'weekday_mon'),
    'day_tuesday': pl_message(u'weekday_tue'),
    'day_wednesday': pl_message(u'weekday_wed'),
    'day_thirsday': pl_message(u'weekday_thu'),
    'day_friday': pl_message(u'weekday_fri'),
    'day_saturday': pl_message(u'weekday_sat'),
    'day_sunday': pl_message(u'weekday_sun'),
    'day_monday_short': pl_message(u'weekday_mon_abbr'),
    'day_tuesday_short': pl_message(u'weekday_tue_abbr'),
    'day_wednesday_short': pl_message(u'weekday_wed_abbr'),
    'day_thirsday_short': pl_message(u'weekday_thu_abbr'),
    'day_friday_short': pl_message(u'weekday_fri_abbr'),
    'day_saturday_short': pl_message(u'weekday_sat_abbr'),
    'day_sunday_short': pl_message(u'weekday_sun_abbr'),
    'long_date_format': pfr_message(u'long_date_format'),
    'short_date_format': pl_message(u'date_format_short_datepicker'),
    'unsupported_features': pfr_message(u'unsupported_features'),
    'no_template_match': pfr_message(u'no_template_match'),
    'multiple_day_of_month': pfr_message(u'multiple_day_of_month'),
    'bysetpos': pfr_message(u'bysetpos'),
    'no_rule': pfr_message(u'no_rule'),
    'no_repeat_every': pfr_message(u'no_repeat_every'),
    'no_end_date': pfr_message(u'no_end_date'),
    'no_repeat_on': pfr_message(u'no_repeat_on'),
    'past_end_date': pfr_message(u'past_end_date'),
    'no_end_after_n_occurrences': pfr_message(u'no_end_after_n_occurrences'),
    'already_added': pfr_message(u'already_added'),
    'template_daily': pfr_message(u'template_daily'),
    'template_mondayfriday': pfr_message(u'template_mondayfriday'),
    'template_weekdays': pfr_message(u'template_weekdays'),
    'template_weekly': pfr_message(u'template_weekly'),
    'template_monthly': pfr_message(u'template_monthly'),
    'template_yearly': pfr_message(u'template_yearly'),
}


# = translate(messages['display_unactivate'], context=request),
def translations(request):
    xlated = dict([
        (msg, translate(messages[msg], context=request).replace("'", "\\'"))
        for msg in messages
    ])
    return PARAMETERS.format(**xlated)
