# Generated by Django 4.1 on 2022-08-18 09:20

import django.contrib.postgres.fields
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Department',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='最后更新时间')),
                ('name', models.CharField(max_length=32, verbose_name='部门名称')),
                ('path', django.contrib.postgres.fields.ArrayField(base_field=models.IntegerField(verbose_name='上级部门ID'), null=True, size=None, verbose_name='所属部门路径')),
                ('organization_id', models.IntegerField(verbose_name='组织id')),
                ('charger_id', models.IntegerField(null=True, verbose_name='负责人ID')),
                ('show_order', models.IntegerField(default=0, verbose_name='顺序')),
                ('is_deleted', models.BooleanField(default=False, verbose_name='部门是否删除, 默认False')),
            ],
            options={
                'db_table': 'department',
                'ordering': ['show_order'],
                'index_together': {('organization_id', 'is_deleted')},
            },
        ),
        migrations.CreateModel(
            name='Position',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='最后更新时间')),
                ('name', models.CharField(max_length=32, verbose_name='岗位名称')),
                ('desc', models.CharField(blank=True, max_length=255, null=True, verbose_name='岗位描述')),
                ('organization_id', models.IntegerField(verbose_name='组织id')),
                ('is_deleted', models.BooleanField(default=False, verbose_name='是否删除，默认不删除')),
                ('is_edited', models.BooleanField(default=True, verbose_name='是否可以被删除，编辑')),
            ],
            options={
                'verbose_name': '岗位',
                'db_table': 'middle_position',
                'unique_together': {('name', 'organization_id')},
            },
        ),
        migrations.CreateModel(
            name='Role',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='最后更新时间')),
                ('name', models.CharField(max_length=32, verbose_name='角色名称')),
                ('desc', models.CharField(blank=True, max_length=255, null=True, verbose_name='角色描述')),
                ('organization_id', models.IntegerField(verbose_name='组织id')),
                ('is_deleted', models.BooleanField(default=False, verbose_name='是否被删除，默认没有被删除')),
                ('is_enabled', models.BooleanField(default=True, verbose_name='是否被启用，默认被启用')),
                ('is_edited', models.BooleanField(default=True, verbose_name='是否可以被删除，编辑')),
            ],
            options={
                'verbose_name': '角色',
                'db_table': 'middle_roles',
                'unique_together': {('name', 'organization_id')},
            },
        ),
        migrations.CreateModel(
            name='UserInformation',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='最后更新时间')),
                ('user_id', models.IntegerField(unique=True, verbose_name='用户id')),
                ('position', models.CharField(max_length=64, verbose_name='职位')),
                ('leader_user_id', models.IntegerField(verbose_name='直属领导id')),
                ('is_deleted', models.BooleanField(default=False, verbose_name='部门是否删除, 默认False')),
            ],
            options={
                'db_table': 'user_information',
            },
        ),
        migrations.CreateModel(
            name='UserRole',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='最后更新时间')),
                ('user_id', models.IntegerField(verbose_name='用户ID')),
                ('role', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='departments.role', verbose_name='角色')),
            ],
            options={
                'verbose_name': '用户角色关系表',
                'db_table': 'middle_user_roles_map',
                'unique_together': {('user_id', 'role')},
            },
        ),
        migrations.CreateModel(
            name='UserPosition',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='最后更新时间')),
                ('user_id', models.IntegerField(verbose_name='用户id')),
                ('position', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='departments.position', verbose_name='岗位')),
            ],
            options={
                'verbose_name': '用户岗位关系表',
                'db_table': 'middle_user_position_map',
                'unique_together': {('user_id', 'position')},
            },
        ),
        migrations.CreateModel(
            name='DepartmentUserMap',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='最后更新时间')),
                ('user_id', models.IntegerField(verbose_name='用户id')),
                ('department', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='departments.department', verbose_name='部门id')),
            ],
            options={
                'db_table': 'department_user_map',
                'unique_together': {('department', 'user_id')},
            },
        ),
    ]
