"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FargateToSecretsmanager = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const core_1 = require("@aws-cdk/core");
const defaults = require("@aws-solutions-constructs/core");
class FargateToSecretsmanager extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        defaults.CheckFargateProps(props);
        // Other permissions for constructs are accepted as arrays, turning grantWriteAccess into
        // an array to use the same validation function.
        if (props.grantWriteAccess) {
            const allowedPermissions = ['READ', 'READWRITE'];
            defaults.CheckListValues(allowedPermissions, [props.grantWriteAccess.toUpperCase()], 'grantWriteAccess');
        }
        this.vpc = defaults.buildVpc(scope, {
            existingVpc: props.existingVpc,
            defaultVpcProps: props.publicApi ? defaults.DefaultPublicPrivateVpcProps() : defaults.DefaultIsolatedVpcProps(),
            userVpcProps: props.vpcProps,
            constructVpcProps: { enableDnsHostnames: true, enableDnsSupport: true }
        });
        defaults.AddAwsServiceEndpoint(scope, this.vpc, defaults.ServiceEndpointTypes.SECRETS_MANAGER);
        if (props.existingFargateServiceObject) {
            this.service = props.existingFargateServiceObject;
            // CheckFargateProps confirms that the container is provided
            this.container = props.existingContainerDefinitionObject;
        }
        else {
            [this.service, this.container] = defaults.CreateFargateService(scope, id, this.vpc, props.clusterProps, props.ecrRepositoryArn, props.ecrImageVersion, props.fargateTaskDefinitionProps, props.containerDefinitionProps, props.fargateServiceProps);
        }
        if (props.existingSecretObj) {
            this.secret = props.existingSecretObj;
        }
        else {
            this.secret = defaults.buildSecretsManagerSecret(this, 'secret', props.secretProps);
        }
        // Enable read permissions for the Fargate service role by default
        this.secret.grantRead(this.service.taskDefinition.taskRole);
        if (props.grantWriteAccess) {
            const permission = props.grantWriteAccess.toUpperCase();
            if (permission === 'READWRITE') {
                this.secret.grantWrite(this.service.taskDefinition.taskRole);
            }
        }
        // Configure environment variables
        const secretEnvironmentVariableName = props.secretEnvironmentVariableName || 'SECRET_ARN';
        this.container.addEnvironment(secretEnvironmentVariableName, this.secret.secretArn);
    }
}
exports.FargateToSecretsmanager = FargateToSecretsmanager;
_a = JSII_RTTI_SYMBOL_1;
FargateToSecretsmanager[_a] = { fqn: "@aws-solutions-constructs/aws-fargate-secretsmanager.FargateToSecretsmanager", version: "1.165.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbmRleC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQWVBLHdGQUF3RjtBQUN4Rix3Q0FBMEM7QUFDMUMsMkRBQTJEO0FBaUgzRCxNQUFhLHVCQUF3QixTQUFRLGdCQUFTO0lBTXBELFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBbUM7UUFDM0UsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUNqQixRQUFRLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQzNCLFFBQVEsQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUVsQyx5RkFBeUY7UUFDekYsZ0RBQWdEO1FBQ2hELElBQUksS0FBSyxDQUFDLGdCQUFnQixFQUFFO1lBQzFCLE1BQU0sa0JBQWtCLEdBQUcsQ0FBQyxNQUFNLEVBQUUsV0FBVyxDQUFDLENBQUM7WUFDakQsUUFBUSxDQUFDLGVBQWUsQ0FBQyxrQkFBa0IsRUFBRSxDQUFDLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxXQUFXLEVBQUUsQ0FBQyxFQUFFLGtCQUFrQixDQUFDLENBQUM7U0FDMUc7UUFFRCxJQUFJLENBQUMsR0FBRyxHQUFHLFFBQVEsQ0FBQyxRQUFRLENBQUMsS0FBSyxFQUFFO1lBQ2xDLFdBQVcsRUFBRSxLQUFLLENBQUMsV0FBVztZQUM5QixlQUFlLEVBQUUsS0FBSyxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUMsUUFBUSxDQUFDLDRCQUE0QixFQUFFLENBQUMsQ0FBQyxDQUFDLFFBQVEsQ0FBQyx1QkFBdUIsRUFBRTtZQUMvRyxZQUFZLEVBQUUsS0FBSyxDQUFDLFFBQVE7WUFDNUIsaUJBQWlCLEVBQUUsRUFBRSxrQkFBa0IsRUFBRSxJQUFJLEVBQUUsZ0JBQWdCLEVBQUUsSUFBSSxFQUFFO1NBQ3hFLENBQUMsQ0FBQztRQUVILFFBQVEsQ0FBQyxxQkFBcUIsQ0FBQyxLQUFLLEVBQUUsSUFBSSxDQUFDLEdBQUcsRUFBRSxRQUFRLENBQUMsb0JBQW9CLENBQUMsZUFBZSxDQUFDLENBQUM7UUFFL0YsSUFBSSxLQUFLLENBQUMsNEJBQTRCLEVBQUU7WUFDdEMsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUMsNEJBQTRCLENBQUM7WUFDbEQsNERBQTREO1lBQzVELElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDLGlDQUFrQyxDQUFDO1NBQzNEO2FBQU07WUFDTCxDQUFDLElBQUksQ0FBQyxPQUFPLEVBQUUsSUFBSSxDQUFDLFNBQVMsQ0FBQyxHQUFHLFFBQVEsQ0FBQyxvQkFBb0IsQ0FDNUQsS0FBSyxFQUNMLEVBQUUsRUFDRixJQUFJLENBQUMsR0FBRyxFQUNSLEtBQUssQ0FBQyxZQUFZLEVBQ2xCLEtBQUssQ0FBQyxnQkFBZ0IsRUFDdEIsS0FBSyxDQUFDLGVBQWUsRUFDckIsS0FBSyxDQUFDLDBCQUEwQixFQUNoQyxLQUFLLENBQUMsd0JBQXdCLEVBQzlCLEtBQUssQ0FBQyxtQkFBbUIsQ0FDMUIsQ0FBQztTQUNIO1FBRUQsSUFBSSxLQUFLLENBQUMsaUJBQWlCLEVBQUU7WUFDM0IsSUFBSSxDQUFDLE1BQU0sR0FBRyxLQUFLLENBQUMsaUJBQWlCLENBQUM7U0FDdkM7YUFBTTtZQUNMLElBQUksQ0FBQyxNQUFNLEdBQUcsUUFBUSxDQUFDLHlCQUF5QixDQUFDLElBQUksRUFBRSxRQUFRLEVBQUUsS0FBSyxDQUFDLFdBQVcsQ0FBQyxDQUFDO1NBQ3JGO1FBRUQsa0VBQWtFO1FBQ2xFLElBQUksQ0FBQyxNQUFNLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsY0FBYyxDQUFDLFFBQVEsQ0FBQyxDQUFDO1FBRTVELElBQUksS0FBSyxDQUFDLGdCQUFnQixFQUFFO1lBQzFCLE1BQU0sVUFBVSxHQUFHLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxXQUFXLEVBQUUsQ0FBQztZQUV4RCxJQUFJLFVBQVUsS0FBSyxXQUFXLEVBQUU7Z0JBQzlCLElBQUksQ0FBQyxNQUFNLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsY0FBYyxDQUFDLFFBQVEsQ0FBQyxDQUFDO2FBQzlEO1NBQ0Y7UUFFRCxrQ0FBa0M7UUFDbEMsTUFBTSw2QkFBNkIsR0FBRyxLQUFLLENBQUMsNkJBQTZCLElBQUksWUFBWSxDQUFDO1FBQzFGLElBQUksQ0FBQyxTQUFTLENBQUMsY0FBYyxDQUFDLDZCQUE2QixFQUFFLElBQUksQ0FBQyxNQUFNLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDdEYsQ0FBQzs7QUFqRUgsMERBa0VDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiAgQ29weXJpZ2h0IDIwMjIgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiAgTGljZW5zZWQgdW5kZXIgdGhlIEFwYWNoZSBMaWNlbnNlLCBWZXJzaW9uIDIuMCAodGhlIFwiTGljZW5zZVwiKS4gWW91IG1heSBub3QgdXNlIHRoaXMgZmlsZSBleGNlcHQgaW4gY29tcGxpYW5jZVxuICogIHdpdGggdGhlIExpY2Vuc2UuIEEgY29weSBvZiB0aGUgTGljZW5zZSBpcyBsb2NhdGVkIGF0XG4gKlxuICogICAgICBodHRwOi8vd3d3LmFwYWNoZS5vcmcvbGljZW5zZXMvTElDRU5TRS0yLjBcbiAqXG4gKiAgb3IgaW4gdGhlICdsaWNlbnNlJyBmaWxlIGFjY29tcGFueWluZyB0aGlzIGZpbGUuIFRoaXMgZmlsZSBpcyBkaXN0cmlidXRlZCBvbiBhbiAnQVMgSVMnIEJBU0lTLCBXSVRIT1VUIFdBUlJBTlRJRVNcbiAqICBPUiBDT05ESVRJT05TIE9GIEFOWSBLSU5ELCBleHByZXNzIG9yIGltcGxpZWQuIFNlZSB0aGUgTGljZW5zZSBmb3IgdGhlIHNwZWNpZmljIGxhbmd1YWdlIGdvdmVybmluZyBwZXJtaXNzaW9uc1xuICogIGFuZCBsaW1pdGF0aW9ucyB1bmRlciB0aGUgTGljZW5zZS5cbiAqL1xuXG5pbXBvcnQgKiBhcyBlYzIgZnJvbSBcIkBhd3MtY2RrL2F3cy1lYzJcIjtcbmltcG9ydCAqIGFzIHNlY3JldHNtYW5hZ2VyIGZyb20gXCJAYXdzLWNkay9hd3Mtc2VjcmV0c21hbmFnZXJcIjtcbi8vIE5vdGU6IFRvIGVuc3VyZSBDREt2MiBjb21wYXRpYmlsaXR5LCBrZWVwIHRoZSBpbXBvcnQgc3RhdGVtZW50IGZvciBDb25zdHJ1Y3Qgc2VwYXJhdGVcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gXCJAYXdzLWNkay9jb3JlXCI7XG5pbXBvcnQgKiBhcyBkZWZhdWx0cyBmcm9tIFwiQGF3cy1zb2x1dGlvbnMtY29uc3RydWN0cy9jb3JlXCI7XG5pbXBvcnQgKiBhcyBlY3MgZnJvbSBcIkBhd3MtY2RrL2F3cy1lY3NcIjtcblxuZXhwb3J0IGludGVyZmFjZSBGYXJnYXRlVG9TZWNyZXRzbWFuYWdlclByb3BzIHtcbiAgLyoqXG4gICAqIFdoZXRoZXIgdGhlIGNvbnN0cnVjdCBpcyBkZXBsb3lpbmcgYSBwcml2YXRlIG9yIHB1YmxpYyBBUEkuIFRoaXMgaGFzIGltcGxpY2F0aW9ucyBmb3IgdGhlIFZQQyBkZXBsb3llZFxuICAgKiBieSB0aGlzIGNvbnN0cnVjdC5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBub25lXG4gICAqL1xuICByZWFkb25seSBwdWJsaWNBcGk6IGJvb2xlYW47XG4gIC8qKlxuICAgKiBPcHRpb25hbCBjdXN0b20gcHJvcGVydGllcyBmb3IgYSBWUEMgdGhlIGNvbnN0cnVjdCB3aWxsIGNyZWF0ZS4gVGhpcyBWUEMgd2lsbFxuICAgKiBiZSB1c2VkIGJ5IHRoZSBuZXcgRmFyZ2F0ZSBzZXJ2aWNlIHRoZSBjb25zdHJ1Y3QgY3JlYXRlcyAodGhhdCdzXG4gICAqIHdoeSB0YXJnZXRHcm91cFByb3BzIGNhbid0IGluY2x1ZGUgYSBWUEMpLiBQcm92aWRpbmdcbiAgICogYm90aCB0aGlzIGFuZCBleGlzdGluZ1ZwYyBpcyBhbiBlcnJvci4gQSBTZWNyZXRzIE1hbmFnZXIgSW50ZXJmYWNlXG4gICAqIGVuZHBvaW50IHdpbGwgYmUgaW5jbHVkZWQgaW4gdGhpcyBWUEMuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gbm9uZVxuICAgKi9cbiAgcmVhZG9ubHkgdnBjUHJvcHM/OiBlYzIuVnBjUHJvcHM7XG4gIC8qKlxuICAgKiBBbiBleGlzdGluZyBWUEMgaW4gd2hpY2ggdG8gZGVwbG95IHRoZSBjb25zdHJ1Y3QuIFByb3ZpZGluZyBib3RoIHRoaXMgYW5kXG4gICAqIHZwY1Byb3BzIGlzIGFuIGVycm9yLiBJZiB0aGUgY2xpZW50IHByb3ZpZGVzIGFuIGV4aXN0aW5nIEZhcmdhdGUgc2VydmljZSxcbiAgICogdGhpcyB2YWx1ZSBtdXN0IGJlIHRoZSBWUEMgd2hlcmUgdGhlIHNlcnZpY2UgaXMgcnVubmluZy4gQSBTZWNyZXRzIE1hbmFnZXIgSW50ZXJmYWNlXG4gICAqIGVuZHBvaW50IHdpbGwgYmUgYWRkZWQgdG8gdGhpcyBWUEMuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gbm9uZVxuICAgKi9cbiAgcmVhZG9ubHkgZXhpc3RpbmdWcGM/OiBlYzIuSVZwYztcbiAgLyoqXG4gICAqIE9wdGlvbmFsIHByb3BlcnRpZXMgdG8gY3JlYXRlIGEgbmV3IEVDUyBjbHVzdGVyXG4gICAqL1xuICByZWFkb25seSBjbHVzdGVyUHJvcHM/OiBlY3MuQ2x1c3RlclByb3BzO1xuICAvKipcbiAgICogVGhlIGFybiBvZiBhbiBFQ1IgUmVwb3NpdG9yeSBjb250YWluaW5nIHRoZSBpbWFnZSB0byB1c2VcbiAgICogdG8gZ2VuZXJhdGUgdGhlIGNvbnRhaW5lcnNcbiAgICpcbiAgICogZm9ybWF0OlxuICAgKiAgIGFybjphd3M6ZWNyOltyZWdpb25dOlthY2NvdW50IG51bWJlcl06cmVwb3NpdG9yeS9bUmVwb3NpdG9yeSBOYW1lXVxuICAgKi9cbiAgcmVhZG9ubHkgZWNyUmVwb3NpdG9yeUFybj86IHN0cmluZztcbiAgLyoqXG4gICAqIFRoZSB2ZXJzaW9uIG9mIHRoZSBpbWFnZSB0byB1c2UgZnJvbSB0aGUgcmVwb3NpdG9yeVxuICAgKlxuICAgKiBAZGVmYXVsdCAtICdsYXRlc3QnXG4gICAqL1xuICByZWFkb25seSBlY3JJbWFnZVZlcnNpb24/OiBzdHJpbmc7XG4gIC8qXG4gICAqIE9wdGlvbmFsIHByb3BzIHRvIGRlZmluZSB0aGUgY29udGFpbmVyIGNyZWF0ZWQgZm9yIHRoZSBGYXJnYXRlIFNlcnZpY2VcbiAgICpcbiAgICogZGVmYXVsdHMgLSBmYXJnYXRlLWRlZmF1bHRzLnRzXG4gICAqL1xuICByZWFkb25seSBjb250YWluZXJEZWZpbml0aW9uUHJvcHM/OiBlY3MuQ29udGFpbmVyRGVmaW5pdGlvblByb3BzIHwgYW55O1xuICAvKlxuICAgKiBPcHRpb25hbCBwcm9wcyB0byBkZWZpbmUgdGhlIEZhcmdhdGUgVGFzayBEZWZpbml0aW9uIGZvciB0aGlzIGNvbnN0cnVjdFxuICAgKlxuICAgKiBkZWZhdWx0cyAtIGZhcmdhdGUtZGVmYXVsdHMudHNcbiAgICovXG4gIHJlYWRvbmx5IGZhcmdhdGVUYXNrRGVmaW5pdGlvblByb3BzPzogZWNzLkZhcmdhdGVUYXNrRGVmaW5pdGlvblByb3BzIHwgYW55O1xuICAvKipcbiAgICogT3B0aW9uYWwgdmFsdWVzIHRvIG92ZXJyaWRlIGRlZmF1bHQgRmFyZ2F0ZSBUYXNrIGRlZmluaXRpb24gcHJvcGVydGllc1xuICAgKiAoZmFyZ2F0ZS1kZWZhdWx0cy50cykuIFRoZSBjb25zdHJ1Y3Qgd2lsbCBkZWZhdWx0IHRvIGxhdW5jaGluZyB0aGUgc2VydmljZVxuICAgKiBpcyB0aGUgbW9zdCBpc29sYXRlZCBzdWJuZXRzIGF2YWlsYWJsZSAocHJlY2VkZW5jZTogSXNvbGF0ZWQsIFByaXZhdGUgYW5kXG4gICAqIFB1YmxpYykuIE92ZXJyaWRlIHRob3NlIGFuZCBvdGhlciBkZWZhdWx0cyBoZXJlLlxuICAgKlxuICAgKiBkZWZhdWx0cyAtIGZhcmdhdGUtZGVmYXVsdHMudHNcbiAgICovXG4gIHJlYWRvbmx5IGZhcmdhdGVTZXJ2aWNlUHJvcHM/OiBlY3MuRmFyZ2F0ZVNlcnZpY2VQcm9wcyB8IGFueTtcbiAgLyoqXG4gICAqIEEgRmFyZ2F0ZSBTZXJ2aWNlIGFscmVhZHkgaW5zdGFudGlhdGVkIChwcm9iYWJseSBieSBhbm90aGVyIFNvbHV0aW9ucyBDb25zdHJ1Y3QpLiBJZlxuICAgKiB0aGlzIGlzIHNwZWNpZmllZCwgdGhlbiBubyBwcm9wcyBkZWZpbmluZyBhIG5ldyBzZXJ2aWNlIGNhbiBiZSBwcm92aWRlZCwgaW5jbHVkaW5nOlxuICAgKiBleGlzdGluZ0ltYWdlT2JqZWN0LCBlY3JJbWFnZVZlcnNpb24sIGNvbnRhaW5lckRlZmludGlvblByb3BzLCBmYXJnYXRlVGFza0RlZmluaXRpb25Qcm9wcyxcbiAgICogZWNyUmVwb3NpdG9yeUFybiwgZmFyZ2F0ZVNlcnZpY2VQcm9wcywgY2x1c3RlclByb3BzLCBleGlzdGluZ0NsdXN0ZXJJbnRlcmZhY2UuIElmIHRoaXMgdmFsdWVcbiAgICogaXMgcHJvdmlkZWQsIHRoZW4gZXhpc3RpbmdDb250YWluZXJEZWZpbml0aW9uT2JqZWN0IG11c3QgYmUgcHJvdmlkZWQgYXMgd2VsbC5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBub25lXG4gICAqL1xuICByZWFkb25seSBleGlzdGluZ0ZhcmdhdGVTZXJ2aWNlT2JqZWN0PzogZWNzLkZhcmdhdGVTZXJ2aWNlO1xuICAvKlxuICAgKiBBIGNvbnRhaW5lciBkZWZpbml0aW9uIGFscmVhZHkgaW5zdGFudGlhdGVkIGFzIHBhcnQgb2YgYSBGYXJnYXRlIHNlcnZpY2UuIFRoaXMgbXVzdFxuICAgKiBiZSB0aGUgY29udGFpbmVyIGluIHRoZSBleGlzdGluZ0ZhcmdhdGVTZXJ2aWNlT2JqZWN0LlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIE5vbmVcbiAgICovXG4gIHJlYWRvbmx5IGV4aXN0aW5nQ29udGFpbmVyRGVmaW5pdGlvbk9iamVjdD86IGVjcy5Db250YWluZXJEZWZpbml0aW9uO1xuICAvKipcbiAgICogRXhpc3RpbmcgaW5zdGFuY2Ugb2YgU2VjcmV0IG9iamVjdCwgcHJvdmlkaW5nIGJvdGggdGhpcyBhbmQgc2VjcmV0UHJvcHMgd2lsbCBjYXVzZSBhbiBlcnJvci5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBEZWZhdWx0IHByb3BzIGFyZSB1c2VkXG4gICAqL1xuICByZWFkb25seSBleGlzdGluZ1NlY3JldE9iaj86IHNlY3JldHNtYW5hZ2VyLlNlY3JldDtcbiAgLyoqXG4gICAqIE9wdGlvbmFsIHVzZXItcHJvdmlkZWQgcHJvcHMgdG8gb3ZlcnJpZGUgdGhlIGRlZmF1bHQgcHJvcHMgZm9yIHRoZSBTZWNyZXQuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gRGVmYXVsdCBwcm9wcyBhcmUgdXNlZFxuICAgKi9cbiAgcmVhZG9ubHkgc2VjcmV0UHJvcHM/OiBzZWNyZXRzbWFuYWdlci5TZWNyZXRQcm9wcztcblxuICAvKipcbiAgICogT3B0aW9uYWwgQWNjZXNzIGdyYW50ZWQgdG8gdGhlIEZhcmdhdGUgc2VydmljZSBmb3IgdGhlIHNlY3JldC4gJ1JlYWQnIG9yICdSZWFkV3JpdGVcbiAgICpcbiAgICogQGRlZmF1bHQgLSAnUmVhZCdcbiAgICovXG4gIHJlYWRvbmx5IGdyYW50V3JpdGVBY2Nlc3M/OiBzdHJpbmdcbiAgLyoqXG4gICAqIE9wdGlvbmFsIE5hbWUgZm9yIHRoZSBjb250YWluZXIgZW52aXJvbm1lbnQgdmFyaWFibGUgc2V0IHRvIHRoZSBBUk4gb2YgdGhlIHNlY3JldC5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBTRUNSRVRfQVJOXG4gICAqL1xuICByZWFkb25seSBzZWNyZXRFbnZpcm9ubWVudFZhcmlhYmxlTmFtZT86IHN0cmluZztcbn1cblxuZXhwb3J0IGNsYXNzIEZhcmdhdGVUb1NlY3JldHNtYW5hZ2VyIGV4dGVuZHMgQ29uc3RydWN0IHtcbiAgcHVibGljIHJlYWRvbmx5IHZwYzogZWMyLklWcGM7XG4gIHB1YmxpYyByZWFkb25seSBzZXJ2aWNlOiBlY3MuRmFyZ2F0ZVNlcnZpY2U7XG4gIHB1YmxpYyByZWFkb25seSBjb250YWluZXI6IGVjcy5Db250YWluZXJEZWZpbml0aW9uO1xuICBwdWJsaWMgcmVhZG9ubHkgc2VjcmV0OiBzZWNyZXRzbWFuYWdlci5TZWNyZXQ7XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IEZhcmdhdGVUb1NlY3JldHNtYW5hZ2VyUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuICAgIGRlZmF1bHRzLkNoZWNrUHJvcHMocHJvcHMpO1xuICAgIGRlZmF1bHRzLkNoZWNrRmFyZ2F0ZVByb3BzKHByb3BzKTtcblxuICAgIC8vIE90aGVyIHBlcm1pc3Npb25zIGZvciBjb25zdHJ1Y3RzIGFyZSBhY2NlcHRlZCBhcyBhcnJheXMsIHR1cm5pbmcgZ3JhbnRXcml0ZUFjY2VzcyBpbnRvXG4gICAgLy8gYW4gYXJyYXkgdG8gdXNlIHRoZSBzYW1lIHZhbGlkYXRpb24gZnVuY3Rpb24uXG4gICAgaWYgKHByb3BzLmdyYW50V3JpdGVBY2Nlc3MpIHtcbiAgICAgIGNvbnN0IGFsbG93ZWRQZXJtaXNzaW9ucyA9IFsnUkVBRCcsICdSRUFEV1JJVEUnXTtcbiAgICAgIGRlZmF1bHRzLkNoZWNrTGlzdFZhbHVlcyhhbGxvd2VkUGVybWlzc2lvbnMsIFtwcm9wcy5ncmFudFdyaXRlQWNjZXNzLnRvVXBwZXJDYXNlKCldLCAnZ3JhbnRXcml0ZUFjY2VzcycpO1xuICAgIH1cblxuICAgIHRoaXMudnBjID0gZGVmYXVsdHMuYnVpbGRWcGMoc2NvcGUsIHtcbiAgICAgIGV4aXN0aW5nVnBjOiBwcm9wcy5leGlzdGluZ1ZwYyxcbiAgICAgIGRlZmF1bHRWcGNQcm9wczogcHJvcHMucHVibGljQXBpID8gZGVmYXVsdHMuRGVmYXVsdFB1YmxpY1ByaXZhdGVWcGNQcm9wcygpIDogZGVmYXVsdHMuRGVmYXVsdElzb2xhdGVkVnBjUHJvcHMoKSxcbiAgICAgIHVzZXJWcGNQcm9wczogcHJvcHMudnBjUHJvcHMsXG4gICAgICBjb25zdHJ1Y3RWcGNQcm9wczogeyBlbmFibGVEbnNIb3N0bmFtZXM6IHRydWUsIGVuYWJsZURuc1N1cHBvcnQ6IHRydWUgfVxuICAgIH0pO1xuXG4gICAgZGVmYXVsdHMuQWRkQXdzU2VydmljZUVuZHBvaW50KHNjb3BlLCB0aGlzLnZwYywgZGVmYXVsdHMuU2VydmljZUVuZHBvaW50VHlwZXMuU0VDUkVUU19NQU5BR0VSKTtcblxuICAgIGlmIChwcm9wcy5leGlzdGluZ0ZhcmdhdGVTZXJ2aWNlT2JqZWN0KSB7XG4gICAgICB0aGlzLnNlcnZpY2UgPSBwcm9wcy5leGlzdGluZ0ZhcmdhdGVTZXJ2aWNlT2JqZWN0O1xuICAgICAgLy8gQ2hlY2tGYXJnYXRlUHJvcHMgY29uZmlybXMgdGhhdCB0aGUgY29udGFpbmVyIGlzIHByb3ZpZGVkXG4gICAgICB0aGlzLmNvbnRhaW5lciA9IHByb3BzLmV4aXN0aW5nQ29udGFpbmVyRGVmaW5pdGlvbk9iamVjdCE7XG4gICAgfSBlbHNlIHtcbiAgICAgIFt0aGlzLnNlcnZpY2UsIHRoaXMuY29udGFpbmVyXSA9IGRlZmF1bHRzLkNyZWF0ZUZhcmdhdGVTZXJ2aWNlKFxuICAgICAgICBzY29wZSxcbiAgICAgICAgaWQsXG4gICAgICAgIHRoaXMudnBjLFxuICAgICAgICBwcm9wcy5jbHVzdGVyUHJvcHMsXG4gICAgICAgIHByb3BzLmVjclJlcG9zaXRvcnlBcm4sXG4gICAgICAgIHByb3BzLmVjckltYWdlVmVyc2lvbixcbiAgICAgICAgcHJvcHMuZmFyZ2F0ZVRhc2tEZWZpbml0aW9uUHJvcHMsXG4gICAgICAgIHByb3BzLmNvbnRhaW5lckRlZmluaXRpb25Qcm9wcyxcbiAgICAgICAgcHJvcHMuZmFyZ2F0ZVNlcnZpY2VQcm9wc1xuICAgICAgKTtcbiAgICB9XG5cbiAgICBpZiAocHJvcHMuZXhpc3RpbmdTZWNyZXRPYmopIHtcbiAgICAgIHRoaXMuc2VjcmV0ID0gcHJvcHMuZXhpc3RpbmdTZWNyZXRPYmo7XG4gICAgfSBlbHNlIHtcbiAgICAgIHRoaXMuc2VjcmV0ID0gZGVmYXVsdHMuYnVpbGRTZWNyZXRzTWFuYWdlclNlY3JldCh0aGlzLCAnc2VjcmV0JywgcHJvcHMuc2VjcmV0UHJvcHMpO1xuICAgIH1cblxuICAgIC8vIEVuYWJsZSByZWFkIHBlcm1pc3Npb25zIGZvciB0aGUgRmFyZ2F0ZSBzZXJ2aWNlIHJvbGUgYnkgZGVmYXVsdFxuICAgIHRoaXMuc2VjcmV0LmdyYW50UmVhZCh0aGlzLnNlcnZpY2UudGFza0RlZmluaXRpb24udGFza1JvbGUpO1xuXG4gICAgaWYgKHByb3BzLmdyYW50V3JpdGVBY2Nlc3MpIHtcbiAgICAgIGNvbnN0IHBlcm1pc3Npb24gPSBwcm9wcy5ncmFudFdyaXRlQWNjZXNzLnRvVXBwZXJDYXNlKCk7XG5cbiAgICAgIGlmIChwZXJtaXNzaW9uID09PSAnUkVBRFdSSVRFJykge1xuICAgICAgICB0aGlzLnNlY3JldC5ncmFudFdyaXRlKHRoaXMuc2VydmljZS50YXNrRGVmaW5pdGlvbi50YXNrUm9sZSk7XG4gICAgICB9XG4gICAgfVxuXG4gICAgLy8gQ29uZmlndXJlIGVudmlyb25tZW50IHZhcmlhYmxlc1xuICAgIGNvbnN0IHNlY3JldEVudmlyb25tZW50VmFyaWFibGVOYW1lID0gcHJvcHMuc2VjcmV0RW52aXJvbm1lbnRWYXJpYWJsZU5hbWUgfHwgJ1NFQ1JFVF9BUk4nO1xuICAgIHRoaXMuY29udGFpbmVyLmFkZEVudmlyb25tZW50KHNlY3JldEVudmlyb25tZW50VmFyaWFibGVOYW1lLCB0aGlzLnNlY3JldC5zZWNyZXRBcm4pO1xuICB9XG59XG4iXX0=