# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SubnetArgs', 'Subnet']

@pulumi.input_type
class SubnetArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[str],
                 allocation_pools: Optional[pulumi.Input[Sequence[pulumi.Input['SubnetAllocationPoolArgs']]]] = None,
                 allocation_pools_collection: Optional[pulumi.Input[Sequence[pulumi.Input['SubnetAllocationPoolsCollectionArgs']]]] = None,
                 cidr: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dns_nameservers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_dhcp: Optional[pulumi.Input[bool]] = None,
                 gateway_ip: Optional[pulumi.Input[str]] = None,
                 host_routes: Optional[pulumi.Input[Sequence[pulumi.Input['SubnetHostRouteArgs']]]] = None,
                 ip_version: Optional[pulumi.Input[int]] = None,
                 ipv6_address_mode: Optional[pulumi.Input[str]] = None,
                 ipv6_ra_mode: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 no_gateway: Optional[pulumi.Input[bool]] = None,
                 prefix_length: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 service_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 subnetpool_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 value_specs: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        The set of arguments for constructing a Subnet resource.
        :param pulumi.Input[str] network_id: The UUID of the parent network. Changing this
               creates a new subnet.
        :param pulumi.Input[Sequence[pulumi.Input['SubnetAllocationPoolArgs']]] allocation_pools: A block declaring the start and end range of
               the IP addresses available for use with DHCP in this subnet. Multiple
               `allocation_pool` blocks can be declared, providing the subnet with more
               than one range of IP addresses to use with DHCP. However, each IP range
               must be from the same CIDR that the subnet is part of.
               The `allocation_pool` block is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['SubnetAllocationPoolsCollectionArgs']]] allocation_pools_collection: A block declaring the start and end range of the IP addresses available for
               use with DHCP in this subnet.
               The `allocation_pools` block is documented below.
        :param pulumi.Input[str] cidr: CIDR representing IP range for this subnet, based on IP
               version. You can omit this option if you are creating a subnet from a
               subnet pool.
        :param pulumi.Input[str] description: Human-readable description of the subnet. Changing this
               updates the name of the existing subnet.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_nameservers: An array of DNS name server names used by hosts
               in this subnet. Changing this updates the DNS name servers for the existing
               subnet.
        :param pulumi.Input[bool] enable_dhcp: The administrative state of the network.
               Acceptable values are "true" and "false". Changing this value enables or
               disables the DHCP capabilities of the existing subnet. Defaults to true.
        :param pulumi.Input[str] gateway_ip: Default gateway used by devices in this subnet.
               Leaving this blank and not setting `no_gateway` will cause a default
               gateway of `.1` to be used. Changing this updates the gateway IP of the
               existing subnet.
        :param pulumi.Input[Sequence[pulumi.Input['SubnetHostRouteArgs']]] host_routes: (**Deprecated** - use `networking.SubnetRoute`
               instead) An array of routes that should be used by devices
               with IPs from this subnet (not including local subnet route). The host_route
               object structure is documented below. Changing this updates the host routes
               for the existing subnet.
        :param pulumi.Input[int] ip_version: IP version, either 4 (default) or 6. Changing this creates a
               new subnet.
        :param pulumi.Input[str] ipv6_address_mode: The IPv6 address mode. Valid values are
               `dhcpv6-stateful`, `dhcpv6-stateless`, or `slaac`.
        :param pulumi.Input[str] ipv6_ra_mode: The IPv6 Router Advertisement mode. Valid values
               are `dhcpv6-stateful`, `dhcpv6-stateless`, or `slaac`.
        :param pulumi.Input[str] name: The name of the subnet. Changing this updates the name of
               the existing subnet.
        :param pulumi.Input[bool] no_gateway: Do not set a gateway IP on this subnet. Changing
               this removes or adds a default gateway IP of the existing subnet.
        :param pulumi.Input[int] prefix_length: The prefix length to use when creating a subnet
               from a subnet pool. The default subnet pool prefix length that was defined
               when creating the subnet pool will be used if not provided. Changing this
               creates a new subnet.
        :param pulumi.Input[str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create a Neutron subnet. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               subnet.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] service_types: An array of service types used by the subnet.
               Changing this updates the service types for the existing subnet.
        :param pulumi.Input[str] subnetpool_id: The ID of the subnetpool associated with the subnet.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A set of string tags for the subnet.
        :param pulumi.Input[str] tenant_id: The owner of the subnet. Required if admin wants to
               create a subnet for another tenant. Changing this creates a new subnet.
        :param pulumi.Input[Mapping[str, Any]] value_specs: Map of additional options.
        """
        pulumi.set(__self__, "network_id", network_id)
        if allocation_pools is not None:
            pulumi.set(__self__, "allocation_pools", allocation_pools)
        if allocation_pools_collection is not None:
            warnings.warn("""use allocation_pool instead""", DeprecationWarning)
            pulumi.log.warn("""allocation_pools_collection is deprecated: use allocation_pool instead""")
        if allocation_pools_collection is not None:
            pulumi.set(__self__, "allocation_pools_collection", allocation_pools_collection)
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dns_nameservers is not None:
            pulumi.set(__self__, "dns_nameservers", dns_nameservers)
        if enable_dhcp is not None:
            pulumi.set(__self__, "enable_dhcp", enable_dhcp)
        if gateway_ip is not None:
            pulumi.set(__self__, "gateway_ip", gateway_ip)
        if host_routes is not None:
            warnings.warn("""Use openstack_networking_subnet_route_v2 instead""", DeprecationWarning)
            pulumi.log.warn("""host_routes is deprecated: Use openstack_networking_subnet_route_v2 instead""")
        if host_routes is not None:
            pulumi.set(__self__, "host_routes", host_routes)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if ipv6_address_mode is not None:
            pulumi.set(__self__, "ipv6_address_mode", ipv6_address_mode)
        if ipv6_ra_mode is not None:
            pulumi.set(__self__, "ipv6_ra_mode", ipv6_ra_mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if no_gateway is not None:
            pulumi.set(__self__, "no_gateway", no_gateway)
        if prefix_length is not None:
            pulumi.set(__self__, "prefix_length", prefix_length)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if service_types is not None:
            pulumi.set(__self__, "service_types", service_types)
        if subnetpool_id is not None:
            pulumi.set(__self__, "subnetpool_id", subnetpool_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if value_specs is not None:
            pulumi.set(__self__, "value_specs", value_specs)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[str]:
        """
        The UUID of the parent network. Changing this
        creates a new subnet.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="allocationPools")
    def allocation_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubnetAllocationPoolArgs']]]]:
        """
        A block declaring the start and end range of
        the IP addresses available for use with DHCP in this subnet. Multiple
        `allocation_pool` blocks can be declared, providing the subnet with more
        than one range of IP addresses to use with DHCP. However, each IP range
        must be from the same CIDR that the subnet is part of.
        The `allocation_pool` block is documented below.
        """
        return pulumi.get(self, "allocation_pools")

    @allocation_pools.setter
    def allocation_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubnetAllocationPoolArgs']]]]):
        pulumi.set(self, "allocation_pools", value)

    @property
    @pulumi.getter(name="allocationPoolsCollection")
    def allocation_pools_collection(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubnetAllocationPoolsCollectionArgs']]]]:
        """
        A block declaring the start and end range of the IP addresses available for
        use with DHCP in this subnet.
        The `allocation_pools` block is documented below.
        """
        return pulumi.get(self, "allocation_pools_collection")

    @allocation_pools_collection.setter
    def allocation_pools_collection(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubnetAllocationPoolsCollectionArgs']]]]):
        pulumi.set(self, "allocation_pools_collection", value)

    @property
    @pulumi.getter
    def cidr(self) -> Optional[pulumi.Input[str]]:
        """
        CIDR representing IP range for this subnet, based on IP
        version. You can omit this option if you are creating a subnet from a
        subnet pool.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cidr", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable description of the subnet. Changing this
        updates the name of the existing subnet.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="dnsNameservers")
    def dns_nameservers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of DNS name server names used by hosts
        in this subnet. Changing this updates the DNS name servers for the existing
        subnet.
        """
        return pulumi.get(self, "dns_nameservers")

    @dns_nameservers.setter
    def dns_nameservers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dns_nameservers", value)

    @property
    @pulumi.getter(name="enableDhcp")
    def enable_dhcp(self) -> Optional[pulumi.Input[bool]]:
        """
        The administrative state of the network.
        Acceptable values are "true" and "false". Changing this value enables or
        disables the DHCP capabilities of the existing subnet. Defaults to true.
        """
        return pulumi.get(self, "enable_dhcp")

    @enable_dhcp.setter
    def enable_dhcp(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_dhcp", value)

    @property
    @pulumi.getter(name="gatewayIp")
    def gateway_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Default gateway used by devices in this subnet.
        Leaving this blank and not setting `no_gateway` will cause a default
        gateway of `.1` to be used. Changing this updates the gateway IP of the
        existing subnet.
        """
        return pulumi.get(self, "gateway_ip")

    @gateway_ip.setter
    def gateway_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gateway_ip", value)

    @property
    @pulumi.getter(name="hostRoutes")
    def host_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubnetHostRouteArgs']]]]:
        """
        (**Deprecated** - use `networking.SubnetRoute`
        instead) An array of routes that should be used by devices
        with IPs from this subnet (not including local subnet route). The host_route
        object structure is documented below. Changing this updates the host routes
        for the existing subnet.
        """
        return pulumi.get(self, "host_routes")

    @host_routes.setter
    def host_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubnetHostRouteArgs']]]]):
        pulumi.set(self, "host_routes", value)

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[int]]:
        """
        IP version, either 4 (default) or 6. Changing this creates a
        new subnet.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ip_version", value)

    @property
    @pulumi.getter(name="ipv6AddressMode")
    def ipv6_address_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv6 address mode. Valid values are
        `dhcpv6-stateful`, `dhcpv6-stateless`, or `slaac`.
        """
        return pulumi.get(self, "ipv6_address_mode")

    @ipv6_address_mode.setter
    def ipv6_address_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_address_mode", value)

    @property
    @pulumi.getter(name="ipv6RaMode")
    def ipv6_ra_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv6 Router Advertisement mode. Valid values
        are `dhcpv6-stateful`, `dhcpv6-stateless`, or `slaac`.
        """
        return pulumi.get(self, "ipv6_ra_mode")

    @ipv6_ra_mode.setter
    def ipv6_ra_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_ra_mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the subnet. Changing this updates the name of
        the existing subnet.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="noGateway")
    def no_gateway(self) -> Optional[pulumi.Input[bool]]:
        """
        Do not set a gateway IP on this subnet. Changing
        this removes or adds a default gateway IP of the existing subnet.
        """
        return pulumi.get(self, "no_gateway")

    @no_gateway.setter
    def no_gateway(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "no_gateway", value)

    @property
    @pulumi.getter(name="prefixLength")
    def prefix_length(self) -> Optional[pulumi.Input[int]]:
        """
        The prefix length to use when creating a subnet
        from a subnet pool. The default subnet pool prefix length that was defined
        when creating the subnet pool will be used if not provided. Changing this
        creates a new subnet.
        """
        return pulumi.get(self, "prefix_length")

    @prefix_length.setter
    def prefix_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "prefix_length", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to obtain the V2 Networking client.
        A Networking client is needed to create a Neutron subnet. If omitted, the
        `region` argument of the provider is used. Changing this creates a new
        subnet.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="serviceTypes")
    def service_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of service types used by the subnet.
        Changing this updates the service types for the existing subnet.
        """
        return pulumi.get(self, "service_types")

    @service_types.setter
    def service_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "service_types", value)

    @property
    @pulumi.getter(name="subnetpoolId")
    def subnetpool_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the subnetpool associated with the subnet.
        """
        return pulumi.get(self, "subnetpool_id")

    @subnetpool_id.setter
    def subnetpool_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnetpool_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A set of string tags for the subnet.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The owner of the subnet. Required if admin wants to
        create a subnet for another tenant. Changing this creates a new subnet.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="valueSpecs")
    def value_specs(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Map of additional options.
        """
        return pulumi.get(self, "value_specs")

    @value_specs.setter
    def value_specs(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "value_specs", value)


@pulumi.input_type
class _SubnetState:
    def __init__(__self__, *,
                 all_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allocation_pools: Optional[pulumi.Input[Sequence[pulumi.Input['SubnetAllocationPoolArgs']]]] = None,
                 allocation_pools_collection: Optional[pulumi.Input[Sequence[pulumi.Input['SubnetAllocationPoolsCollectionArgs']]]] = None,
                 cidr: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dns_nameservers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_dhcp: Optional[pulumi.Input[bool]] = None,
                 gateway_ip: Optional[pulumi.Input[str]] = None,
                 host_routes: Optional[pulumi.Input[Sequence[pulumi.Input['SubnetHostRouteArgs']]]] = None,
                 ip_version: Optional[pulumi.Input[int]] = None,
                 ipv6_address_mode: Optional[pulumi.Input[str]] = None,
                 ipv6_ra_mode: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 no_gateway: Optional[pulumi.Input[bool]] = None,
                 prefix_length: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 service_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 subnetpool_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 value_specs: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        Input properties used for looking up and filtering Subnet resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] all_tags: The collection of ags assigned on the subnet, which have been
               explicitly and implicitly added.
        :param pulumi.Input[Sequence[pulumi.Input['SubnetAllocationPoolArgs']]] allocation_pools: A block declaring the start and end range of
               the IP addresses available for use with DHCP in this subnet. Multiple
               `allocation_pool` blocks can be declared, providing the subnet with more
               than one range of IP addresses to use with DHCP. However, each IP range
               must be from the same CIDR that the subnet is part of.
               The `allocation_pool` block is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['SubnetAllocationPoolsCollectionArgs']]] allocation_pools_collection: A block declaring the start and end range of the IP addresses available for
               use with DHCP in this subnet.
               The `allocation_pools` block is documented below.
        :param pulumi.Input[str] cidr: CIDR representing IP range for this subnet, based on IP
               version. You can omit this option if you are creating a subnet from a
               subnet pool.
        :param pulumi.Input[str] description: Human-readable description of the subnet. Changing this
               updates the name of the existing subnet.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_nameservers: An array of DNS name server names used by hosts
               in this subnet. Changing this updates the DNS name servers for the existing
               subnet.
        :param pulumi.Input[bool] enable_dhcp: The administrative state of the network.
               Acceptable values are "true" and "false". Changing this value enables or
               disables the DHCP capabilities of the existing subnet. Defaults to true.
        :param pulumi.Input[str] gateway_ip: Default gateway used by devices in this subnet.
               Leaving this blank and not setting `no_gateway` will cause a default
               gateway of `.1` to be used. Changing this updates the gateway IP of the
               existing subnet.
        :param pulumi.Input[Sequence[pulumi.Input['SubnetHostRouteArgs']]] host_routes: (**Deprecated** - use `networking.SubnetRoute`
               instead) An array of routes that should be used by devices
               with IPs from this subnet (not including local subnet route). The host_route
               object structure is documented below. Changing this updates the host routes
               for the existing subnet.
        :param pulumi.Input[int] ip_version: IP version, either 4 (default) or 6. Changing this creates a
               new subnet.
        :param pulumi.Input[str] ipv6_address_mode: The IPv6 address mode. Valid values are
               `dhcpv6-stateful`, `dhcpv6-stateless`, or `slaac`.
        :param pulumi.Input[str] ipv6_ra_mode: The IPv6 Router Advertisement mode. Valid values
               are `dhcpv6-stateful`, `dhcpv6-stateless`, or `slaac`.
        :param pulumi.Input[str] name: The name of the subnet. Changing this updates the name of
               the existing subnet.
        :param pulumi.Input[str] network_id: The UUID of the parent network. Changing this
               creates a new subnet.
        :param pulumi.Input[bool] no_gateway: Do not set a gateway IP on this subnet. Changing
               this removes or adds a default gateway IP of the existing subnet.
        :param pulumi.Input[int] prefix_length: The prefix length to use when creating a subnet
               from a subnet pool. The default subnet pool prefix length that was defined
               when creating the subnet pool will be used if not provided. Changing this
               creates a new subnet.
        :param pulumi.Input[str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create a Neutron subnet. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               subnet.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] service_types: An array of service types used by the subnet.
               Changing this updates the service types for the existing subnet.
        :param pulumi.Input[str] subnetpool_id: The ID of the subnetpool associated with the subnet.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A set of string tags for the subnet.
        :param pulumi.Input[str] tenant_id: The owner of the subnet. Required if admin wants to
               create a subnet for another tenant. Changing this creates a new subnet.
        :param pulumi.Input[Mapping[str, Any]] value_specs: Map of additional options.
        """
        if all_tags is not None:
            pulumi.set(__self__, "all_tags", all_tags)
        if allocation_pools is not None:
            pulumi.set(__self__, "allocation_pools", allocation_pools)
        if allocation_pools_collection is not None:
            warnings.warn("""use allocation_pool instead""", DeprecationWarning)
            pulumi.log.warn("""allocation_pools_collection is deprecated: use allocation_pool instead""")
        if allocation_pools_collection is not None:
            pulumi.set(__self__, "allocation_pools_collection", allocation_pools_collection)
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dns_nameservers is not None:
            pulumi.set(__self__, "dns_nameservers", dns_nameservers)
        if enable_dhcp is not None:
            pulumi.set(__self__, "enable_dhcp", enable_dhcp)
        if gateway_ip is not None:
            pulumi.set(__self__, "gateway_ip", gateway_ip)
        if host_routes is not None:
            warnings.warn("""Use openstack_networking_subnet_route_v2 instead""", DeprecationWarning)
            pulumi.log.warn("""host_routes is deprecated: Use openstack_networking_subnet_route_v2 instead""")
        if host_routes is not None:
            pulumi.set(__self__, "host_routes", host_routes)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if ipv6_address_mode is not None:
            pulumi.set(__self__, "ipv6_address_mode", ipv6_address_mode)
        if ipv6_ra_mode is not None:
            pulumi.set(__self__, "ipv6_ra_mode", ipv6_ra_mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if no_gateway is not None:
            pulumi.set(__self__, "no_gateway", no_gateway)
        if prefix_length is not None:
            pulumi.set(__self__, "prefix_length", prefix_length)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if service_types is not None:
            pulumi.set(__self__, "service_types", service_types)
        if subnetpool_id is not None:
            pulumi.set(__self__, "subnetpool_id", subnetpool_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if value_specs is not None:
            pulumi.set(__self__, "value_specs", value_specs)

    @property
    @pulumi.getter(name="allTags")
    def all_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The collection of ags assigned on the subnet, which have been
        explicitly and implicitly added.
        """
        return pulumi.get(self, "all_tags")

    @all_tags.setter
    def all_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "all_tags", value)

    @property
    @pulumi.getter(name="allocationPools")
    def allocation_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubnetAllocationPoolArgs']]]]:
        """
        A block declaring the start and end range of
        the IP addresses available for use with DHCP in this subnet. Multiple
        `allocation_pool` blocks can be declared, providing the subnet with more
        than one range of IP addresses to use with DHCP. However, each IP range
        must be from the same CIDR that the subnet is part of.
        The `allocation_pool` block is documented below.
        """
        return pulumi.get(self, "allocation_pools")

    @allocation_pools.setter
    def allocation_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubnetAllocationPoolArgs']]]]):
        pulumi.set(self, "allocation_pools", value)

    @property
    @pulumi.getter(name="allocationPoolsCollection")
    def allocation_pools_collection(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubnetAllocationPoolsCollectionArgs']]]]:
        """
        A block declaring the start and end range of the IP addresses available for
        use with DHCP in this subnet.
        The `allocation_pools` block is documented below.
        """
        return pulumi.get(self, "allocation_pools_collection")

    @allocation_pools_collection.setter
    def allocation_pools_collection(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubnetAllocationPoolsCollectionArgs']]]]):
        pulumi.set(self, "allocation_pools_collection", value)

    @property
    @pulumi.getter
    def cidr(self) -> Optional[pulumi.Input[str]]:
        """
        CIDR representing IP range for this subnet, based on IP
        version. You can omit this option if you are creating a subnet from a
        subnet pool.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cidr", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable description of the subnet. Changing this
        updates the name of the existing subnet.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="dnsNameservers")
    def dns_nameservers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of DNS name server names used by hosts
        in this subnet. Changing this updates the DNS name servers for the existing
        subnet.
        """
        return pulumi.get(self, "dns_nameservers")

    @dns_nameservers.setter
    def dns_nameservers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dns_nameservers", value)

    @property
    @pulumi.getter(name="enableDhcp")
    def enable_dhcp(self) -> Optional[pulumi.Input[bool]]:
        """
        The administrative state of the network.
        Acceptable values are "true" and "false". Changing this value enables or
        disables the DHCP capabilities of the existing subnet. Defaults to true.
        """
        return pulumi.get(self, "enable_dhcp")

    @enable_dhcp.setter
    def enable_dhcp(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_dhcp", value)

    @property
    @pulumi.getter(name="gatewayIp")
    def gateway_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Default gateway used by devices in this subnet.
        Leaving this blank and not setting `no_gateway` will cause a default
        gateway of `.1` to be used. Changing this updates the gateway IP of the
        existing subnet.
        """
        return pulumi.get(self, "gateway_ip")

    @gateway_ip.setter
    def gateway_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gateway_ip", value)

    @property
    @pulumi.getter(name="hostRoutes")
    def host_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubnetHostRouteArgs']]]]:
        """
        (**Deprecated** - use `networking.SubnetRoute`
        instead) An array of routes that should be used by devices
        with IPs from this subnet (not including local subnet route). The host_route
        object structure is documented below. Changing this updates the host routes
        for the existing subnet.
        """
        return pulumi.get(self, "host_routes")

    @host_routes.setter
    def host_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubnetHostRouteArgs']]]]):
        pulumi.set(self, "host_routes", value)

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[int]]:
        """
        IP version, either 4 (default) or 6. Changing this creates a
        new subnet.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ip_version", value)

    @property
    @pulumi.getter(name="ipv6AddressMode")
    def ipv6_address_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv6 address mode. Valid values are
        `dhcpv6-stateful`, `dhcpv6-stateless`, or `slaac`.
        """
        return pulumi.get(self, "ipv6_address_mode")

    @ipv6_address_mode.setter
    def ipv6_address_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_address_mode", value)

    @property
    @pulumi.getter(name="ipv6RaMode")
    def ipv6_ra_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv6 Router Advertisement mode. Valid values
        are `dhcpv6-stateful`, `dhcpv6-stateless`, or `slaac`.
        """
        return pulumi.get(self, "ipv6_ra_mode")

    @ipv6_ra_mode.setter
    def ipv6_ra_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_ra_mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the subnet. Changing this updates the name of
        the existing subnet.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        The UUID of the parent network. Changing this
        creates a new subnet.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="noGateway")
    def no_gateway(self) -> Optional[pulumi.Input[bool]]:
        """
        Do not set a gateway IP on this subnet. Changing
        this removes or adds a default gateway IP of the existing subnet.
        """
        return pulumi.get(self, "no_gateway")

    @no_gateway.setter
    def no_gateway(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "no_gateway", value)

    @property
    @pulumi.getter(name="prefixLength")
    def prefix_length(self) -> Optional[pulumi.Input[int]]:
        """
        The prefix length to use when creating a subnet
        from a subnet pool. The default subnet pool prefix length that was defined
        when creating the subnet pool will be used if not provided. Changing this
        creates a new subnet.
        """
        return pulumi.get(self, "prefix_length")

    @prefix_length.setter
    def prefix_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "prefix_length", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to obtain the V2 Networking client.
        A Networking client is needed to create a Neutron subnet. If omitted, the
        `region` argument of the provider is used. Changing this creates a new
        subnet.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="serviceTypes")
    def service_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of service types used by the subnet.
        Changing this updates the service types for the existing subnet.
        """
        return pulumi.get(self, "service_types")

    @service_types.setter
    def service_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "service_types", value)

    @property
    @pulumi.getter(name="subnetpoolId")
    def subnetpool_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the subnetpool associated with the subnet.
        """
        return pulumi.get(self, "subnetpool_id")

    @subnetpool_id.setter
    def subnetpool_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnetpool_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A set of string tags for the subnet.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The owner of the subnet. Required if admin wants to
        create a subnet for another tenant. Changing this creates a new subnet.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="valueSpecs")
    def value_specs(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Map of additional options.
        """
        return pulumi.get(self, "value_specs")

    @value_specs.setter
    def value_specs(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "value_specs", value)


class Subnet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allocation_pools: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SubnetAllocationPoolArgs']]]]] = None,
                 allocation_pools_collection: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SubnetAllocationPoolsCollectionArgs']]]]] = None,
                 cidr: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dns_nameservers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_dhcp: Optional[pulumi.Input[bool]] = None,
                 gateway_ip: Optional[pulumi.Input[str]] = None,
                 host_routes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SubnetHostRouteArgs']]]]] = None,
                 ip_version: Optional[pulumi.Input[int]] = None,
                 ipv6_address_mode: Optional[pulumi.Input[str]] = None,
                 ipv6_ra_mode: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 no_gateway: Optional[pulumi.Input[bool]] = None,
                 prefix_length: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 service_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 subnetpool_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 value_specs: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 __props__=None):
        """
        Manages a V2 Neutron subnet resource within OpenStack.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        network1 = openstack.networking.Network("network1", admin_state_up=True)
        subnet1 = openstack.networking.Subnet("subnet1",
            cidr="192.168.199.0/24",
            network_id=network1.id)
        ```

        ## Import

        Subnets can be imported using the `id`, e.g.

        ```sh
         $ pulumi import openstack:networking/subnet:Subnet subnet_1 da4faf16-5546-41e4-8330-4d0002b74048
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SubnetAllocationPoolArgs']]]] allocation_pools: A block declaring the start and end range of
               the IP addresses available for use with DHCP in this subnet. Multiple
               `allocation_pool` blocks can be declared, providing the subnet with more
               than one range of IP addresses to use with DHCP. However, each IP range
               must be from the same CIDR that the subnet is part of.
               The `allocation_pool` block is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SubnetAllocationPoolsCollectionArgs']]]] allocation_pools_collection: A block declaring the start and end range of the IP addresses available for
               use with DHCP in this subnet.
               The `allocation_pools` block is documented below.
        :param pulumi.Input[str] cidr: CIDR representing IP range for this subnet, based on IP
               version. You can omit this option if you are creating a subnet from a
               subnet pool.
        :param pulumi.Input[str] description: Human-readable description of the subnet. Changing this
               updates the name of the existing subnet.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_nameservers: An array of DNS name server names used by hosts
               in this subnet. Changing this updates the DNS name servers for the existing
               subnet.
        :param pulumi.Input[bool] enable_dhcp: The administrative state of the network.
               Acceptable values are "true" and "false". Changing this value enables or
               disables the DHCP capabilities of the existing subnet. Defaults to true.
        :param pulumi.Input[str] gateway_ip: Default gateway used by devices in this subnet.
               Leaving this blank and not setting `no_gateway` will cause a default
               gateway of `.1` to be used. Changing this updates the gateway IP of the
               existing subnet.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SubnetHostRouteArgs']]]] host_routes: (**Deprecated** - use `networking.SubnetRoute`
               instead) An array of routes that should be used by devices
               with IPs from this subnet (not including local subnet route). The host_route
               object structure is documented below. Changing this updates the host routes
               for the existing subnet.
        :param pulumi.Input[int] ip_version: IP version, either 4 (default) or 6. Changing this creates a
               new subnet.
        :param pulumi.Input[str] ipv6_address_mode: The IPv6 address mode. Valid values are
               `dhcpv6-stateful`, `dhcpv6-stateless`, or `slaac`.
        :param pulumi.Input[str] ipv6_ra_mode: The IPv6 Router Advertisement mode. Valid values
               are `dhcpv6-stateful`, `dhcpv6-stateless`, or `slaac`.
        :param pulumi.Input[str] name: The name of the subnet. Changing this updates the name of
               the existing subnet.
        :param pulumi.Input[str] network_id: The UUID of the parent network. Changing this
               creates a new subnet.
        :param pulumi.Input[bool] no_gateway: Do not set a gateway IP on this subnet. Changing
               this removes or adds a default gateway IP of the existing subnet.
        :param pulumi.Input[int] prefix_length: The prefix length to use when creating a subnet
               from a subnet pool. The default subnet pool prefix length that was defined
               when creating the subnet pool will be used if not provided. Changing this
               creates a new subnet.
        :param pulumi.Input[str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create a Neutron subnet. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               subnet.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] service_types: An array of service types used by the subnet.
               Changing this updates the service types for the existing subnet.
        :param pulumi.Input[str] subnetpool_id: The ID of the subnetpool associated with the subnet.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A set of string tags for the subnet.
        :param pulumi.Input[str] tenant_id: The owner of the subnet. Required if admin wants to
               create a subnet for another tenant. Changing this creates a new subnet.
        :param pulumi.Input[Mapping[str, Any]] value_specs: Map of additional options.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SubnetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a V2 Neutron subnet resource within OpenStack.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        network1 = openstack.networking.Network("network1", admin_state_up=True)
        subnet1 = openstack.networking.Subnet("subnet1",
            cidr="192.168.199.0/24",
            network_id=network1.id)
        ```

        ## Import

        Subnets can be imported using the `id`, e.g.

        ```sh
         $ pulumi import openstack:networking/subnet:Subnet subnet_1 da4faf16-5546-41e4-8330-4d0002b74048
        ```

        :param str resource_name: The name of the resource.
        :param SubnetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SubnetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allocation_pools: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SubnetAllocationPoolArgs']]]]] = None,
                 allocation_pools_collection: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SubnetAllocationPoolsCollectionArgs']]]]] = None,
                 cidr: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dns_nameservers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_dhcp: Optional[pulumi.Input[bool]] = None,
                 gateway_ip: Optional[pulumi.Input[str]] = None,
                 host_routes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SubnetHostRouteArgs']]]]] = None,
                 ip_version: Optional[pulumi.Input[int]] = None,
                 ipv6_address_mode: Optional[pulumi.Input[str]] = None,
                 ipv6_ra_mode: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 no_gateway: Optional[pulumi.Input[bool]] = None,
                 prefix_length: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 service_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 subnetpool_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 value_specs: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SubnetArgs.__new__(SubnetArgs)

            __props__.__dict__["allocation_pools"] = allocation_pools
            if allocation_pools_collection is not None and not opts.urn:
                warnings.warn("""use allocation_pool instead""", DeprecationWarning)
                pulumi.log.warn("""allocation_pools_collection is deprecated: use allocation_pool instead""")
            __props__.__dict__["allocation_pools_collection"] = allocation_pools_collection
            __props__.__dict__["cidr"] = cidr
            __props__.__dict__["description"] = description
            __props__.__dict__["dns_nameservers"] = dns_nameservers
            __props__.__dict__["enable_dhcp"] = enable_dhcp
            __props__.__dict__["gateway_ip"] = gateway_ip
            if host_routes is not None and not opts.urn:
                warnings.warn("""Use openstack_networking_subnet_route_v2 instead""", DeprecationWarning)
                pulumi.log.warn("""host_routes is deprecated: Use openstack_networking_subnet_route_v2 instead""")
            __props__.__dict__["host_routes"] = host_routes
            __props__.__dict__["ip_version"] = ip_version
            __props__.__dict__["ipv6_address_mode"] = ipv6_address_mode
            __props__.__dict__["ipv6_ra_mode"] = ipv6_ra_mode
            __props__.__dict__["name"] = name
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["no_gateway"] = no_gateway
            __props__.__dict__["prefix_length"] = prefix_length
            __props__.__dict__["region"] = region
            __props__.__dict__["service_types"] = service_types
            __props__.__dict__["subnetpool_id"] = subnetpool_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["value_specs"] = value_specs
            __props__.__dict__["all_tags"] = None
        super(Subnet, __self__).__init__(
            'openstack:networking/subnet:Subnet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            all_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            allocation_pools: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SubnetAllocationPoolArgs']]]]] = None,
            allocation_pools_collection: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SubnetAllocationPoolsCollectionArgs']]]]] = None,
            cidr: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            dns_nameservers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            enable_dhcp: Optional[pulumi.Input[bool]] = None,
            gateway_ip: Optional[pulumi.Input[str]] = None,
            host_routes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SubnetHostRouteArgs']]]]] = None,
            ip_version: Optional[pulumi.Input[int]] = None,
            ipv6_address_mode: Optional[pulumi.Input[str]] = None,
            ipv6_ra_mode: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_id: Optional[pulumi.Input[str]] = None,
            no_gateway: Optional[pulumi.Input[bool]] = None,
            prefix_length: Optional[pulumi.Input[int]] = None,
            region: Optional[pulumi.Input[str]] = None,
            service_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            subnetpool_id: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            value_specs: Optional[pulumi.Input[Mapping[str, Any]]] = None) -> 'Subnet':
        """
        Get an existing Subnet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] all_tags: The collection of ags assigned on the subnet, which have been
               explicitly and implicitly added.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SubnetAllocationPoolArgs']]]] allocation_pools: A block declaring the start and end range of
               the IP addresses available for use with DHCP in this subnet. Multiple
               `allocation_pool` blocks can be declared, providing the subnet with more
               than one range of IP addresses to use with DHCP. However, each IP range
               must be from the same CIDR that the subnet is part of.
               The `allocation_pool` block is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SubnetAllocationPoolsCollectionArgs']]]] allocation_pools_collection: A block declaring the start and end range of the IP addresses available for
               use with DHCP in this subnet.
               The `allocation_pools` block is documented below.
        :param pulumi.Input[str] cidr: CIDR representing IP range for this subnet, based on IP
               version. You can omit this option if you are creating a subnet from a
               subnet pool.
        :param pulumi.Input[str] description: Human-readable description of the subnet. Changing this
               updates the name of the existing subnet.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_nameservers: An array of DNS name server names used by hosts
               in this subnet. Changing this updates the DNS name servers for the existing
               subnet.
        :param pulumi.Input[bool] enable_dhcp: The administrative state of the network.
               Acceptable values are "true" and "false". Changing this value enables or
               disables the DHCP capabilities of the existing subnet. Defaults to true.
        :param pulumi.Input[str] gateway_ip: Default gateway used by devices in this subnet.
               Leaving this blank and not setting `no_gateway` will cause a default
               gateway of `.1` to be used. Changing this updates the gateway IP of the
               existing subnet.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SubnetHostRouteArgs']]]] host_routes: (**Deprecated** - use `networking.SubnetRoute`
               instead) An array of routes that should be used by devices
               with IPs from this subnet (not including local subnet route). The host_route
               object structure is documented below. Changing this updates the host routes
               for the existing subnet.
        :param pulumi.Input[int] ip_version: IP version, either 4 (default) or 6. Changing this creates a
               new subnet.
        :param pulumi.Input[str] ipv6_address_mode: The IPv6 address mode. Valid values are
               `dhcpv6-stateful`, `dhcpv6-stateless`, or `slaac`.
        :param pulumi.Input[str] ipv6_ra_mode: The IPv6 Router Advertisement mode. Valid values
               are `dhcpv6-stateful`, `dhcpv6-stateless`, or `slaac`.
        :param pulumi.Input[str] name: The name of the subnet. Changing this updates the name of
               the existing subnet.
        :param pulumi.Input[str] network_id: The UUID of the parent network. Changing this
               creates a new subnet.
        :param pulumi.Input[bool] no_gateway: Do not set a gateway IP on this subnet. Changing
               this removes or adds a default gateway IP of the existing subnet.
        :param pulumi.Input[int] prefix_length: The prefix length to use when creating a subnet
               from a subnet pool. The default subnet pool prefix length that was defined
               when creating the subnet pool will be used if not provided. Changing this
               creates a new subnet.
        :param pulumi.Input[str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create a Neutron subnet. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               subnet.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] service_types: An array of service types used by the subnet.
               Changing this updates the service types for the existing subnet.
        :param pulumi.Input[str] subnetpool_id: The ID of the subnetpool associated with the subnet.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A set of string tags for the subnet.
        :param pulumi.Input[str] tenant_id: The owner of the subnet. Required if admin wants to
               create a subnet for another tenant. Changing this creates a new subnet.
        :param pulumi.Input[Mapping[str, Any]] value_specs: Map of additional options.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SubnetState.__new__(_SubnetState)

        __props__.__dict__["all_tags"] = all_tags
        __props__.__dict__["allocation_pools"] = allocation_pools
        __props__.__dict__["allocation_pools_collection"] = allocation_pools_collection
        __props__.__dict__["cidr"] = cidr
        __props__.__dict__["description"] = description
        __props__.__dict__["dns_nameservers"] = dns_nameservers
        __props__.__dict__["enable_dhcp"] = enable_dhcp
        __props__.__dict__["gateway_ip"] = gateway_ip
        __props__.__dict__["host_routes"] = host_routes
        __props__.__dict__["ip_version"] = ip_version
        __props__.__dict__["ipv6_address_mode"] = ipv6_address_mode
        __props__.__dict__["ipv6_ra_mode"] = ipv6_ra_mode
        __props__.__dict__["name"] = name
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["no_gateway"] = no_gateway
        __props__.__dict__["prefix_length"] = prefix_length
        __props__.__dict__["region"] = region
        __props__.__dict__["service_types"] = service_types
        __props__.__dict__["subnetpool_id"] = subnetpool_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["value_specs"] = value_specs
        return Subnet(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allTags")
    def all_tags(self) -> pulumi.Output[Sequence[str]]:
        """
        The collection of ags assigned on the subnet, which have been
        explicitly and implicitly added.
        """
        return pulumi.get(self, "all_tags")

    @property
    @pulumi.getter(name="allocationPools")
    def allocation_pools(self) -> pulumi.Output[Sequence['outputs.SubnetAllocationPool']]:
        """
        A block declaring the start and end range of
        the IP addresses available for use with DHCP in this subnet. Multiple
        `allocation_pool` blocks can be declared, providing the subnet with more
        than one range of IP addresses to use with DHCP. However, each IP range
        must be from the same CIDR that the subnet is part of.
        The `allocation_pool` block is documented below.
        """
        return pulumi.get(self, "allocation_pools")

    @property
    @pulumi.getter(name="allocationPoolsCollection")
    def allocation_pools_collection(self) -> pulumi.Output[Sequence['outputs.SubnetAllocationPoolsCollection']]:
        """
        A block declaring the start and end range of the IP addresses available for
        use with DHCP in this subnet.
        The `allocation_pools` block is documented below.
        """
        return pulumi.get(self, "allocation_pools_collection")

    @property
    @pulumi.getter
    def cidr(self) -> pulumi.Output[str]:
        """
        CIDR representing IP range for this subnet, based on IP
        version. You can omit this option if you are creating a subnet from a
        subnet pool.
        """
        return pulumi.get(self, "cidr")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Human-readable description of the subnet. Changing this
        updates the name of the existing subnet.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="dnsNameservers")
    def dns_nameservers(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        An array of DNS name server names used by hosts
        in this subnet. Changing this updates the DNS name servers for the existing
        subnet.
        """
        return pulumi.get(self, "dns_nameservers")

    @property
    @pulumi.getter(name="enableDhcp")
    def enable_dhcp(self) -> pulumi.Output[Optional[bool]]:
        """
        The administrative state of the network.
        Acceptable values are "true" and "false". Changing this value enables or
        disables the DHCP capabilities of the existing subnet. Defaults to true.
        """
        return pulumi.get(self, "enable_dhcp")

    @property
    @pulumi.getter(name="gatewayIp")
    def gateway_ip(self) -> pulumi.Output[str]:
        """
        Default gateway used by devices in this subnet.
        Leaving this blank and not setting `no_gateway` will cause a default
        gateway of `.1` to be used. Changing this updates the gateway IP of the
        existing subnet.
        """
        return pulumi.get(self, "gateway_ip")

    @property
    @pulumi.getter(name="hostRoutes")
    def host_routes(self) -> pulumi.Output[Optional[Sequence['outputs.SubnetHostRoute']]]:
        """
        (**Deprecated** - use `networking.SubnetRoute`
        instead) An array of routes that should be used by devices
        with IPs from this subnet (not including local subnet route). The host_route
        object structure is documented below. Changing this updates the host routes
        for the existing subnet.
        """
        return pulumi.get(self, "host_routes")

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> pulumi.Output[Optional[int]]:
        """
        IP version, either 4 (default) or 6. Changing this creates a
        new subnet.
        """
        return pulumi.get(self, "ip_version")

    @property
    @pulumi.getter(name="ipv6AddressMode")
    def ipv6_address_mode(self) -> pulumi.Output[str]:
        """
        The IPv6 address mode. Valid values are
        `dhcpv6-stateful`, `dhcpv6-stateless`, or `slaac`.
        """
        return pulumi.get(self, "ipv6_address_mode")

    @property
    @pulumi.getter(name="ipv6RaMode")
    def ipv6_ra_mode(self) -> pulumi.Output[str]:
        """
        The IPv6 Router Advertisement mode. Valid values
        are `dhcpv6-stateful`, `dhcpv6-stateless`, or `slaac`.
        """
        return pulumi.get(self, "ipv6_ra_mode")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the subnet. Changing this updates the name of
        the existing subnet.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[str]:
        """
        The UUID of the parent network. Changing this
        creates a new subnet.
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="noGateway")
    def no_gateway(self) -> pulumi.Output[Optional[bool]]:
        """
        Do not set a gateway IP on this subnet. Changing
        this removes or adds a default gateway IP of the existing subnet.
        """
        return pulumi.get(self, "no_gateway")

    @property
    @pulumi.getter(name="prefixLength")
    def prefix_length(self) -> pulumi.Output[Optional[int]]:
        """
        The prefix length to use when creating a subnet
        from a subnet pool. The default subnet pool prefix length that was defined
        when creating the subnet pool will be used if not provided. Changing this
        creates a new subnet.
        """
        return pulumi.get(self, "prefix_length")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to obtain the V2 Networking client.
        A Networking client is needed to create a Neutron subnet. If omitted, the
        `region` argument of the provider is used. Changing this creates a new
        subnet.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="serviceTypes")
    def service_types(self) -> pulumi.Output[Sequence[str]]:
        """
        An array of service types used by the subnet.
        Changing this updates the service types for the existing subnet.
        """
        return pulumi.get(self, "service_types")

    @property
    @pulumi.getter(name="subnetpoolId")
    def subnetpool_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the subnetpool associated with the subnet.
        """
        return pulumi.get(self, "subnetpool_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A set of string tags for the subnet.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The owner of the subnet. Required if admin wants to
        create a subnet for another tenant. Changing this creates a new subnet.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="valueSpecs")
    def value_specs(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        Map of additional options.
        """
        return pulumi.get(self, "value_specs")

