# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['NodeGroupArgs', 'NodeGroup']

@pulumi.input_type
class NodeGroupArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[str],
                 docker_volume_size: Optional[pulumi.Input[int]] = None,
                 flavor_id: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 max_node_count: Optional[pulumi.Input[int]] = None,
                 merge_labels: Optional[pulumi.Input[bool]] = None,
                 min_node_count: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_count: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a NodeGroup resource.
        :param pulumi.Input[str] cluster_id: The UUID of the V1 Container Infra cluster.
               Changing this creates a new node group.
        :param pulumi.Input[int] docker_volume_size: The size (in GB) of the Docker volume.
               Changing this creates a new node group.
        :param pulumi.Input[str] flavor_id: The flavor for the nodes of the node group. Can be set
               via the `OS_MAGNUM_FLAVOR` environment variable. Changing this creates a new
               node group.
        :param pulumi.Input[str] image_id: The reference to an image that is used for nodes of the
               node group. Can be set via the `OS_MAGNUM_IMAGE` environment variable.
               Changing this updates the image attribute of the existing node group.
        :param pulumi.Input[Mapping[str, Any]] labels: The list of key value pairs representing additional
               properties of the node group. Changing this creates a new node group.
        :param pulumi.Input[int] max_node_count: The maximum number of nodes for the node group.
               Changing this update the maximum number of nodes of the node group.
        :param pulumi.Input[bool] merge_labels: Indicates whether the provided labels should be
               merged with cluster labels. Changing this creates a new nodegroup.
        :param pulumi.Input[int] min_node_count: The minimum number of nodes for the node group.
               Changing this update the minimum number of nodes of the node group.
        :param pulumi.Input[str] name: The name of the node group. Changing this creates a new
               node group.
        :param pulumi.Input[int] node_count: The number of nodes for the node group. Changing
               this update the number of nodes of the node group.
        :param pulumi.Input[str] region: The region in which to obtain the V1 Container Infra
               client. A Container Infra client is needed to create a cluster. If omitted,
               the `region` argument of the provider is used. Changing this creates a new
               node group.
        :param pulumi.Input[str] role: The role of nodes in the node group. Changing this
               creates a new node group.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        if docker_volume_size is not None:
            pulumi.set(__self__, "docker_volume_size", docker_volume_size)
        if flavor_id is not None:
            pulumi.set(__self__, "flavor_id", flavor_id)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if max_node_count is not None:
            pulumi.set(__self__, "max_node_count", max_node_count)
        if merge_labels is not None:
            pulumi.set(__self__, "merge_labels", merge_labels)
        if min_node_count is not None:
            pulumi.set(__self__, "min_node_count", min_node_count)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[str]:
        """
        The UUID of the V1 Container Infra cluster.
        Changing this creates a new node group.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="dockerVolumeSize")
    def docker_volume_size(self) -> Optional[pulumi.Input[int]]:
        """
        The size (in GB) of the Docker volume.
        Changing this creates a new node group.
        """
        return pulumi.get(self, "docker_volume_size")

    @docker_volume_size.setter
    def docker_volume_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "docker_volume_size", value)

    @property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> Optional[pulumi.Input[str]]:
        """
        The flavor for the nodes of the node group. Can be set
        via the `OS_MAGNUM_FLAVOR` environment variable. Changing this creates a new
        node group.
        """
        return pulumi.get(self, "flavor_id")

    @flavor_id.setter
    def flavor_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "flavor_id", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[str]]:
        """
        The reference to an image that is used for nodes of the
        node group. Can be set via the `OS_MAGNUM_IMAGE` environment variable.
        Changing this updates the image attribute of the existing node group.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The list of key value pairs representing additional
        properties of the node group. Changing this creates a new node group.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of nodes for the node group.
        Changing this update the maximum number of nodes of the node group.
        """
        return pulumi.get(self, "max_node_count")

    @max_node_count.setter
    def max_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_node_count", value)

    @property
    @pulumi.getter(name="mergeLabels")
    def merge_labels(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the provided labels should be
        merged with cluster labels. Changing this creates a new nodegroup.
        """
        return pulumi.get(self, "merge_labels")

    @merge_labels.setter
    def merge_labels(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "merge_labels", value)

    @property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of nodes for the node group.
        Changing this update the minimum number of nodes of the node group.
        """
        return pulumi.get(self, "min_node_count")

    @min_node_count.setter
    def min_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_node_count", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the node group. Changing this creates a new
        node group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of nodes for the node group. Changing
        this update the number of nodes of the node group.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to obtain the V1 Container Infra
        client. A Container Infra client is needed to create a cluster. If omitted,
        the `region` argument of the provider is used. Changing this creates a new
        node group.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        The role of nodes in the node group. Changing this
        creates a new node group.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)


@pulumi.input_type
class _NodeGroupState:
    def __init__(__self__, *,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 docker_volume_size: Optional[pulumi.Input[int]] = None,
                 flavor_id: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 max_node_count: Optional[pulumi.Input[int]] = None,
                 merge_labels: Optional[pulumi.Input[bool]] = None,
                 min_node_count: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_count: Optional[pulumi.Input[int]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 updated_at: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering NodeGroup resources.
        :param pulumi.Input[str] cluster_id: The UUID of the V1 Container Infra cluster.
               Changing this creates a new node group.
        :param pulumi.Input[int] docker_volume_size: The size (in GB) of the Docker volume.
               Changing this creates a new node group.
        :param pulumi.Input[str] flavor_id: The flavor for the nodes of the node group. Can be set
               via the `OS_MAGNUM_FLAVOR` environment variable. Changing this creates a new
               node group.
        :param pulumi.Input[str] image_id: The reference to an image that is used for nodes of the
               node group. Can be set via the `OS_MAGNUM_IMAGE` environment variable.
               Changing this updates the image attribute of the existing node group.
        :param pulumi.Input[Mapping[str, Any]] labels: The list of key value pairs representing additional
               properties of the node group. Changing this creates a new node group.
        :param pulumi.Input[int] max_node_count: The maximum number of nodes for the node group.
               Changing this update the maximum number of nodes of the node group.
        :param pulumi.Input[bool] merge_labels: Indicates whether the provided labels should be
               merged with cluster labels. Changing this creates a new nodegroup.
        :param pulumi.Input[int] min_node_count: The minimum number of nodes for the node group.
               Changing this update the minimum number of nodes of the node group.
        :param pulumi.Input[str] name: The name of the node group. Changing this creates a new
               node group.
        :param pulumi.Input[int] node_count: The number of nodes for the node group. Changing
               this update the number of nodes of the node group.
        :param pulumi.Input[str] project_id: The project of the node group. Required if admin
               wants to create a cluster in another project. Changing this creates a new
               node group.
        :param pulumi.Input[str] region: The region in which to obtain the V1 Container Infra
               client. A Container Infra client is needed to create a cluster. If omitted,
               the `region` argument of the provider is used. Changing this creates a new
               node group.
        :param pulumi.Input[str] role: The role of nodes in the node group. Changing this
               creates a new node group.
        """
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if docker_volume_size is not None:
            pulumi.set(__self__, "docker_volume_size", docker_volume_size)
        if flavor_id is not None:
            pulumi.set(__self__, "flavor_id", flavor_id)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if max_node_count is not None:
            pulumi.set(__self__, "max_node_count", max_node_count)
        if merge_labels is not None:
            pulumi.set(__self__, "merge_labels", merge_labels)
        if min_node_count is not None:
            pulumi.set(__self__, "min_node_count", min_node_count)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        The UUID of the V1 Container Infra cluster.
        Changing this creates a new node group.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="dockerVolumeSize")
    def docker_volume_size(self) -> Optional[pulumi.Input[int]]:
        """
        The size (in GB) of the Docker volume.
        Changing this creates a new node group.
        """
        return pulumi.get(self, "docker_volume_size")

    @docker_volume_size.setter
    def docker_volume_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "docker_volume_size", value)

    @property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> Optional[pulumi.Input[str]]:
        """
        The flavor for the nodes of the node group. Can be set
        via the `OS_MAGNUM_FLAVOR` environment variable. Changing this creates a new
        node group.
        """
        return pulumi.get(self, "flavor_id")

    @flavor_id.setter
    def flavor_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "flavor_id", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[str]]:
        """
        The reference to an image that is used for nodes of the
        node group. Can be set via the `OS_MAGNUM_IMAGE` environment variable.
        Changing this updates the image attribute of the existing node group.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The list of key value pairs representing additional
        properties of the node group. Changing this creates a new node group.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of nodes for the node group.
        Changing this update the maximum number of nodes of the node group.
        """
        return pulumi.get(self, "max_node_count")

    @max_node_count.setter
    def max_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_node_count", value)

    @property
    @pulumi.getter(name="mergeLabels")
    def merge_labels(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the provided labels should be
        merged with cluster labels. Changing this creates a new nodegroup.
        """
        return pulumi.get(self, "merge_labels")

    @merge_labels.setter
    def merge_labels(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "merge_labels", value)

    @property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of nodes for the node group.
        Changing this update the minimum number of nodes of the node group.
        """
        return pulumi.get(self, "min_node_count")

    @min_node_count.setter
    def min_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_node_count", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the node group. Changing this creates a new
        node group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of nodes for the node group. Changing
        this update the number of nodes of the node group.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The project of the node group. Required if admin
        wants to create a cluster in another project. Changing this creates a new
        node group.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to obtain the V1 Container Infra
        client. A Container Infra client is needed to create a cluster. If omitted,
        the `region` argument of the provider is used. Changing this creates a new
        node group.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        The role of nodes in the node group. Changing this
        creates a new node group.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated_at", value)


class NodeGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 docker_volume_size: Optional[pulumi.Input[int]] = None,
                 flavor_id: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 max_node_count: Optional[pulumi.Input[int]] = None,
                 merge_labels: Optional[pulumi.Input[bool]] = None,
                 min_node_count: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_count: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a V1 Magnum node group resource within OpenStack.

        ## Example Usage
        ### Create a Nodegroup

        ```python
        import pulumi
        import pulumi_openstack as openstack

        nodegroup1 = openstack.containerinfra.NodeGroup("nodegroup1",
            cluster_id="b9a45c5c-cd03-4958-82aa-b80bf93cb922",
            node_count=5)
        ```
        ## Attributes reference

        The following attributes are exported:

        * `region` - See Argument Reference above.
        * `name` - See Argument Reference above.
        * `project_id` - See Argument Reference above.
        * `created_at` - The time at which node group was created.
        * `updated_at` - The time at which node group was created.
        * `docker_volume_size` - See Argument Reference above.
        * `role` - See Argument Reference above.
        * `image_id` - See Argument Reference above.
        * `flavor_id` - See Argument Reference above.
        * `labels` - See Argument Reference above.
        * `node_count` - See Argument Reference above.
        * `min_node_count` - See Argument Reference above.
        * `max_node_count` - See Argument Reference above.
        * `role` - See Argument Reference above.

        ## Import

        Node groups can be imported using the `id` (cluster_id/nodegroup_id), e.g.

        ```sh
         $ pulumi import openstack:containerinfra/nodeGroup:NodeGroup nodegroup_1 b9a45c5c-cd03-4958-82aa-b80bf93cb922/ce0f9463-dd25-474b-9fe8-94de63e5e42b
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_id: The UUID of the V1 Container Infra cluster.
               Changing this creates a new node group.
        :param pulumi.Input[int] docker_volume_size: The size (in GB) of the Docker volume.
               Changing this creates a new node group.
        :param pulumi.Input[str] flavor_id: The flavor for the nodes of the node group. Can be set
               via the `OS_MAGNUM_FLAVOR` environment variable. Changing this creates a new
               node group.
        :param pulumi.Input[str] image_id: The reference to an image that is used for nodes of the
               node group. Can be set via the `OS_MAGNUM_IMAGE` environment variable.
               Changing this updates the image attribute of the existing node group.
        :param pulumi.Input[Mapping[str, Any]] labels: The list of key value pairs representing additional
               properties of the node group. Changing this creates a new node group.
        :param pulumi.Input[int] max_node_count: The maximum number of nodes for the node group.
               Changing this update the maximum number of nodes of the node group.
        :param pulumi.Input[bool] merge_labels: Indicates whether the provided labels should be
               merged with cluster labels. Changing this creates a new nodegroup.
        :param pulumi.Input[int] min_node_count: The minimum number of nodes for the node group.
               Changing this update the minimum number of nodes of the node group.
        :param pulumi.Input[str] name: The name of the node group. Changing this creates a new
               node group.
        :param pulumi.Input[int] node_count: The number of nodes for the node group. Changing
               this update the number of nodes of the node group.
        :param pulumi.Input[str] region: The region in which to obtain the V1 Container Infra
               client. A Container Infra client is needed to create a cluster. If omitted,
               the `region` argument of the provider is used. Changing this creates a new
               node group.
        :param pulumi.Input[str] role: The role of nodes in the node group. Changing this
               creates a new node group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NodeGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a V1 Magnum node group resource within OpenStack.

        ## Example Usage
        ### Create a Nodegroup

        ```python
        import pulumi
        import pulumi_openstack as openstack

        nodegroup1 = openstack.containerinfra.NodeGroup("nodegroup1",
            cluster_id="b9a45c5c-cd03-4958-82aa-b80bf93cb922",
            node_count=5)
        ```
        ## Attributes reference

        The following attributes are exported:

        * `region` - See Argument Reference above.
        * `name` - See Argument Reference above.
        * `project_id` - See Argument Reference above.
        * `created_at` - The time at which node group was created.
        * `updated_at` - The time at which node group was created.
        * `docker_volume_size` - See Argument Reference above.
        * `role` - See Argument Reference above.
        * `image_id` - See Argument Reference above.
        * `flavor_id` - See Argument Reference above.
        * `labels` - See Argument Reference above.
        * `node_count` - See Argument Reference above.
        * `min_node_count` - See Argument Reference above.
        * `max_node_count` - See Argument Reference above.
        * `role` - See Argument Reference above.

        ## Import

        Node groups can be imported using the `id` (cluster_id/nodegroup_id), e.g.

        ```sh
         $ pulumi import openstack:containerinfra/nodeGroup:NodeGroup nodegroup_1 b9a45c5c-cd03-4958-82aa-b80bf93cb922/ce0f9463-dd25-474b-9fe8-94de63e5e42b
        ```

        :param str resource_name: The name of the resource.
        :param NodeGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NodeGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 docker_volume_size: Optional[pulumi.Input[int]] = None,
                 flavor_id: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 max_node_count: Optional[pulumi.Input[int]] = None,
                 merge_labels: Optional[pulumi.Input[bool]] = None,
                 min_node_count: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_count: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NodeGroupArgs.__new__(NodeGroupArgs)

            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["docker_volume_size"] = docker_volume_size
            __props__.__dict__["flavor_id"] = flavor_id
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["labels"] = labels
            __props__.__dict__["max_node_count"] = max_node_count
            __props__.__dict__["merge_labels"] = merge_labels
            __props__.__dict__["min_node_count"] = min_node_count
            __props__.__dict__["name"] = name
            __props__.__dict__["node_count"] = node_count
            __props__.__dict__["region"] = region
            __props__.__dict__["role"] = role
            __props__.__dict__["created_at"] = None
            __props__.__dict__["project_id"] = None
            __props__.__dict__["updated_at"] = None
        super(NodeGroup, __self__).__init__(
            'openstack:containerinfra/nodeGroup:NodeGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_id: Optional[pulumi.Input[str]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            docker_volume_size: Optional[pulumi.Input[int]] = None,
            flavor_id: Optional[pulumi.Input[str]] = None,
            image_id: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            max_node_count: Optional[pulumi.Input[int]] = None,
            merge_labels: Optional[pulumi.Input[bool]] = None,
            min_node_count: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            node_count: Optional[pulumi.Input[int]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            role: Optional[pulumi.Input[str]] = None,
            updated_at: Optional[pulumi.Input[str]] = None) -> 'NodeGroup':
        """
        Get an existing NodeGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_id: The UUID of the V1 Container Infra cluster.
               Changing this creates a new node group.
        :param pulumi.Input[int] docker_volume_size: The size (in GB) of the Docker volume.
               Changing this creates a new node group.
        :param pulumi.Input[str] flavor_id: The flavor for the nodes of the node group. Can be set
               via the `OS_MAGNUM_FLAVOR` environment variable. Changing this creates a new
               node group.
        :param pulumi.Input[str] image_id: The reference to an image that is used for nodes of the
               node group. Can be set via the `OS_MAGNUM_IMAGE` environment variable.
               Changing this updates the image attribute of the existing node group.
        :param pulumi.Input[Mapping[str, Any]] labels: The list of key value pairs representing additional
               properties of the node group. Changing this creates a new node group.
        :param pulumi.Input[int] max_node_count: The maximum number of nodes for the node group.
               Changing this update the maximum number of nodes of the node group.
        :param pulumi.Input[bool] merge_labels: Indicates whether the provided labels should be
               merged with cluster labels. Changing this creates a new nodegroup.
        :param pulumi.Input[int] min_node_count: The minimum number of nodes for the node group.
               Changing this update the minimum number of nodes of the node group.
        :param pulumi.Input[str] name: The name of the node group. Changing this creates a new
               node group.
        :param pulumi.Input[int] node_count: The number of nodes for the node group. Changing
               this update the number of nodes of the node group.
        :param pulumi.Input[str] project_id: The project of the node group. Required if admin
               wants to create a cluster in another project. Changing this creates a new
               node group.
        :param pulumi.Input[str] region: The region in which to obtain the V1 Container Infra
               client. A Container Infra client is needed to create a cluster. If omitted,
               the `region` argument of the provider is used. Changing this creates a new
               node group.
        :param pulumi.Input[str] role: The role of nodes in the node group. Changing this
               creates a new node group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NodeGroupState.__new__(_NodeGroupState)

        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["docker_volume_size"] = docker_volume_size
        __props__.__dict__["flavor_id"] = flavor_id
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["labels"] = labels
        __props__.__dict__["max_node_count"] = max_node_count
        __props__.__dict__["merge_labels"] = merge_labels
        __props__.__dict__["min_node_count"] = min_node_count
        __props__.__dict__["name"] = name
        __props__.__dict__["node_count"] = node_count
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        __props__.__dict__["role"] = role
        __props__.__dict__["updated_at"] = updated_at
        return NodeGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[str]:
        """
        The UUID of the V1 Container Infra cluster.
        Changing this creates a new node group.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="dockerVolumeSize")
    def docker_volume_size(self) -> pulumi.Output[int]:
        """
        The size (in GB) of the Docker volume.
        Changing this creates a new node group.
        """
        return pulumi.get(self, "docker_volume_size")

    @property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> pulumi.Output[str]:
        """
        The flavor for the nodes of the node group. Can be set
        via the `OS_MAGNUM_FLAVOR` environment variable. Changing this creates a new
        node group.
        """
        return pulumi.get(self, "flavor_id")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[str]:
        """
        The reference to an image that is used for nodes of the
        node group. Can be set via the `OS_MAGNUM_IMAGE` environment variable.
        Changing this updates the image attribute of the existing node group.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        The list of key value pairs representing additional
        properties of the node group. Changing this creates a new node group.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum number of nodes for the node group.
        Changing this update the maximum number of nodes of the node group.
        """
        return pulumi.get(self, "max_node_count")

    @property
    @pulumi.getter(name="mergeLabels")
    def merge_labels(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether the provided labels should be
        merged with cluster labels. Changing this creates a new nodegroup.
        """
        return pulumi.get(self, "merge_labels")

    @property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> pulumi.Output[int]:
        """
        The minimum number of nodes for the node group.
        Changing this update the minimum number of nodes of the node group.
        """
        return pulumi.get(self, "min_node_count")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the node group. Changing this creates a new
        node group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> pulumi.Output[Optional[int]]:
        """
        The number of nodes for the node group. Changing
        this update the number of nodes of the node group.
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The project of the node group. Required if admin
        wants to create a cluster in another project. Changing this creates a new
        node group.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to obtain the V1 Container Infra
        client. A Container Infra client is needed to create a cluster. If omitted,
        the `region` argument of the provider is used. Changing this creates a new
        node group.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def role(self) -> pulumi.Output[str]:
        """
        The role of nodes in the node group. Changing this
        creates a new node group.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[str]:
        return pulumi.get(self, "updated_at")

