import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::NetworkFirewall::Firewall`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html
 */
export interface CfnFirewallProps {
    /**
     * `AWS::NetworkFirewall::Firewall.FirewallName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-firewallname
     */
    readonly firewallName: string;
    /**
     * `AWS::NetworkFirewall::Firewall.FirewallPolicyArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-firewallpolicyarn
     */
    readonly firewallPolicyArn: string;
    /**
     * `AWS::NetworkFirewall::Firewall.SubnetMappings`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-subnetmappings
     */
    readonly subnetMappings: Array<CfnFirewall.SubnetMappingProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::NetworkFirewall::Firewall.VpcId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-vpcid
     */
    readonly vpcId: string;
    /**
     * `AWS::NetworkFirewall::Firewall.DeleteProtection`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-deleteprotection
     */
    readonly deleteProtection?: boolean | cdk.IResolvable;
    /**
     * `AWS::NetworkFirewall::Firewall.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-description
     */
    readonly description?: string;
    /**
     * `AWS::NetworkFirewall::Firewall.FirewallPolicyChangeProtection`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-firewallpolicychangeprotection
     */
    readonly firewallPolicyChangeProtection?: boolean | cdk.IResolvable;
    /**
     * `AWS::NetworkFirewall::Firewall.SubnetChangeProtection`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-subnetchangeprotection
     */
    readonly subnetChangeProtection?: boolean | cdk.IResolvable;
    /**
     * `AWS::NetworkFirewall::Firewall.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::NetworkFirewall::Firewall`.
 *
 * @external
 * @cloudformationResource AWS::NetworkFirewall::Firewall
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html
 */
export declare class CfnFirewall extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::NetworkFirewall::Firewall";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnFirewall;
    /**
     * @external
     * @cloudformationAttribute EndpointIds
     */
    readonly attrEndpointIds: string[];
    /**
     * @external
     * @cloudformationAttribute FirewallArn
     */
    readonly attrFirewallArn: string;
    /**
     * @external
     * @cloudformationAttribute FirewallId
     */
    readonly attrFirewallId: string;
    /**
     * `AWS::NetworkFirewall::Firewall.FirewallName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-firewallname
     */
    firewallName: string;
    /**
     * `AWS::NetworkFirewall::Firewall.FirewallPolicyArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-firewallpolicyarn
     */
    firewallPolicyArn: string;
    /**
     * `AWS::NetworkFirewall::Firewall.SubnetMappings`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-subnetmappings
     */
    subnetMappings: Array<CfnFirewall.SubnetMappingProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::NetworkFirewall::Firewall.VpcId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-vpcid
     */
    vpcId: string;
    /**
     * `AWS::NetworkFirewall::Firewall.DeleteProtection`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-deleteprotection
     */
    deleteProtection: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::NetworkFirewall::Firewall.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-description
     */
    description: string | undefined;
    /**
     * `AWS::NetworkFirewall::Firewall.FirewallPolicyChangeProtection`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-firewallpolicychangeprotection
     */
    firewallPolicyChangeProtection: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::NetworkFirewall::Firewall.SubnetChangeProtection`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-subnetchangeprotection
     */
    subnetChangeProtection: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::NetworkFirewall::Firewall.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::NetworkFirewall::Firewall`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnFirewallProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::NetworkFirewall::Firewall`.
 *
 * @external
 * @cloudformationResource AWS::NetworkFirewall::Firewall
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html
 */
export declare namespace CfnFirewall {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewall-subnetmapping.html
     */
    interface SubnetMappingProperty {
        /**
         * `CfnFirewall.SubnetMappingProperty.SubnetId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewall-subnetmapping.html#cfn-networkfirewall-firewall-subnetmapping-subnetid
         */
        readonly subnetId: string;
    }
}
/**
 * Properties for defining a `AWS::NetworkFirewall::FirewallPolicy`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewallpolicy.html
 */
export interface CfnFirewallPolicyProps {
    /**
     * `AWS::NetworkFirewall::FirewallPolicy.FirewallPolicy`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewallpolicy.html#cfn-networkfirewall-firewallpolicy-firewallpolicy
     */
    readonly firewallPolicy: CfnFirewallPolicy.FirewallPolicyProperty | cdk.IResolvable;
    /**
     * `AWS::NetworkFirewall::FirewallPolicy.FirewallPolicyName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewallpolicy.html#cfn-networkfirewall-firewallpolicy-firewallpolicyname
     */
    readonly firewallPolicyName: string;
    /**
     * `AWS::NetworkFirewall::FirewallPolicy.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewallpolicy.html#cfn-networkfirewall-firewallpolicy-description
     */
    readonly description?: string;
    /**
     * `AWS::NetworkFirewall::FirewallPolicy.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewallpolicy.html#cfn-networkfirewall-firewallpolicy-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::NetworkFirewall::FirewallPolicy`.
 *
 * @external
 * @cloudformationResource AWS::NetworkFirewall::FirewallPolicy
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewallpolicy.html
 */
export declare class CfnFirewallPolicy extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::NetworkFirewall::FirewallPolicy";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnFirewallPolicy;
    /**
     * @external
     * @cloudformationAttribute FirewallPolicyArn
     */
    readonly attrFirewallPolicyArn: string;
    /**
     * @external
     * @cloudformationAttribute FirewallPolicyId
     */
    readonly attrFirewallPolicyId: string;
    /**
     * `AWS::NetworkFirewall::FirewallPolicy.FirewallPolicy`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewallpolicy.html#cfn-networkfirewall-firewallpolicy-firewallpolicy
     */
    firewallPolicy: CfnFirewallPolicy.FirewallPolicyProperty | cdk.IResolvable;
    /**
     * `AWS::NetworkFirewall::FirewallPolicy.FirewallPolicyName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewallpolicy.html#cfn-networkfirewall-firewallpolicy-firewallpolicyname
     */
    firewallPolicyName: string;
    /**
     * `AWS::NetworkFirewall::FirewallPolicy.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewallpolicy.html#cfn-networkfirewall-firewallpolicy-description
     */
    description: string | undefined;
    /**
     * `AWS::NetworkFirewall::FirewallPolicy.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewallpolicy.html#cfn-networkfirewall-firewallpolicy-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::NetworkFirewall::FirewallPolicy`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnFirewallPolicyProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::NetworkFirewall::FirewallPolicy`.
 *
 * @external
 * @cloudformationResource AWS::NetworkFirewall::FirewallPolicy
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewallpolicy.html
 */
export declare namespace CfnFirewallPolicy {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-actiondefinition.html
     */
    interface ActionDefinitionProperty {
        /**
         * `CfnFirewallPolicy.ActionDefinitionProperty.PublishMetricAction`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-actiondefinition.html#cfn-networkfirewall-firewallpolicy-actiondefinition-publishmetricaction
         */
        readonly publishMetricAction?: CfnFirewallPolicy.PublishMetricActionProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::FirewallPolicy`.
 *
 * @external
 * @cloudformationResource AWS::NetworkFirewall::FirewallPolicy
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewallpolicy.html
 */
export declare namespace CfnFirewallPolicy {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-customaction.html
     */
    interface CustomActionProperty {
        /**
         * `CfnFirewallPolicy.CustomActionProperty.ActionDefinition`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-customaction.html#cfn-networkfirewall-firewallpolicy-customaction-actiondefinition
         */
        readonly actionDefinition: CfnFirewallPolicy.ActionDefinitionProperty | cdk.IResolvable;
        /**
         * `CfnFirewallPolicy.CustomActionProperty.ActionName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-customaction.html#cfn-networkfirewall-firewallpolicy-customaction-actionname
         */
        readonly actionName: string;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::FirewallPolicy`.
 *
 * @external
 * @cloudformationResource AWS::NetworkFirewall::FirewallPolicy
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewallpolicy.html
 */
export declare namespace CfnFirewallPolicy {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-dimension.html
     */
    interface DimensionProperty {
        /**
         * `CfnFirewallPolicy.DimensionProperty.Value`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-dimension.html#cfn-networkfirewall-firewallpolicy-dimension-value
         */
        readonly value: string;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::FirewallPolicy`.
 *
 * @external
 * @cloudformationResource AWS::NetworkFirewall::FirewallPolicy
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewallpolicy.html
 */
export declare namespace CfnFirewallPolicy {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-firewallpolicy.html
     */
    interface FirewallPolicyProperty {
        /**
         * `CfnFirewallPolicy.FirewallPolicyProperty.StatefulRuleGroupReferences`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-firewallpolicy.html#cfn-networkfirewall-firewallpolicy-firewallpolicy-statefulrulegroupreferences
         */
        readonly statefulRuleGroupReferences?: Array<CfnFirewallPolicy.StatefulRuleGroupReferenceProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnFirewallPolicy.FirewallPolicyProperty.StatelessCustomActions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-firewallpolicy.html#cfn-networkfirewall-firewallpolicy-firewallpolicy-statelesscustomactions
         */
        readonly statelessCustomActions?: Array<CfnFirewallPolicy.CustomActionProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnFirewallPolicy.FirewallPolicyProperty.StatelessDefaultActions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-firewallpolicy.html#cfn-networkfirewall-firewallpolicy-firewallpolicy-statelessdefaultactions
         */
        readonly statelessDefaultActions: string[];
        /**
         * `CfnFirewallPolicy.FirewallPolicyProperty.StatelessFragmentDefaultActions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-firewallpolicy.html#cfn-networkfirewall-firewallpolicy-firewallpolicy-statelessfragmentdefaultactions
         */
        readonly statelessFragmentDefaultActions: string[];
        /**
         * `CfnFirewallPolicy.FirewallPolicyProperty.StatelessRuleGroupReferences`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-firewallpolicy.html#cfn-networkfirewall-firewallpolicy-firewallpolicy-statelessrulegroupreferences
         */
        readonly statelessRuleGroupReferences?: Array<CfnFirewallPolicy.StatelessRuleGroupReferenceProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::FirewallPolicy`.
 *
 * @external
 * @cloudformationResource AWS::NetworkFirewall::FirewallPolicy
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewallpolicy.html
 */
export declare namespace CfnFirewallPolicy {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-publishmetricaction.html
     */
    interface PublishMetricActionProperty {
        /**
         * `CfnFirewallPolicy.PublishMetricActionProperty.Dimensions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-publishmetricaction.html#cfn-networkfirewall-firewallpolicy-publishmetricaction-dimensions
         */
        readonly dimensions: Array<CfnFirewallPolicy.DimensionProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::FirewallPolicy`.
 *
 * @external
 * @cloudformationResource AWS::NetworkFirewall::FirewallPolicy
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewallpolicy.html
 */
export declare namespace CfnFirewallPolicy {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-statefulrulegroupreference.html
     */
    interface StatefulRuleGroupReferenceProperty {
        /**
         * `CfnFirewallPolicy.StatefulRuleGroupReferenceProperty.ResourceArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-statefulrulegroupreference.html#cfn-networkfirewall-firewallpolicy-statefulrulegroupreference-resourcearn
         */
        readonly resourceArn: string;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::FirewallPolicy`.
 *
 * @external
 * @cloudformationResource AWS::NetworkFirewall::FirewallPolicy
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewallpolicy.html
 */
export declare namespace CfnFirewallPolicy {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-statelessrulegroupreference.html
     */
    interface StatelessRuleGroupReferenceProperty {
        /**
         * `CfnFirewallPolicy.StatelessRuleGroupReferenceProperty.Priority`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-statelessrulegroupreference.html#cfn-networkfirewall-firewallpolicy-statelessrulegroupreference-priority
         */
        readonly priority: number;
        /**
         * `CfnFirewallPolicy.StatelessRuleGroupReferenceProperty.ResourceArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-firewallpolicy-statelessrulegroupreference.html#cfn-networkfirewall-firewallpolicy-statelessrulegroupreference-resourcearn
         */
        readonly resourceArn: string;
    }
}
/**
 * Properties for defining a `AWS::NetworkFirewall::LoggingConfiguration`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-loggingconfiguration.html
 */
export interface CfnLoggingConfigurationProps {
    /**
     * `AWS::NetworkFirewall::LoggingConfiguration.FirewallArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-loggingconfiguration.html#cfn-networkfirewall-loggingconfiguration-firewallarn
     */
    readonly firewallArn: string;
    /**
     * `AWS::NetworkFirewall::LoggingConfiguration.LoggingConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-loggingconfiguration.html#cfn-networkfirewall-loggingconfiguration-loggingconfiguration
     */
    readonly loggingConfiguration: CfnLoggingConfiguration.LoggingConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::NetworkFirewall::LoggingConfiguration.FirewallName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-loggingconfiguration.html#cfn-networkfirewall-loggingconfiguration-firewallname
     */
    readonly firewallName?: string;
}
/**
 * A CloudFormation `AWS::NetworkFirewall::LoggingConfiguration`.
 *
 * @external
 * @cloudformationResource AWS::NetworkFirewall::LoggingConfiguration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-loggingconfiguration.html
 */
export declare class CfnLoggingConfiguration extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::NetworkFirewall::LoggingConfiguration";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnLoggingConfiguration;
    /**
     * `AWS::NetworkFirewall::LoggingConfiguration.FirewallArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-loggingconfiguration.html#cfn-networkfirewall-loggingconfiguration-firewallarn
     */
    firewallArn: string;
    /**
     * `AWS::NetworkFirewall::LoggingConfiguration.LoggingConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-loggingconfiguration.html#cfn-networkfirewall-loggingconfiguration-loggingconfiguration
     */
    loggingConfiguration: CfnLoggingConfiguration.LoggingConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::NetworkFirewall::LoggingConfiguration.FirewallName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-loggingconfiguration.html#cfn-networkfirewall-loggingconfiguration-firewallname
     */
    firewallName: string | undefined;
    /**
     * Create a new `AWS::NetworkFirewall::LoggingConfiguration`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnLoggingConfigurationProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::NetworkFirewall::LoggingConfiguration`.
 *
 * @external
 * @cloudformationResource AWS::NetworkFirewall::LoggingConfiguration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-loggingconfiguration.html
 */
export declare namespace CfnLoggingConfiguration {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-loggingconfiguration-logdestinationconfig.html
     */
    interface LogDestinationConfigProperty {
        /**
         * `CfnLoggingConfiguration.LogDestinationConfigProperty.LogDestination`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-loggingconfiguration-logdestinationconfig.html#cfn-networkfirewall-loggingconfiguration-logdestinationconfig-logdestination
         */
        readonly logDestination: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnLoggingConfiguration.LogDestinationConfigProperty.LogDestinationType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-loggingconfiguration-logdestinationconfig.html#cfn-networkfirewall-loggingconfiguration-logdestinationconfig-logdestinationtype
         */
        readonly logDestinationType: string;
        /**
         * `CfnLoggingConfiguration.LogDestinationConfigProperty.LogType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-loggingconfiguration-logdestinationconfig.html#cfn-networkfirewall-loggingconfiguration-logdestinationconfig-logtype
         */
        readonly logType: string;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::LoggingConfiguration`.
 *
 * @external
 * @cloudformationResource AWS::NetworkFirewall::LoggingConfiguration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-loggingconfiguration.html
 */
export declare namespace CfnLoggingConfiguration {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-loggingconfiguration-loggingconfiguration.html
     */
    interface LoggingConfigurationProperty {
        /**
         * `CfnLoggingConfiguration.LoggingConfigurationProperty.LogDestinationConfigs`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-loggingconfiguration-loggingconfiguration.html#cfn-networkfirewall-loggingconfiguration-loggingconfiguration-logdestinationconfigs
         */
        readonly logDestinationConfigs: Array<CfnLoggingConfiguration.LogDestinationConfigProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::NetworkFirewall::RuleGroup`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 */
export interface CfnRuleGroupProps {
    /**
     * `AWS::NetworkFirewall::RuleGroup.Capacity`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-capacity
     */
    readonly capacity: number;
    /**
     * `AWS::NetworkFirewall::RuleGroup.RuleGroupName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-rulegroupname
     */
    readonly ruleGroupName: string;
    /**
     * `AWS::NetworkFirewall::RuleGroup.Type`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-type
     */
    readonly type: string;
    /**
     * `AWS::NetworkFirewall::RuleGroup.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-description
     */
    readonly description?: string;
    /**
     * `AWS::NetworkFirewall::RuleGroup.RuleGroup`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-rulegroup
     */
    readonly ruleGroup?: CfnRuleGroup.RuleGroupProperty | cdk.IResolvable;
    /**
     * `AWS::NetworkFirewall::RuleGroup.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 */
export declare class CfnRuleGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::NetworkFirewall::RuleGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnRuleGroup;
    /**
     * @external
     * @cloudformationAttribute RuleGroupArn
     */
    readonly attrRuleGroupArn: string;
    /**
     * @external
     * @cloudformationAttribute RuleGroupId
     */
    readonly attrRuleGroupId: string;
    /**
     * `AWS::NetworkFirewall::RuleGroup.Capacity`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-capacity
     */
    capacity: number;
    /**
     * `AWS::NetworkFirewall::RuleGroup.RuleGroupName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-rulegroupname
     */
    ruleGroupName: string;
    /**
     * `AWS::NetworkFirewall::RuleGroup.Type`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-type
     */
    type: string;
    /**
     * `AWS::NetworkFirewall::RuleGroup.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-description
     */
    description: string | undefined;
    /**
     * `AWS::NetworkFirewall::RuleGroup.RuleGroup`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-rulegroup
     */
    ruleGroup: CfnRuleGroup.RuleGroupProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::NetworkFirewall::RuleGroup.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::NetworkFirewall::RuleGroup`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnRuleGroupProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 */
export declare namespace CfnRuleGroup {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-actiondefinition.html
     */
    interface ActionDefinitionProperty {
        /**
         * `CfnRuleGroup.ActionDefinitionProperty.PublishMetricAction`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-actiondefinition.html#cfn-networkfirewall-rulegroup-actiondefinition-publishmetricaction
         */
        readonly publishMetricAction?: CfnRuleGroup.PublishMetricActionProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 */
export declare namespace CfnRuleGroup {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-address.html
     */
    interface AddressProperty {
        /**
         * `CfnRuleGroup.AddressProperty.AddressDefinition`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-address.html#cfn-networkfirewall-rulegroup-address-addressdefinition
         */
        readonly addressDefinition: string;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 */
export declare namespace CfnRuleGroup {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-customaction.html
     */
    interface CustomActionProperty {
        /**
         * `CfnRuleGroup.CustomActionProperty.ActionDefinition`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-customaction.html#cfn-networkfirewall-rulegroup-customaction-actiondefinition
         */
        readonly actionDefinition: CfnRuleGroup.ActionDefinitionProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.CustomActionProperty.ActionName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-customaction.html#cfn-networkfirewall-rulegroup-customaction-actionname
         */
        readonly actionName: string;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 */
export declare namespace CfnRuleGroup {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-dimension.html
     */
    interface DimensionProperty {
        /**
         * `CfnRuleGroup.DimensionProperty.Value`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-dimension.html#cfn-networkfirewall-rulegroup-dimension-value
         */
        readonly value: string;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 */
export declare namespace CfnRuleGroup {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-header.html
     */
    interface HeaderProperty {
        /**
         * `CfnRuleGroup.HeaderProperty.Destination`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-header.html#cfn-networkfirewall-rulegroup-header-destination
         */
        readonly destination: string;
        /**
         * `CfnRuleGroup.HeaderProperty.DestinationPort`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-header.html#cfn-networkfirewall-rulegroup-header-destinationport
         */
        readonly destinationPort: string;
        /**
         * `CfnRuleGroup.HeaderProperty.Direction`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-header.html#cfn-networkfirewall-rulegroup-header-direction
         */
        readonly direction: string;
        /**
         * `CfnRuleGroup.HeaderProperty.Protocol`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-header.html#cfn-networkfirewall-rulegroup-header-protocol
         */
        readonly protocol: string;
        /**
         * `CfnRuleGroup.HeaderProperty.Source`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-header.html#cfn-networkfirewall-rulegroup-header-source
         */
        readonly source: string;
        /**
         * `CfnRuleGroup.HeaderProperty.SourcePort`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-header.html#cfn-networkfirewall-rulegroup-header-sourceport
         */
        readonly sourcePort: string;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 */
export declare namespace CfnRuleGroup {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-ipset.html
     */
    interface IPSetProperty {
        /**
         * `CfnRuleGroup.IPSetProperty.Definition`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-ipset.html#cfn-networkfirewall-rulegroup-ipset-definition
         */
        readonly definition?: string[];
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 */
export declare namespace CfnRuleGroup {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-matchattributes.html
     */
    interface MatchAttributesProperty {
        /**
         * `CfnRuleGroup.MatchAttributesProperty.DestinationPorts`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-matchattributes.html#cfn-networkfirewall-rulegroup-matchattributes-destinationports
         */
        readonly destinationPorts?: Array<CfnRuleGroup.PortRangeProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnRuleGroup.MatchAttributesProperty.Destinations`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-matchattributes.html#cfn-networkfirewall-rulegroup-matchattributes-destinations
         */
        readonly destinations?: Array<CfnRuleGroup.AddressProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnRuleGroup.MatchAttributesProperty.Protocols`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-matchattributes.html#cfn-networkfirewall-rulegroup-matchattributes-protocols
         */
        readonly protocols?: number[] | cdk.IResolvable;
        /**
         * `CfnRuleGroup.MatchAttributesProperty.SourcePorts`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-matchattributes.html#cfn-networkfirewall-rulegroup-matchattributes-sourceports
         */
        readonly sourcePorts?: Array<CfnRuleGroup.PortRangeProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnRuleGroup.MatchAttributesProperty.Sources`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-matchattributes.html#cfn-networkfirewall-rulegroup-matchattributes-sources
         */
        readonly sources?: Array<CfnRuleGroup.AddressProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnRuleGroup.MatchAttributesProperty.TCPFlags`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-matchattributes.html#cfn-networkfirewall-rulegroup-matchattributes-tcpflags
         */
        readonly tcpFlags?: Array<CfnRuleGroup.TCPFlagFieldProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 */
export declare namespace CfnRuleGroup {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-portrange.html
     */
    interface PortRangeProperty {
        /**
         * `CfnRuleGroup.PortRangeProperty.FromPort`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-portrange.html#cfn-networkfirewall-rulegroup-portrange-fromport
         */
        readonly fromPort: number;
        /**
         * `CfnRuleGroup.PortRangeProperty.ToPort`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-portrange.html#cfn-networkfirewall-rulegroup-portrange-toport
         */
        readonly toPort: number;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 */
export declare namespace CfnRuleGroup {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-portset.html
     */
    interface PortSetProperty {
        /**
         * `CfnRuleGroup.PortSetProperty.Definition`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-portset.html#cfn-networkfirewall-rulegroup-portset-definition
         */
        readonly definition?: string[];
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 */
export declare namespace CfnRuleGroup {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-publishmetricaction.html
     */
    interface PublishMetricActionProperty {
        /**
         * `CfnRuleGroup.PublishMetricActionProperty.Dimensions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-publishmetricaction.html#cfn-networkfirewall-rulegroup-publishmetricaction-dimensions
         */
        readonly dimensions: Array<CfnRuleGroup.DimensionProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 */
export declare namespace CfnRuleGroup {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-ruledefinition.html
     */
    interface RuleDefinitionProperty {
        /**
         * `CfnRuleGroup.RuleDefinitionProperty.Actions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-ruledefinition.html#cfn-networkfirewall-rulegroup-ruledefinition-actions
         */
        readonly actions: string[];
        /**
         * `CfnRuleGroup.RuleDefinitionProperty.MatchAttributes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-ruledefinition.html#cfn-networkfirewall-rulegroup-ruledefinition-matchattributes
         */
        readonly matchAttributes: CfnRuleGroup.MatchAttributesProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 */
export declare namespace CfnRuleGroup {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulegroup.html
     */
    interface RuleGroupProperty {
        /**
         * `CfnRuleGroup.RuleGroupProperty.RuleVariables`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulegroup.html#cfn-networkfirewall-rulegroup-rulegroup-rulevariables
         */
        readonly ruleVariables?: CfnRuleGroup.RuleVariablesProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.RuleGroupProperty.RulesSource`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulegroup.html#cfn-networkfirewall-rulegroup-rulegroup-rulessource
         */
        readonly rulesSource: CfnRuleGroup.RulesSourceProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 */
export declare namespace CfnRuleGroup {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-ruleoption.html
     */
    interface RuleOptionProperty {
        /**
         * `CfnRuleGroup.RuleOptionProperty.Keyword`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-ruleoption.html#cfn-networkfirewall-rulegroup-ruleoption-keyword
         */
        readonly keyword: string;
        /**
         * `CfnRuleGroup.RuleOptionProperty.Settings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-ruleoption.html#cfn-networkfirewall-rulegroup-ruleoption-settings
         */
        readonly settings?: string[];
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 */
export declare namespace CfnRuleGroup {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulevariables.html
     */
    interface RuleVariablesProperty {
        /**
         * `CfnRuleGroup.RuleVariablesProperty.IPSets`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulevariables.html#cfn-networkfirewall-rulegroup-rulevariables-ipsets
         */
        readonly ipSets?: {
            [key: string]: (CfnRuleGroup.IPSetProperty | cdk.IResolvable);
        } | cdk.IResolvable;
        /**
         * `CfnRuleGroup.RuleVariablesProperty.PortSets`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulevariables.html#cfn-networkfirewall-rulegroup-rulevariables-portsets
         */
        readonly portSets?: {
            [key: string]: (CfnRuleGroup.PortSetProperty | cdk.IResolvable);
        } | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 */
export declare namespace CfnRuleGroup {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulessource.html
     */
    interface RulesSourceProperty {
        /**
         * `CfnRuleGroup.RulesSourceProperty.RulesSourceList`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulessource.html#cfn-networkfirewall-rulegroup-rulessource-rulessourcelist
         */
        readonly rulesSourceList?: CfnRuleGroup.RulesSourceListProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.RulesSourceProperty.RulesString`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulessource.html#cfn-networkfirewall-rulegroup-rulessource-rulesstring
         */
        readonly rulesString?: string;
        /**
         * `CfnRuleGroup.RulesSourceProperty.StatefulRules`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulessource.html#cfn-networkfirewall-rulegroup-rulessource-statefulrules
         */
        readonly statefulRules?: Array<CfnRuleGroup.StatefulRuleProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnRuleGroup.RulesSourceProperty.StatelessRulesAndCustomActions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulessource.html#cfn-networkfirewall-rulegroup-rulessource-statelessrulesandcustomactions
         */
        readonly statelessRulesAndCustomActions?: CfnRuleGroup.StatelessRulesAndCustomActionsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 */
export declare namespace CfnRuleGroup {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulessourcelist.html
     */
    interface RulesSourceListProperty {
        /**
         * `CfnRuleGroup.RulesSourceListProperty.GeneratedRulesType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulessourcelist.html#cfn-networkfirewall-rulegroup-rulessourcelist-generatedrulestype
         */
        readonly generatedRulesType: string;
        /**
         * `CfnRuleGroup.RulesSourceListProperty.TargetTypes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulessourcelist.html#cfn-networkfirewall-rulegroup-rulessourcelist-targettypes
         */
        readonly targetTypes: string[];
        /**
         * `CfnRuleGroup.RulesSourceListProperty.Targets`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-rulessourcelist.html#cfn-networkfirewall-rulegroup-rulessourcelist-targets
         */
        readonly targets: string[];
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 */
export declare namespace CfnRuleGroup {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-statefulrule.html
     */
    interface StatefulRuleProperty {
        /**
         * `CfnRuleGroup.StatefulRuleProperty.Action`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-statefulrule.html#cfn-networkfirewall-rulegroup-statefulrule-action
         */
        readonly action: string;
        /**
         * `CfnRuleGroup.StatefulRuleProperty.Header`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-statefulrule.html#cfn-networkfirewall-rulegroup-statefulrule-header
         */
        readonly header: CfnRuleGroup.HeaderProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.StatefulRuleProperty.RuleOptions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-statefulrule.html#cfn-networkfirewall-rulegroup-statefulrule-ruleoptions
         */
        readonly ruleOptions: Array<CfnRuleGroup.RuleOptionProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 */
export declare namespace CfnRuleGroup {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-statelessrule.html
     */
    interface StatelessRuleProperty {
        /**
         * `CfnRuleGroup.StatelessRuleProperty.Priority`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-statelessrule.html#cfn-networkfirewall-rulegroup-statelessrule-priority
         */
        readonly priority: number;
        /**
         * `CfnRuleGroup.StatelessRuleProperty.RuleDefinition`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-statelessrule.html#cfn-networkfirewall-rulegroup-statelessrule-ruledefinition
         */
        readonly ruleDefinition: CfnRuleGroup.RuleDefinitionProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 */
export declare namespace CfnRuleGroup {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-statelessrulesandcustomactions.html
     */
    interface StatelessRulesAndCustomActionsProperty {
        /**
         * `CfnRuleGroup.StatelessRulesAndCustomActionsProperty.CustomActions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-statelessrulesandcustomactions.html#cfn-networkfirewall-rulegroup-statelessrulesandcustomactions-customactions
         */
        readonly customActions?: Array<CfnRuleGroup.CustomActionProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnRuleGroup.StatelessRulesAndCustomActionsProperty.StatelessRules`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-statelessrulesandcustomactions.html#cfn-networkfirewall-rulegroup-statelessrulesandcustomactions-statelessrules
         */
        readonly statelessRules: Array<CfnRuleGroup.StatelessRuleProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::NetworkFirewall::RuleGroup`.
 *
 * @external
 * @cloudformationResource AWS::NetworkFirewall::RuleGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html
 */
export declare namespace CfnRuleGroup {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-tcpflagfield.html
     */
    interface TCPFlagFieldProperty {
        /**
         * `CfnRuleGroup.TCPFlagFieldProperty.Flags`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-tcpflagfield.html#cfn-networkfirewall-rulegroup-tcpflagfield-flags
         */
        readonly flags: string[];
        /**
         * `CfnRuleGroup.TCPFlagFieldProperty.Masks`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkfirewall-rulegroup-tcpflagfield.html#cfn-networkfirewall-rulegroup-tcpflagfield-masks
         */
        readonly masks?: string[];
    }
}
