# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class ModifyActiveDirectoryRequest(JDCloudRequest):
    """
    修改SQL Server对接的Active Directory 服务。支持SQL Server 2012 及2012以上以上的版本。<br>注意：修改目录服务后，需重启SQL Server实例才能生效
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(ModifyActiveDirectoryRequest, self).__init__(
            '/regions/{regionId}/instances/{instanceId}:modifyActiveDirectory', 'POST', header, version)
        self.parameters = parameters


class ModifyActiveDirectoryParameters(object):

    def __init__(self, regionId, instanceId, adResourceId, forceRestart):
        """
        :param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md)
        :param instanceId: RDS 实例ID，唯一标识一个RDS实例
        :param adResourceId: 目录服务的资源ID<br>- 加入目录服务：要加入的目录服务的资源ID<br>- 修改目录服务：新目录服务的资源ID<br>- 移除目录服务：传入字符串“none”，不区分大小写
        :param forceRestart: 修改后，是否强制重启实例，使修改生效。<br> - true 修改后立即重启<br>- false：默认值，修改后不重启，需用户自行重启
        """

        self.regionId = regionId
        self.instanceId = instanceId
        self.adResourceId = adResourceId
        self.forceRestart = forceRestart

