# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class DescribeDeviceRaidsRequest(JDCloudRequest):
    """
    查询某种实例类型的分布式云物理服务器支持的RAID类型，可查询系统盘RAID类型和数据盘RAID类型
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(DescribeDeviceRaidsRequest, self).__init__(
            '/regions/{regionId}/raids', 'GET', header, version)
        self.parameters = parameters


class DescribeDeviceRaidsParameters(object):

    def __init__(self, regionId, deviceType, ):
        """
        :param regionId: 地域ID，可调用接口（describeEdCPSRegions）获取分布式云物理服务器支持的地域
        :param deviceType: 实例类型，可调用（describeDeviceTypes）接口获取指定地域的实例类型，例如：edcps.c.normal1
        """

        self.regionId = regionId
        self.deviceType = deviceType
        self.volumeType = None

    def setVolumeType(self, volumeType):
        """
        :param volumeType: (Optional) 磁盘类型，取值范围：system、data
        """
        self.volumeType = volumeType

