# Generated by Django 2.2.2 on 2019-11-08 09:13

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='App',
            fields=[
                ('name', models.CharField(max_length=256, primary_key=True, serialize=False, unique=True)),
                ('description', models.CharField(blank=True, default='', max_length=1024, null=True)),
                ('auth', models.CharField(choices=[('NONE', 'No Authentication'), ('BASIC', 'Basic Authentication'), ('SESSION', 'Session Authentication'), ('TOKEN', 'Token Authentication'), ('SOCIAL', 'Social Authentication')], default='NONE', max_length=64)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('api', models.BooleanField(default=True)),
                ('active', models.BooleanField(default=False)),
                ('dirty', models.BooleanField(default=False)),
                ('version', models.IntegerField(default=0)),
                ('auditlog', models.BooleanField(default=False)),
                ('graphql', models.BooleanField(default=False)),
            ],
        ),
        migrations.CreateModel(
            name='Config',
            fields=[
                ('key', models.CharField(max_length=256, primary_key=True, serialize=False, unique=True)),
                ('value', models.CharField(blank=True, max_length=1024, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='DbSettings',
            fields=[
                ('key', models.CharField(default='default', max_length=256, primary_key=True, serialize=False, unique=True)),
                ('type', models.CharField(choices=[('SQLITE', 'SQLite'), ('POSTGRES', 'Postgres'), ('MySQL', 'MySQL'), ('MARIADB', 'Maria'), ('ORACLE', 'Oracle'), ('OTHER', 'Other')], max_length=256)),
                ('name', models.CharField(max_length=256)),
                ('user', models.CharField(max_length=256, null=True)),
                ('password', models.CharField(max_length=256, null=True)),
                ('host', models.CharField(max_length=256, null=True)),
                ('port', models.CharField(max_length=256, null=True)),
                ('atomic', models.BooleanField(default=False)),
                ('commit', models.BooleanField(default=True)),
                ('active', models.BooleanField(default=False)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='Table',
            fields=[
                ('key', models.CharField(max_length=1024, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=256)),
                ('api', models.BooleanField(default=True)),
                ('owneraccess', models.BooleanField(default=False)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('pagination', models.BooleanField(default=False)),
                ('app', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ezybaas.App')),
            ],
        ),
        migrations.CreateModel(
            name='MetaModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('table', models.CharField(max_length=256)),
                ('name', models.CharField(max_length=256)),
                ('type', models.CharField(choices=[('AutoField', 'AutoField'), ('BigAutoField', 'BigAutoField'), ('BigIntegerField', 'BigIntegerField'), ('BinaryField', 'BinaryField'), ('BooleanField', 'BooleanField'), ('CharField', 'CharField'), ('DateField', 'DateField'), ('DateTimeField', 'DateTimeField'), ('DecimalField', 'DecimalField'), ('DurationField', 'DurationField'), ('EmailField', 'EmailField'), ('ForeignKey', 'ForeignKey'), ('FileField', 'FileField'), ('FilePathField', 'FilePathField'), ('FloatField', 'FloatField'), ('GenericIPAddressField', 'GenericIPAddressField'), ('ImageField', 'ImageField'), ('IntegerField', 'IntegerField'), ('ManyToManyField', 'ManyToManyField'), ('nullBooleanField', 'nullBooleanField'), ('OneToOneField', 'OneToOneField'), ('PositiveIntegerField', 'PositiveIntegerField'), ('PositiveSmallIntegerField', 'PositiveSmallIntegerField'), ('SlugField', 'SlugField'), ('SmallIntegerField', 'SmallIntegerField'), ('TextField', 'TextField'), ('TimeField', 'TimeField'), ('URLField', 'URLField'), ('UUIDField', 'UUIDField')], default='CharField', max_length=64)),
                ('null', models.BooleanField(blank=True, default=True, null=True)),
                ('blank', models.BooleanField(blank=True, default=True, null=True)),
                ('default', models.CharField(blank=True, default=None, max_length=256, null=True)),
                ('min', models.IntegerField(blank=True, default=-1, null=True)),
                ('max', models.IntegerField(blank=True, default=256, null=True)),
                ('unique', models.BooleanField(blank=True, default=False, null=True)),
                ('primarykey', models.BooleanField(blank=True, default=False, null=True)),
                ('foreignkeytable', models.CharField(blank=True, default=None, max_length=256, null=True)),
                ('ondelete', models.CharField(blank=True, choices=[ ('CASCADE', 'CASCADE'), ('PROTECT', 'PROTECT'), ('SET_NULL', 'SET_NULL'), ('SET_DEFAULT', 'SET_DEFAULT')], default='No Foreign Key', max_length=100)),
                ('inapi', models.BooleanField(blank=True, default=True, null=True)),
                ('version', models.IntegerField(blank=True, default=0, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('app', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ezybaas.App')),
                ('tablekey', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ezybaas.Table')),
            ],
        ),
    ]
