# coding: utf-8

"""
    printnanny-api-client

    Official API client library for printnanny.ai  # noqa: E501

    The version of the OpenAPI document: 0.124.3
    Contact: leigh@printnanny.ai
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from printnanny_api_client.api_client import ApiClient
from printnanny_api_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class CrashReportsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def crash_reports_create(self, **kwargs):  # noqa: E501
        """crash_reports_create  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.crash_reports_create(async_req=True)
        >>> result = thread.get()

        :param description:
        :type description: str
        :param email:
        :type email: str
        :param os_version:
        :type os_version: str
        :param os_logs:
        :type os_logs: file
        :param browser_version:
        :type browser_version: str
        :param browser_logs:
        :type browser_logs: file
        :param serial:
        :type serial: str
        :param posthog_session:
        :type posthog_session: str
        :param status:
        :type status: CrashReportStatusEnum
        :param support_comment:
        :type support_comment: str
        :param pi:
        :type pi: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CrashReport
        """
        kwargs['_return_http_data_only'] = True
        return self.crash_reports_create_with_http_info(**kwargs)  # noqa: E501

    def crash_reports_create_with_http_info(self, **kwargs):  # noqa: E501
        """crash_reports_create  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.crash_reports_create_with_http_info(async_req=True)
        >>> result = thread.get()

        :param description:
        :type description: str
        :param email:
        :type email: str
        :param os_version:
        :type os_version: str
        :param os_logs:
        :type os_logs: file
        :param browser_version:
        :type browser_version: str
        :param browser_logs:
        :type browser_logs: file
        :param serial:
        :type serial: str
        :param posthog_session:
        :type posthog_session: str
        :param status:
        :type status: CrashReportStatusEnum
        :param support_comment:
        :type support_comment: str
        :param pi:
        :type pi: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CrashReport, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'description',
            'email',
            'os_version',
            'os_logs',
            'browser_version',
            'browser_logs',
            'serial',
            'posthog_session',
            'status',
            'support_comment',
            'pi'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method crash_reports_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and ('email' in local_var_params and  # noqa: E501
                                                        len(local_var_params['email']) > 254):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `email` when calling `crash_reports_create`, length must be less than or equal to `254`")  # noqa: E501
        if self.api_client.client_side_validation and ('os_version' in local_var_params and  # noqa: E501
                                                        len(local_var_params['os_version']) > 255):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `os_version` when calling `crash_reports_create`, length must be less than or equal to `255`")  # noqa: E501
        if self.api_client.client_side_validation and ('browser_version' in local_var_params and  # noqa: E501
                                                        len(local_var_params['browser_version']) > 255):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `browser_version` when calling `crash_reports_create`, length must be less than or equal to `255`")  # noqa: E501
        if self.api_client.client_side_validation and ('serial' in local_var_params and  # noqa: E501
                                                        len(local_var_params['serial']) > 255):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `serial` when calling `crash_reports_create`, length must be less than or equal to `255`")  # noqa: E501
        if self.api_client.client_side_validation and ('posthog_session' in local_var_params and  # noqa: E501
                                                        len(local_var_params['posthog_session']) > 255):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `posthog_session` when calling `crash_reports_create`, length must be less than or equal to `255`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}
        if 'description' in local_var_params:
            form_params.append(('description', local_var_params['description']))  # noqa: E501
        if 'email' in local_var_params:
            form_params.append(('email', local_var_params['email']))  # noqa: E501
        if 'os_version' in local_var_params:
            form_params.append(('os_version', local_var_params['os_version']))  # noqa: E501
        if 'os_logs' in local_var_params:
            local_var_files['os_logs'] = local_var_params['os_logs']  # noqa: E501
        if 'browser_version' in local_var_params:
            form_params.append(('browser_version', local_var_params['browser_version']))  # noqa: E501
        if 'browser_logs' in local_var_params:
            local_var_files['browser_logs'] = local_var_params['browser_logs']  # noqa: E501
        if 'serial' in local_var_params:
            form_params.append(('serial', local_var_params['serial']))  # noqa: E501
        if 'posthog_session' in local_var_params:
            form_params.append(('posthog_session', local_var_params['posthog_session']))  # noqa: E501
        if 'status' in local_var_params:
            form_params.append(('status', local_var_params['status']))  # noqa: E501
        if 'support_comment' in local_var_params:
            form_params.append(('support_comment', local_var_params['support_comment']))  # noqa: E501
        if 'pi' in local_var_params:
            form_params.append(('pi', local_var_params['pi']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['multipart/form-data'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['cookieAuth', 'tokenAuth']  # noqa: E501

        response_types_map = {
            201: "CrashReport",
            409: "ErrorDetail",
            400: "ErrorDetail",
            401: "ErrorDetail",
            403: "ErrorDetail",
            500: "ErrorDetail",
        }

        return self.api_client.call_api(
            '/api/crash-reports/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def crash_reports_list(self, **kwargs):  # noqa: E501
        """crash_reports_list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.crash_reports_list(async_req=True)
        >>> result = thread.get()

        :param page: A page number within the paginated result set.
        :type page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PaginatedCrashReportList
        """
        kwargs['_return_http_data_only'] = True
        return self.crash_reports_list_with_http_info(**kwargs)  # noqa: E501

    def crash_reports_list_with_http_info(self, **kwargs):  # noqa: E501
        """crash_reports_list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.crash_reports_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param page: A page number within the paginated result set.
        :type page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PaginatedCrashReportList, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'page'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method crash_reports_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['cookieAuth', 'tokenAuth']  # noqa: E501

        response_types_map = {
            200: "PaginatedCrashReportList",
            400: "ErrorDetail",
            401: "ErrorDetail",
            403: "ErrorDetail",
            500: "ErrorDetail",
        }

        return self.api_client.call_api(
            '/api/crash-reports/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def crash_reports_partial_update(self, id, **kwargs):  # noqa: E501
        """crash_reports_partial_update  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.crash_reports_partial_update(id, async_req=True)
        >>> result = thread.get()

        :param id: A UUID string identifying this crash report. (required)
        :type id: str
        :param description:
        :type description: str
        :param email:
        :type email: str
        :param os_version:
        :type os_version: str
        :param os_logs:
        :type os_logs: file
        :param browser_version:
        :type browser_version: str
        :param browser_logs:
        :type browser_logs: file
        :param serial:
        :type serial: str
        :param posthog_session:
        :type posthog_session: str
        :param status:
        :type status: CrashReportStatusEnum
        :param support_comment:
        :type support_comment: str
        :param pi:
        :type pi: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CrashReport
        """
        kwargs['_return_http_data_only'] = True
        return self.crash_reports_partial_update_with_http_info(id, **kwargs)  # noqa: E501

    def crash_reports_partial_update_with_http_info(self, id, **kwargs):  # noqa: E501
        """crash_reports_partial_update  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.crash_reports_partial_update_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A UUID string identifying this crash report. (required)
        :type id: str
        :param description:
        :type description: str
        :param email:
        :type email: str
        :param os_version:
        :type os_version: str
        :param os_logs:
        :type os_logs: file
        :param browser_version:
        :type browser_version: str
        :param browser_logs:
        :type browser_logs: file
        :param serial:
        :type serial: str
        :param posthog_session:
        :type posthog_session: str
        :param status:
        :type status: CrashReportStatusEnum
        :param support_comment:
        :type support_comment: str
        :param pi:
        :type pi: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CrashReport, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id',
            'description',
            'email',
            'os_version',
            'os_logs',
            'browser_version',
            'browser_logs',
            'serial',
            'posthog_session',
            'status',
            'support_comment',
            'pi'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method crash_reports_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `crash_reports_partial_update`")  # noqa: E501

        if self.api_client.client_side_validation and ('email' in local_var_params and  # noqa: E501
                                                        len(local_var_params['email']) > 254):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `email` when calling `crash_reports_partial_update`, length must be less than or equal to `254`")  # noqa: E501
        if self.api_client.client_side_validation and ('os_version' in local_var_params and  # noqa: E501
                                                        len(local_var_params['os_version']) > 255):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `os_version` when calling `crash_reports_partial_update`, length must be less than or equal to `255`")  # noqa: E501
        if self.api_client.client_side_validation and ('browser_version' in local_var_params and  # noqa: E501
                                                        len(local_var_params['browser_version']) > 255):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `browser_version` when calling `crash_reports_partial_update`, length must be less than or equal to `255`")  # noqa: E501
        if self.api_client.client_side_validation and ('serial' in local_var_params and  # noqa: E501
                                                        len(local_var_params['serial']) > 255):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `serial` when calling `crash_reports_partial_update`, length must be less than or equal to `255`")  # noqa: E501
        if self.api_client.client_side_validation and ('posthog_session' in local_var_params and  # noqa: E501
                                                        len(local_var_params['posthog_session']) > 255):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `posthog_session` when calling `crash_reports_partial_update`, length must be less than or equal to `255`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}
        if 'description' in local_var_params:
            form_params.append(('description', local_var_params['description']))  # noqa: E501
        if 'email' in local_var_params:
            form_params.append(('email', local_var_params['email']))  # noqa: E501
        if 'os_version' in local_var_params:
            form_params.append(('os_version', local_var_params['os_version']))  # noqa: E501
        if 'os_logs' in local_var_params:
            local_var_files['os_logs'] = local_var_params['os_logs']  # noqa: E501
        if 'browser_version' in local_var_params:
            form_params.append(('browser_version', local_var_params['browser_version']))  # noqa: E501
        if 'browser_logs' in local_var_params:
            local_var_files['browser_logs'] = local_var_params['browser_logs']  # noqa: E501
        if 'serial' in local_var_params:
            form_params.append(('serial', local_var_params['serial']))  # noqa: E501
        if 'posthog_session' in local_var_params:
            form_params.append(('posthog_session', local_var_params['posthog_session']))  # noqa: E501
        if 'status' in local_var_params:
            form_params.append(('status', local_var_params['status']))  # noqa: E501
        if 'support_comment' in local_var_params:
            form_params.append(('support_comment', local_var_params['support_comment']))  # noqa: E501
        if 'pi' in local_var_params:
            form_params.append(('pi', local_var_params['pi']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['multipart/form-data'],
                'PATCH', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['cookieAuth', 'tokenAuth']  # noqa: E501

        response_types_map = {
            202: "CrashReport",
            409: "ErrorDetail",
            400: "ErrorDetail",
            401: "ErrorDetail",
            403: "ErrorDetail",
            500: "ErrorDetail",
        }

        return self.api_client.call_api(
            '/api/crash-reports/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def crash_reports_retrieve(self, id, **kwargs):  # noqa: E501
        """crash_reports_retrieve  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.crash_reports_retrieve(id, async_req=True)
        >>> result = thread.get()

        :param id: A UUID string identifying this crash report. (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CrashReport
        """
        kwargs['_return_http_data_only'] = True
        return self.crash_reports_retrieve_with_http_info(id, **kwargs)  # noqa: E501

    def crash_reports_retrieve_with_http_info(self, id, **kwargs):  # noqa: E501
        """crash_reports_retrieve  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.crash_reports_retrieve_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A UUID string identifying this crash report. (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CrashReport, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method crash_reports_retrieve" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `crash_reports_retrieve`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['cookieAuth', 'tokenAuth']  # noqa: E501

        response_types_map = {
            200: "CrashReport",
        }

        return self.api_client.call_api(
            '/api/crash-reports/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def crash_reports_update(self, id, **kwargs):  # noqa: E501
        """crash_reports_update  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.crash_reports_update(id, async_req=True)
        >>> result = thread.get()

        :param id: A UUID string identifying this crash report. (required)
        :type id: str
        :param description:
        :type description: str
        :param email:
        :type email: str
        :param os_version:
        :type os_version: str
        :param os_logs:
        :type os_logs: file
        :param browser_version:
        :type browser_version: str
        :param browser_logs:
        :type browser_logs: file
        :param serial:
        :type serial: str
        :param posthog_session:
        :type posthog_session: str
        :param status:
        :type status: CrashReportStatusEnum
        :param support_comment:
        :type support_comment: str
        :param pi:
        :type pi: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CrashReport
        """
        kwargs['_return_http_data_only'] = True
        return self.crash_reports_update_with_http_info(id, **kwargs)  # noqa: E501

    def crash_reports_update_with_http_info(self, id, **kwargs):  # noqa: E501
        """crash_reports_update  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.crash_reports_update_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A UUID string identifying this crash report. (required)
        :type id: str
        :param description:
        :type description: str
        :param email:
        :type email: str
        :param os_version:
        :type os_version: str
        :param os_logs:
        :type os_logs: file
        :param browser_version:
        :type browser_version: str
        :param browser_logs:
        :type browser_logs: file
        :param serial:
        :type serial: str
        :param posthog_session:
        :type posthog_session: str
        :param status:
        :type status: CrashReportStatusEnum
        :param support_comment:
        :type support_comment: str
        :param pi:
        :type pi: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CrashReport, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id',
            'description',
            'email',
            'os_version',
            'os_logs',
            'browser_version',
            'browser_logs',
            'serial',
            'posthog_session',
            'status',
            'support_comment',
            'pi'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method crash_reports_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `crash_reports_update`")  # noqa: E501

        if self.api_client.client_side_validation and ('email' in local_var_params and  # noqa: E501
                                                        len(local_var_params['email']) > 254):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `email` when calling `crash_reports_update`, length must be less than or equal to `254`")  # noqa: E501
        if self.api_client.client_side_validation and ('os_version' in local_var_params and  # noqa: E501
                                                        len(local_var_params['os_version']) > 255):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `os_version` when calling `crash_reports_update`, length must be less than or equal to `255`")  # noqa: E501
        if self.api_client.client_side_validation and ('browser_version' in local_var_params and  # noqa: E501
                                                        len(local_var_params['browser_version']) > 255):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `browser_version` when calling `crash_reports_update`, length must be less than or equal to `255`")  # noqa: E501
        if self.api_client.client_side_validation and ('serial' in local_var_params and  # noqa: E501
                                                        len(local_var_params['serial']) > 255):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `serial` when calling `crash_reports_update`, length must be less than or equal to `255`")  # noqa: E501
        if self.api_client.client_side_validation and ('posthog_session' in local_var_params and  # noqa: E501
                                                        len(local_var_params['posthog_session']) > 255):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `posthog_session` when calling `crash_reports_update`, length must be less than or equal to `255`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}
        if 'description' in local_var_params:
            form_params.append(('description', local_var_params['description']))  # noqa: E501
        if 'email' in local_var_params:
            form_params.append(('email', local_var_params['email']))  # noqa: E501
        if 'os_version' in local_var_params:
            form_params.append(('os_version', local_var_params['os_version']))  # noqa: E501
        if 'os_logs' in local_var_params:
            local_var_files['os_logs'] = local_var_params['os_logs']  # noqa: E501
        if 'browser_version' in local_var_params:
            form_params.append(('browser_version', local_var_params['browser_version']))  # noqa: E501
        if 'browser_logs' in local_var_params:
            local_var_files['browser_logs'] = local_var_params['browser_logs']  # noqa: E501
        if 'serial' in local_var_params:
            form_params.append(('serial', local_var_params['serial']))  # noqa: E501
        if 'posthog_session' in local_var_params:
            form_params.append(('posthog_session', local_var_params['posthog_session']))  # noqa: E501
        if 'status' in local_var_params:
            form_params.append(('status', local_var_params['status']))  # noqa: E501
        if 'support_comment' in local_var_params:
            form_params.append(('support_comment', local_var_params['support_comment']))  # noqa: E501
        if 'pi' in local_var_params:
            form_params.append(('pi', local_var_params['pi']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['multipart/form-data'],
                'PUT', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['cookieAuth', 'tokenAuth']  # noqa: E501

        response_types_map = {
            202: "CrashReport",
            409: "ErrorDetail",
            400: "ErrorDetail",
            401: "ErrorDetail",
            403: "ErrorDetail",
            500: "ErrorDetail",
        }

        return self.api_client.call_api(
            '/api/crash-reports/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def video_recordings_create(self, start_dt, name, **kwargs):  # noqa: E501
        """video_recordings_create  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.video_recordings_create(start_dt, name, async_req=True)
        >>> result = thread.get()

        :param start_dt: (required)
        :type start_dt: datetime
        :param name: (required)
        :type name: str
        :param end_dt:
        :type end_dt: datetime
        :param mjr_recording:
        :type mjr_recording: file
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: VideoRecording
        """
        kwargs['_return_http_data_only'] = True
        return self.video_recordings_create_with_http_info(start_dt, name, **kwargs)  # noqa: E501

    def video_recordings_create_with_http_info(self, start_dt, name, **kwargs):  # noqa: E501
        """video_recordings_create  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.video_recordings_create_with_http_info(start_dt, name, async_req=True)
        >>> result = thread.get()

        :param start_dt: (required)
        :type start_dt: datetime
        :param name: (required)
        :type name: str
        :param end_dt:
        :type end_dt: datetime
        :param mjr_recording:
        :type mjr_recording: file
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(VideoRecording, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'start_dt',
            'name',
            'end_dt',
            'mjr_recording'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method video_recordings_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'start_dt' is set
        if self.api_client.client_side_validation and ('start_dt' not in local_var_params or  # noqa: E501
                                                        local_var_params['start_dt'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `start_dt` when calling `video_recordings_create`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `video_recordings_create`")  # noqa: E501

        if self.api_client.client_side_validation and ('name' in local_var_params and  # noqa: E501
                                                        len(local_var_params['name']) > 255):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `name` when calling `video_recordings_create`, length must be less than or equal to `255`")  # noqa: E501
        if self.api_client.client_side_validation and ('name' in local_var_params and  # noqa: E501
                                                        len(local_var_params['name']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `name` when calling `video_recordings_create`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}
        if 'start_dt' in local_var_params:
            form_params.append(('start_dt', local_var_params['start_dt']))  # noqa: E501
        if 'end_dt' in local_var_params:
            form_params.append(('end_dt', local_var_params['end_dt']))  # noqa: E501
        if 'name' in local_var_params:
            form_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'mjr_recording' in local_var_params:
            local_var_files['mjr_recording'] = local_var_params['mjr_recording']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['multipart/form-data'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['cookieAuth', 'tokenAuth']  # noqa: E501

        response_types_map = {
            201: "VideoRecording",
            409: "ErrorDetail",
            400: "ErrorDetail",
            401: "ErrorDetail",
            403: "ErrorDetail",
            500: "ErrorDetail",
        }

        return self.api_client.call_api(
            '/api/video-recordings/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def video_recordings_list(self, **kwargs):  # noqa: E501
        """video_recordings_list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.video_recordings_list(async_req=True)
        >>> result = thread.get()

        :param page: A page number within the paginated result set.
        :type page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PaginatedVideoRecordingList
        """
        kwargs['_return_http_data_only'] = True
        return self.video_recordings_list_with_http_info(**kwargs)  # noqa: E501

    def video_recordings_list_with_http_info(self, **kwargs):  # noqa: E501
        """video_recordings_list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.video_recordings_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param page: A page number within the paginated result set.
        :type page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PaginatedVideoRecordingList, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'page'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method video_recordings_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['cookieAuth', 'tokenAuth']  # noqa: E501

        response_types_map = {
            200: "PaginatedVideoRecordingList",
            400: "ErrorDetail",
            401: "ErrorDetail",
            403: "ErrorDetail",
            500: "ErrorDetail",
        }

        return self.api_client.call_api(
            '/api/video-recordings/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def video_recordings_partial_update(self, id, **kwargs):  # noqa: E501
        """video_recordings_partial_update  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.video_recordings_partial_update(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer value identifying this video recording. (required)
        :type id: int
        :param start_dt:
        :type start_dt: datetime
        :param end_dt:
        :type end_dt: datetime
        :param name:
        :type name: str
        :param mjr_recording:
        :type mjr_recording: file
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: VideoRecording
        """
        kwargs['_return_http_data_only'] = True
        return self.video_recordings_partial_update_with_http_info(id, **kwargs)  # noqa: E501

    def video_recordings_partial_update_with_http_info(self, id, **kwargs):  # noqa: E501
        """video_recordings_partial_update  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.video_recordings_partial_update_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer value identifying this video recording. (required)
        :type id: int
        :param start_dt:
        :type start_dt: datetime
        :param end_dt:
        :type end_dt: datetime
        :param name:
        :type name: str
        :param mjr_recording:
        :type mjr_recording: file
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(VideoRecording, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id',
            'start_dt',
            'end_dt',
            'name',
            'mjr_recording'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method video_recordings_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `video_recordings_partial_update`")  # noqa: E501

        if self.api_client.client_side_validation and ('name' in local_var_params and  # noqa: E501
                                                        len(local_var_params['name']) > 255):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `name` when calling `video_recordings_partial_update`, length must be less than or equal to `255`")  # noqa: E501
        if self.api_client.client_side_validation and ('name' in local_var_params and  # noqa: E501
                                                        len(local_var_params['name']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `name` when calling `video_recordings_partial_update`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}
        if 'start_dt' in local_var_params:
            form_params.append(('start_dt', local_var_params['start_dt']))  # noqa: E501
        if 'end_dt' in local_var_params:
            form_params.append(('end_dt', local_var_params['end_dt']))  # noqa: E501
        if 'name' in local_var_params:
            form_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'mjr_recording' in local_var_params:
            local_var_files['mjr_recording'] = local_var_params['mjr_recording']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['multipart/form-data'],
                'PATCH', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['cookieAuth', 'tokenAuth']  # noqa: E501

        response_types_map = {
            202: "VideoRecording",
            409: "ErrorDetail",
            400: "ErrorDetail",
            401: "ErrorDetail",
            403: "ErrorDetail",
            500: "ErrorDetail",
        }

        return self.api_client.call_api(
            '/api/video-recordings/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def video_recordings_update(self, id, start_dt, name, **kwargs):  # noqa: E501
        """video_recordings_update  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.video_recordings_update(id, start_dt, name, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer value identifying this video recording. (required)
        :type id: int
        :param start_dt: (required)
        :type start_dt: datetime
        :param name: (required)
        :type name: str
        :param end_dt:
        :type end_dt: datetime
        :param mjr_recording:
        :type mjr_recording: file
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: VideoRecording
        """
        kwargs['_return_http_data_only'] = True
        return self.video_recordings_update_with_http_info(id, start_dt, name, **kwargs)  # noqa: E501

    def video_recordings_update_with_http_info(self, id, start_dt, name, **kwargs):  # noqa: E501
        """video_recordings_update  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.video_recordings_update_with_http_info(id, start_dt, name, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer value identifying this video recording. (required)
        :type id: int
        :param start_dt: (required)
        :type start_dt: datetime
        :param name: (required)
        :type name: str
        :param end_dt:
        :type end_dt: datetime
        :param mjr_recording:
        :type mjr_recording: file
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(VideoRecording, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id',
            'start_dt',
            'name',
            'end_dt',
            'mjr_recording'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method video_recordings_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `video_recordings_update`")  # noqa: E501
        # verify the required parameter 'start_dt' is set
        if self.api_client.client_side_validation and ('start_dt' not in local_var_params or  # noqa: E501
                                                        local_var_params['start_dt'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `start_dt` when calling `video_recordings_update`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `video_recordings_update`")  # noqa: E501

        if self.api_client.client_side_validation and ('name' in local_var_params and  # noqa: E501
                                                        len(local_var_params['name']) > 255):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `name` when calling `video_recordings_update`, length must be less than or equal to `255`")  # noqa: E501
        if self.api_client.client_side_validation and ('name' in local_var_params and  # noqa: E501
                                                        len(local_var_params['name']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `name` when calling `video_recordings_update`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}
        if 'start_dt' in local_var_params:
            form_params.append(('start_dt', local_var_params['start_dt']))  # noqa: E501
        if 'end_dt' in local_var_params:
            form_params.append(('end_dt', local_var_params['end_dt']))  # noqa: E501
        if 'name' in local_var_params:
            form_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'mjr_recording' in local_var_params:
            local_var_files['mjr_recording'] = local_var_params['mjr_recording']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['multipart/form-data'],
                'PUT', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['cookieAuth', 'tokenAuth']  # noqa: E501

        response_types_map = {
            202: "VideoRecording",
            409: "ErrorDetail",
            400: "ErrorDetail",
            401: "ErrorDetail",
            403: "ErrorDetail",
            500: "ErrorDetail",
        }

        return self.api_client.call_api(
            '/api/video-recordings/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
