import esphome.codegen as cg
import esphome.config_validation as cv
from esphome import automation
from esphome.components import output
from esphome.const import CONF_ID, CONF_TYPE, CONF_BINARY
from .. import template_ns

TemplateBinaryOutput = template_ns.class_('TemplateBinaryOutput', output.BinaryOutput)
TemplateFloatOutput = template_ns.class_('TemplateFloatOutput', output.FloatOutput)

CONF_FLOAT = 'float'
CONF_WRITE_ACTION = 'write_action'

CONFIG_SCHEMA = cv.typed_schema({
    CONF_BINARY: output.BINARY_OUTPUT_SCHEMA.extend({
        cv.GenerateID(): cv.declare_id(TemplateBinaryOutput),
        cv.Required(CONF_WRITE_ACTION): automation.validate_automation(single=True),
    }),
    CONF_FLOAT: output.FLOAT_OUTPUT_SCHEMA.extend({
        cv.GenerateID(): cv.declare_id(TemplateFloatOutput),
        cv.Required(CONF_WRITE_ACTION): automation.validate_automation(single=True),
    }),
}, lower=True)


def to_code(config):
    var = cg.new_Pvariable(config[CONF_ID])
    if config[CONF_TYPE] == CONF_BINARY:
        yield automation.build_automation(var.get_trigger(), [(bool, 'state')],
                                          config[CONF_WRITE_ACTION])
    else:
        yield automation.build_automation(var.get_trigger(), [(float, 'state')],
                                          config[CONF_WRITE_ACTION])
    yield output.register_output(var, config)
