"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkloadScheduling = exports.Workload = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s_1 = require("cdk8s");
const pod = require("./pod");
const utils_1 = require("./utils");
/**
 * A workload is an application running on Kubernetes. Whether your workload is a single
 * component or several that work together, on Kubernetes you run it inside a set of pods.
 * In Kubernetes, a Pod represents a set of running containers on your cluster.
 */
class Workload extends pod.AbstractPod {
    constructor(scope, id, props = {}) {
        super(scope, id, props);
        this._matchLabels = {};
        this._matchExpressions = [];
        this.podMetadata = new cdk8s_1.ApiObjectMetadataDefinition(props.podMetadata);
        this.scheduling = new WorkloadScheduling(this);
        this.connections = new pod.PodConnections(this);
        const matcher = cdk8s_1.Names.toLabelValue(this);
        this.podMetadata.addLabel(pod.Pod.ADDRESS_LABEL, matcher);
        if (props.select ?? true) {
            this.select(pod.LabelSelector.of({ labels: { [pod.Pod.ADDRESS_LABEL]: matcher } }));
        }
    }
    /**
     * Configure selectors for this workload.
     */
    select(...selectors) {
        for (const selector of selectors) {
            const kube = selector._toKube();
            this._matchExpressions.push(...kube.matchExpressions ?? []);
            for (const [key, value] of Object.entries(kube.matchLabels ?? {})) {
                this._matchLabels[key] = value;
            }
        }
    }
    /**
     * The label matchers this workload will use in order to select pods.
     *
     * Returns a a copy. Use `select()` to add label matchers.
     */
    get matchLabels() {
        return { ...this._matchLabels };
    }
    /**
     * The expression matchers this workload will use in order to select pods.
     *
     * Returns a a copy. Use `select()` to add expression matchers.
     */
    get matchExpressions() {
        return [...this._matchExpressions];
    }
    /**
     * @internal
     */
    _toLabelSelector() {
        return {
            matchExpressions: utils_1.undefinedIfEmpty(this._matchExpressions),
            matchLabels: utils_1.undefinedIfEmpty(this._matchLabels),
        };
    }
    /**
     * @internal
     */
    _toPodSpec() {
        const scheduling = this.scheduling._toKube();
        return {
            ...super._toPodSpec(),
            affinity: scheduling.affinity,
            nodeName: scheduling.nodeName,
            tolerations: scheduling.tolerations,
        };
    }
}
exports.Workload = Workload;
_a = JSII_RTTI_SYMBOL_1;
Workload[_a] = { fqn: "cdk8s-plus-22.Workload", version: "2.0.0-rc.52" };
/**
 * Controls the pod scheduling strategy of this workload.
 * It offers some additional API's on top of the core pod scheduling.
 */
class WorkloadScheduling extends pod.PodScheduling {
    /**
     * Spread the pods in this workload by the topology key.
     * A spread is a separation of the pod from itself and is used to
     * balance out pod replicas across a given topology.
     */
    spread(options = {}) {
        this.separate(this.instance, { weight: options.weight, topology: options.topology ?? pod.Topology.HOSTNAME });
    }
}
exports.WorkloadScheduling = WorkloadScheduling;
_b = JSII_RTTI_SYMBOL_1;
WorkloadScheduling[_b] = { fqn: "cdk8s-plus-22.WorkloadScheduling", version: "2.0.0-rc.52" };
//# sourceMappingURL=data:application/json;base64,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