"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.address = exports.filterUndefined = exports.undefinedIfEmpty = void 0;
function undefinedIfEmpty(obj) {
    if (typeof (obj) === 'string' && obj === '') {
        return undefined;
    }
    if (Array.isArray(obj) && obj.length === 0) {
        return undefined;
    }
    if (typeof (obj) === 'object' && (Object.keys(obj).length === 0 || Object.values(obj).filter(x => x).length === 0)) {
        return undefined;
    }
    return obj;
}
exports.undefinedIfEmpty = undefinedIfEmpty;
function filterUndefined(obj) {
    const ret = {};
    for (const [k, v] of Object.entries(obj)) {
        if (v !== undefined) {
            ret[k] = v;
        }
    }
    return ret;
}
exports.filterUndefined = filterUndefined;
function address(...constructs) {
    const addresses = constructs
        .map(c => c.node.addr)
        .sort((a, b) => a.localeCompare(b));
    return addresses.join('');
}
exports.address = address;
//# sourceMappingURL=data:application/json;base64,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