"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmrContainersCreateVirtualCluster = exports.EksClusterInput = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const sfn = require("@aws-cdk/aws-stepfunctions");
const core_1 = require("@aws-cdk/core");
const task_utils_1 = require("../private/task-utils");
/**
 * Class for supported types of EMR Containers' Container Providers
 */
var ContainerProviderTypes;
(function (ContainerProviderTypes) {
    /**
     * Supported container provider type for a EKS Cluster
     */
    ContainerProviderTypes["EKS"] = "EKS";
})(ContainerProviderTypes || (ContainerProviderTypes = {}));
/**
 * Class that supports methods which return the EKS cluster name depending on input type.
 *
 * @stability stable
 */
class EksClusterInput {
    /**
     * Initializes the clusterName
     *
     * @param clusterName The name of the EKS Cluster
     */
    constructor(clusterName) {
        this.clusterName = clusterName;
    }
    /**
     * Specify an existing EKS Cluster as the name for this Cluster.
     *
     * @stability stable
     */
    static fromCluster(cluster) {
        return new EksClusterInput(cluster.clusterName);
    }
    /**
     * Specify a Task Input as the name for this Cluster.
     *
     * @stability stable
     */
    static fromTaskInput(taskInput) {
        return new EksClusterInput(taskInput.value);
    }
}
exports.EksClusterInput = EksClusterInput;
_a = JSII_RTTI_SYMBOL_1;
EksClusterInput[_a] = { fqn: "@aws-cdk/aws-stepfunctions-tasks.EksClusterInput", version: "1.144.0" };
/**
 * Task that creates an EMR Containers virtual cluster from an EKS cluster.
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-emr-eks.html
 * @stability stable
 */
class EmrContainersCreateVirtualCluster extends sfn.TaskStateBase {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _c;
        super(scope, id, props);
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_tasks_EmrContainersCreateVirtualClusterProps(props);
        this.integrationPattern = (_c = props.integrationPattern) !== null && _c !== void 0 ? _c : sfn.IntegrationPattern.REQUEST_RESPONSE;
        task_utils_1.validatePatternSupported(this.integrationPattern, EmrContainersCreateVirtualCluster.SUPPORTED_INTEGRATION_PATTERNS);
        this.taskPolicies = this.createPolicyStatements();
    }
    /**
     * @internal
     */
    _renderTask() {
        var _c, _d;
        return {
            Resource: task_utils_1.integrationResourceArn('emr-containers', 'createVirtualCluster', this.integrationPattern),
            Parameters: sfn.FieldUtils.renderObject({
                Name: (_c = this.props.virtualClusterName) !== null && _c !== void 0 ? _c : sfn.JsonPath.stringAt('States.Format(\'{}/{}\', $$.Execution.Name, $$.State.Name)'),
                ContainerProvider: {
                    Id: this.props.eksCluster.clusterName,
                    Info: {
                        EksInfo: {
                            Namespace: (_d = this.props.eksNamespace) !== null && _d !== void 0 ? _d : 'default',
                        },
                    },
                    Type: ContainerProviderTypes.EKS,
                },
                Tags: this.props.tags,
            }),
        };
    }
    ;
    createPolicyStatements() {
        return [
            new iam.PolicyStatement({
                resources: ['*'],
                actions: ['emr-containers:CreateVirtualCluster'],
            }),
            new iam.PolicyStatement({
                resources: [
                    core_1.Stack.of(this).formatArn({
                        service: 'iam',
                        region: '',
                        resource: 'role/aws-service-role/emr-containers.amazonaws.com',
                        resourceName: 'AWSServiceRoleForAmazonEMRContainers',
                    }),
                ],
                actions: ['iam:CreateServiceLinkedRole'],
                conditions: {
                    StringLike: { 'iam:AWSServiceName': 'emr-containers.amazonaws.com' },
                },
            }),
        ];
    }
}
exports.EmrContainersCreateVirtualCluster = EmrContainersCreateVirtualCluster;
_b = JSII_RTTI_SYMBOL_1;
EmrContainersCreateVirtualCluster[_b] = { fqn: "@aws-cdk/aws-stepfunctions-tasks.EmrContainersCreateVirtualCluster", version: "1.144.0" };
EmrContainersCreateVirtualCluster.SUPPORTED_INTEGRATION_PATTERNS = [
    sfn.IntegrationPattern.REQUEST_RESPONSE,
];
//# sourceMappingURL=data:application/json;base64,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