# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['Pool']


class Pool(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_state_up: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 lb_method: Optional[pulumi.Input[str]] = None,
                 listener_id: Optional[pulumi.Input[str]] = None,
                 loadbalancer_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 persistence: Optional[pulumi.Input[pulumi.InputType['PoolPersistenceArgs']]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Manages a V2 pool resource within OpenStack.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        pool1 = openstack.loadbalancer.Pool("pool1",
            lb_method="ROUND_ROBIN",
            listener_id="d9415786-5f1a-428b-b35f-2f1523e146d2",
            persistence=openstack.loadbalancer.PoolPersistenceArgs(
                cookie_name="testCookie",
                type="APP_COOKIE",
            ),
            protocol="HTTP")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] admin_state_up: The administrative state of the pool.
               A valid value is true (UP) or false (DOWN).
        :param pulumi.Input[str] description: Human-readable description for the pool.
        :param pulumi.Input[str] lb_method: The load balancing algorithm to
               distribute traffic to the pool's members. Must be one of
               ROUND_ROBIN, LEAST_CONNECTIONS, SOURCE_IP, or SOURCE_IP_PORT (supported only
               in Octavia).
        :param pulumi.Input[str] listener_id: The Listener on which the members of the pool
               will be associated with. Changing this creates a new pool.
               Note:  One of LoadbalancerID or ListenerID must be provided.
        :param pulumi.Input[str] loadbalancer_id: The load balancer on which to provision this
               pool. Changing this creates a new pool.
               Note:  One of LoadbalancerID or ListenerID must be provided.
        :param pulumi.Input[str] name: Human-readable name for the pool.
        :param pulumi.Input[pulumi.InputType['PoolPersistenceArgs']] persistence: Omit this field to prevent session persistence.  Indicates
               whether connections in the same session will be processed by the same Pool
               member or not. Changing this creates a new pool.
        :param pulumi.Input[str] protocol: The protocol - can either be TCP, HTTP, HTTPS, PROXY
               or UDP (supported only in Octavia). Changing this creates a new pool.
        :param pulumi.Input[str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create an . If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               pool.
        :param pulumi.Input[str] tenant_id: Required for admins. The UUID of the tenant who owns
               the pool.  Only administrative users can specify a tenant UUID
               other than their own. Changing this creates a new pool.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['admin_state_up'] = admin_state_up
            __props__['description'] = description
            if lb_method is None:
                raise TypeError("Missing required property 'lb_method'")
            __props__['lb_method'] = lb_method
            __props__['listener_id'] = listener_id
            __props__['loadbalancer_id'] = loadbalancer_id
            __props__['name'] = name
            __props__['persistence'] = persistence
            if protocol is None:
                raise TypeError("Missing required property 'protocol'")
            __props__['protocol'] = protocol
            __props__['region'] = region
            __props__['tenant_id'] = tenant_id
        super(Pool, __self__).__init__(
            'openstack:loadbalancer/pool:Pool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_state_up: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            lb_method: Optional[pulumi.Input[str]] = None,
            listener_id: Optional[pulumi.Input[str]] = None,
            loadbalancer_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            persistence: Optional[pulumi.Input[pulumi.InputType['PoolPersistenceArgs']]] = None,
            protocol: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None) -> 'Pool':
        """
        Get an existing Pool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] admin_state_up: The administrative state of the pool.
               A valid value is true (UP) or false (DOWN).
        :param pulumi.Input[str] description: Human-readable description for the pool.
        :param pulumi.Input[str] lb_method: The load balancing algorithm to
               distribute traffic to the pool's members. Must be one of
               ROUND_ROBIN, LEAST_CONNECTIONS, SOURCE_IP, or SOURCE_IP_PORT (supported only
               in Octavia).
        :param pulumi.Input[str] listener_id: The Listener on which the members of the pool
               will be associated with. Changing this creates a new pool.
               Note:  One of LoadbalancerID or ListenerID must be provided.
        :param pulumi.Input[str] loadbalancer_id: The load balancer on which to provision this
               pool. Changing this creates a new pool.
               Note:  One of LoadbalancerID or ListenerID must be provided.
        :param pulumi.Input[str] name: Human-readable name for the pool.
        :param pulumi.Input[pulumi.InputType['PoolPersistenceArgs']] persistence: Omit this field to prevent session persistence.  Indicates
               whether connections in the same session will be processed by the same Pool
               member or not. Changing this creates a new pool.
        :param pulumi.Input[str] protocol: The protocol - can either be TCP, HTTP, HTTPS, PROXY
               or UDP (supported only in Octavia). Changing this creates a new pool.
        :param pulumi.Input[str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create an . If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               pool.
        :param pulumi.Input[str] tenant_id: Required for admins. The UUID of the tenant who owns
               the pool.  Only administrative users can specify a tenant UUID
               other than their own. Changing this creates a new pool.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["admin_state_up"] = admin_state_up
        __props__["description"] = description
        __props__["lb_method"] = lb_method
        __props__["listener_id"] = listener_id
        __props__["loadbalancer_id"] = loadbalancer_id
        __props__["name"] = name
        __props__["persistence"] = persistence
        __props__["protocol"] = protocol
        __props__["region"] = region
        __props__["tenant_id"] = tenant_id
        return Pool(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="adminStateUp")
    def admin_state_up(self) -> pulumi.Output[Optional[bool]]:
        """
        The administrative state of the pool.
        A valid value is true (UP) or false (DOWN).
        """
        return pulumi.get(self, "admin_state_up")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Human-readable description for the pool.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="lbMethod")
    def lb_method(self) -> pulumi.Output[str]:
        """
        The load balancing algorithm to
        distribute traffic to the pool's members. Must be one of
        ROUND_ROBIN, LEAST_CONNECTIONS, SOURCE_IP, or SOURCE_IP_PORT (supported only
        in Octavia).
        """
        return pulumi.get(self, "lb_method")

    @property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> pulumi.Output[Optional[str]]:
        """
        The Listener on which the members of the pool
        will be associated with. Changing this creates a new pool.
        Note:  One of LoadbalancerID or ListenerID must be provided.
        """
        return pulumi.get(self, "listener_id")

    @property
    @pulumi.getter(name="loadbalancerId")
    def loadbalancer_id(self) -> pulumi.Output[Optional[str]]:
        """
        The load balancer on which to provision this
        pool. Changing this creates a new pool.
        Note:  One of LoadbalancerID or ListenerID must be provided.
        """
        return pulumi.get(self, "loadbalancer_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Human-readable name for the pool.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def persistence(self) -> pulumi.Output['outputs.PoolPersistence']:
        """
        Omit this field to prevent session persistence.  Indicates
        whether connections in the same session will be processed by the same Pool
        member or not. Changing this creates a new pool.
        """
        return pulumi.get(self, "persistence")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[str]:
        """
        The protocol - can either be TCP, HTTP, HTTPS, PROXY
        or UDP (supported only in Octavia). Changing this creates a new pool.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to obtain the V2 Networking client.
        A Networking client is needed to create an . If omitted, the
        `region` argument of the provider is used. Changing this creates a new
        pool.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        Required for admins. The UUID of the tenant who owns
        the pool.  Only administrative users can specify a tenant UUID
        other than their own. Changing this creates a new pool.
        """
        return pulumi.get(self, "tenant_id")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

