# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables

__all__ = ['Member']


class Member(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[str]] = None,
                 admin_state_up: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 pool_id: Optional[pulumi.Input[str]] = None,
                 protocol_port: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 weight: Optional[pulumi.Input[int]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Manages a V2 member resource within OpenStack.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        member1 = openstack.loadbalancer.Member("member1",
            address="192.168.199.23",
            pool_id="935685fb-a896-40f9-9ff4-ae531a3a00fe",
            protocol_port=8080)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] address: The IP address of the member to receive traffic from
               the load balancer. Changing this creates a new member.
        :param pulumi.Input[bool] admin_state_up: The administrative state of the member.
               A valid value is true (UP) or false (DOWN). Defaults to true.
        :param pulumi.Input[str] name: Human-readable name for the member.
        :param pulumi.Input[str] pool_id: The id of the pool that this member will be assigned
               to. Changing this creates a new member.
        :param pulumi.Input[int] protocol_port: The port on which to listen for client traffic.
               Changing this creates a new member.
        :param pulumi.Input[str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create a member. If omitted, the `region`
               argument of the provider is used. Changing this creates a new member.
        :param pulumi.Input[str] subnet_id: The subnet in which to access the member. Changing
               this creates a new member.
        :param pulumi.Input[str] tenant_id: Required for admins. The UUID of the tenant who owns
               the member.  Only administrative users can specify a tenant UUID
               other than their own. Changing this creates a new member.
        :param pulumi.Input[int] weight: A positive integer value that indicates the relative
               portion of traffic that this member should receive from the pool. For
               example, a member with a weight of 10 receives five times as much traffic
               as a member with a weight of 2. Defaults to 1.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if address is None:
                raise TypeError("Missing required property 'address'")
            __props__['address'] = address
            __props__['admin_state_up'] = admin_state_up
            __props__['name'] = name
            if pool_id is None:
                raise TypeError("Missing required property 'pool_id'")
            __props__['pool_id'] = pool_id
            if protocol_port is None:
                raise TypeError("Missing required property 'protocol_port'")
            __props__['protocol_port'] = protocol_port
            __props__['region'] = region
            __props__['subnet_id'] = subnet_id
            __props__['tenant_id'] = tenant_id
            __props__['weight'] = weight
        super(Member, __self__).__init__(
            'openstack:loadbalancer/member:Member',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address: Optional[pulumi.Input[str]] = None,
            admin_state_up: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            pool_id: Optional[pulumi.Input[str]] = None,
            protocol_port: Optional[pulumi.Input[int]] = None,
            region: Optional[pulumi.Input[str]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            weight: Optional[pulumi.Input[int]] = None) -> 'Member':
        """
        Get an existing Member resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] address: The IP address of the member to receive traffic from
               the load balancer. Changing this creates a new member.
        :param pulumi.Input[bool] admin_state_up: The administrative state of the member.
               A valid value is true (UP) or false (DOWN). Defaults to true.
        :param pulumi.Input[str] name: Human-readable name for the member.
        :param pulumi.Input[str] pool_id: The id of the pool that this member will be assigned
               to. Changing this creates a new member.
        :param pulumi.Input[int] protocol_port: The port on which to listen for client traffic.
               Changing this creates a new member.
        :param pulumi.Input[str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create a member. If omitted, the `region`
               argument of the provider is used. Changing this creates a new member.
        :param pulumi.Input[str] subnet_id: The subnet in which to access the member. Changing
               this creates a new member.
        :param pulumi.Input[str] tenant_id: Required for admins. The UUID of the tenant who owns
               the member.  Only administrative users can specify a tenant UUID
               other than their own. Changing this creates a new member.
        :param pulumi.Input[int] weight: A positive integer value that indicates the relative
               portion of traffic that this member should receive from the pool. For
               example, a member with a weight of 10 receives five times as much traffic
               as a member with a weight of 2. Defaults to 1.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["address"] = address
        __props__["admin_state_up"] = admin_state_up
        __props__["name"] = name
        __props__["pool_id"] = pool_id
        __props__["protocol_port"] = protocol_port
        __props__["region"] = region
        __props__["subnet_id"] = subnet_id
        __props__["tenant_id"] = tenant_id
        __props__["weight"] = weight
        return Member(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Output[str]:
        """
        The IP address of the member to receive traffic from
        the load balancer. Changing this creates a new member.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="adminStateUp")
    def admin_state_up(self) -> pulumi.Output[Optional[bool]]:
        """
        The administrative state of the member.
        A valid value is true (UP) or false (DOWN). Defaults to true.
        """
        return pulumi.get(self, "admin_state_up")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Human-readable name for the member.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="poolId")
    def pool_id(self) -> pulumi.Output[str]:
        """
        The id of the pool that this member will be assigned
        to. Changing this creates a new member.
        """
        return pulumi.get(self, "pool_id")

    @property
    @pulumi.getter(name="protocolPort")
    def protocol_port(self) -> pulumi.Output[int]:
        """
        The port on which to listen for client traffic.
        Changing this creates a new member.
        """
        return pulumi.get(self, "protocol_port")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to obtain the V2 Networking client.
        A Networking client is needed to create a member. If omitted, the `region`
        argument of the provider is used. Changing this creates a new member.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[Optional[str]]:
        """
        The subnet in which to access the member. Changing
        this creates a new member.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        Required for admins. The UUID of the tenant who owns
        the member.  Only administrative users can specify a tenant UUID
        other than their own. Changing this creates a new member.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def weight(self) -> pulumi.Output[int]:
        """
        A positive integer value that indicates the relative
        portion of traffic that this member should receive from the pool. For
        example, a member with a weight of 10 receives five times as much traffic
        as a member with a weight of 2. Defaults to 1.
        """
        return pulumi.get(self, "weight")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

