# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['Instance']


class Instance(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration_id: Optional[pulumi.Input[str]] = None,
                 databases: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceDatabaseArgs']]]]] = None,
                 datastore: Optional[pulumi.Input[pulumi.InputType['InstanceDatastoreArgs']]] = None,
                 flavor_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceNetworkArgs']]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceUserArgs']]]]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Manages a V1 DB instance resource within OpenStack.

        ## Example Usage
        ### Instance

        ```python
        import pulumi
        import pulumi_openstack as openstack

        test = openstack.database.Instance("test",
            datastore=openstack.database.InstanceDatastoreArgs(
                type="mysql",
                version="mysql-5.7",
            ),
            flavor_id="31792d21-c355-4587-9290-56c1ed0ca376",
            networks=[openstack.database.InstanceNetworkArgs(
                uuid="c0612505-caf2-4fb0-b7cb-56a0240a2b12",
            )],
            region="region-test",
            size=8)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] configuration_id: Configuration ID to be attached to the instance. Database instance
               will be rebooted when configuration is detached.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceDatabaseArgs']]]] databases: An array of database name, charset and collate. The database
               object structure is documented below.
        :param pulumi.Input[pulumi.InputType['InstanceDatastoreArgs']] datastore: An array of database engine type and version. The datastore
               object structure is documented below. Changing this creates a new instance.
        :param pulumi.Input[str] flavor_id: The flavor ID of the desired flavor for the instance.
               Changing this creates new instance.
        :param pulumi.Input[str] name: Database to be created on new instance. Changing this creates a
               new instance.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceNetworkArgs']]]] networks: An array of one or more networks to attach to the
               instance. The network object structure is documented below. Changing this
               creates a new instance.
        :param pulumi.Input[str] region: The region in which to create the db instance. Changing this
               creates a new instance.
        :param pulumi.Input[int] size: Specifies the volume size in GB. Changing this creates new instance.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceUserArgs']]]] users: An array of username, password, host and databases. The user
               object structure is documented below.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['configuration_id'] = configuration_id
            __props__['databases'] = databases
            if datastore is None:
                raise TypeError("Missing required property 'datastore'")
            __props__['datastore'] = datastore
            __props__['flavor_id'] = flavor_id
            __props__['name'] = name
            __props__['networks'] = networks
            __props__['region'] = region
            if size is None:
                raise TypeError("Missing required property 'size'")
            __props__['size'] = size
            __props__['users'] = users
        super(Instance, __self__).__init__(
            'openstack:database/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            configuration_id: Optional[pulumi.Input[str]] = None,
            databases: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceDatabaseArgs']]]]] = None,
            datastore: Optional[pulumi.Input[pulumi.InputType['InstanceDatastoreArgs']]] = None,
            flavor_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            networks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceNetworkArgs']]]]] = None,
            region: Optional[pulumi.Input[str]] = None,
            size: Optional[pulumi.Input[int]] = None,
            users: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceUserArgs']]]]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] configuration_id: Configuration ID to be attached to the instance. Database instance
               will be rebooted when configuration is detached.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceDatabaseArgs']]]] databases: An array of database name, charset and collate. The database
               object structure is documented below.
        :param pulumi.Input[pulumi.InputType['InstanceDatastoreArgs']] datastore: An array of database engine type and version. The datastore
               object structure is documented below. Changing this creates a new instance.
        :param pulumi.Input[str] flavor_id: The flavor ID of the desired flavor for the instance.
               Changing this creates new instance.
        :param pulumi.Input[str] name: Database to be created on new instance. Changing this creates a
               new instance.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceNetworkArgs']]]] networks: An array of one or more networks to attach to the
               instance. The network object structure is documented below. Changing this
               creates a new instance.
        :param pulumi.Input[str] region: The region in which to create the db instance. Changing this
               creates a new instance.
        :param pulumi.Input[int] size: Specifies the volume size in GB. Changing this creates new instance.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceUserArgs']]]] users: An array of username, password, host and databases. The user
               object structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["configuration_id"] = configuration_id
        __props__["databases"] = databases
        __props__["datastore"] = datastore
        __props__["flavor_id"] = flavor_id
        __props__["name"] = name
        __props__["networks"] = networks
        __props__["region"] = region
        __props__["size"] = size
        __props__["users"] = users
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="configurationId")
    def configuration_id(self) -> pulumi.Output[Optional[str]]:
        """
        Configuration ID to be attached to the instance. Database instance
        will be rebooted when configuration is detached.
        """
        return pulumi.get(self, "configuration_id")

    @property
    @pulumi.getter
    def databases(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceDatabase']]]:
        """
        An array of database name, charset and collate. The database
        object structure is documented below.
        """
        return pulumi.get(self, "databases")

    @property
    @pulumi.getter
    def datastore(self) -> pulumi.Output['outputs.InstanceDatastore']:
        """
        An array of database engine type and version. The datastore
        object structure is documented below. Changing this creates a new instance.
        """
        return pulumi.get(self, "datastore")

    @property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> pulumi.Output[str]:
        """
        The flavor ID of the desired flavor for the instance.
        Changing this creates new instance.
        """
        return pulumi.get(self, "flavor_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Database to be created on new instance. Changing this creates a
        new instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def networks(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceNetwork']]]:
        """
        An array of one or more networks to attach to the
        instance. The network object structure is documented below. Changing this
        creates a new instance.
        """
        return pulumi.get(self, "networks")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the db instance. Changing this
        creates a new instance.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def size(self) -> pulumi.Output[int]:
        """
        Specifies the volume size in GB. Changing this creates new instance.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def users(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceUser']]]:
        """
        An array of username, password, host and databases. The user
        object structure is documented below.
        """
        return pulumi.get(self, "users")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

